/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchiveEntry;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.command.dexer.DxContext;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.utils.PathUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class DexArchiveBuilderCallable
implements Callable<List<DexArchiveEntry>> {
    private final Map<Path, byte[]> pathToContent;
    private final DxContext dxContext;
    private final DexOptions dexOptions;
    private final CfOptions cfOptions;

    public DexArchiveBuilderCallable(Map<Path, byte[]> pathToContent, DxContext dxContext, DexOptions dexOptions, CfOptions cfOptions) {
        this.pathToContent = pathToContent;
        this.dxContext = dxContext;
        this.dexOptions = dexOptions;
        this.cfOptions = cfOptions;
    }

    @Override
    public List<DexArchiveEntry> call() throws Exception {
        ArrayList<DexArchiveEntry> res = new ArrayList<DexArchiveEntry>(this.pathToContent.size());
        for (Map.Entry<Path, byte[]> e : this.pathToContent.entrySet()) {
            Path relativePath = e.getKey();
            byte[] classFileContent = e.getValue();
            String unixClassFile = PathUtils.toSystemIndependentPath((Path)relativePath);
            DirectClassFile directClassFile = DexArchiveBuilderCallable.parseClass(unixClassFile, classFileContent);
            DexFile dexFile = new DexFile(this.dexOptions);
            this.translateClass(classFileContent, directClassFile, dexFile);
            byte[] dexClassContent = dexFile.toDex(null, false);
            res.add(new DexArchiveEntry(dexClassContent, relativePath));
        }
        return res;
    }

    private static DirectClassFile parseClass(String name, byte[] bytes) {
        DirectClassFile cf = new DirectClassFile(bytes, name, true);
        cf.setAttributeFactory(StdAttributeFactory.THE_ONE);
        cf.getMagic();
        return cf;
    }

    private void translateClass(byte[] bytes, DirectClassFile cf, DexFile dexFile) {
        ClassDefItem classDefItem = CfTranslator.translate(this.dxContext, cf, bytes, this.cfOptions, this.dexOptions, dexFile);
        dexFile.add(classDefItem);
    }
}

