/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

final class DirClassFileInputs
implements ClassFileInput {
    private final Path rootPath;
    private final Predicate<Path> filter;

    public DirClassFileInputs(Path rootPath, Predicate<Path> relativePath) {
        this.rootPath = rootPath;
        this.filter = relativePath;
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public Iterator<ClassFileEntry> iterator() {
        try {
            return Files.walk(this.rootPath, new FileVisitOption[0]).filter(this.filter).map(this::createEntryFromPath).iterator();
        }
        catch (IOException e) {
            throw new DirClassFileInputsException("Unable to read directory class input " + this.rootPath.toString(), e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<ClassFileEntry> allEntries() {
        return Lists.newLinkedList((Iterable)this);
    }

    private ClassFileEntry createEntryFromPath(Path path) {
        try {
            return new ClassFileEntry(this.rootPath.relativize(path), Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new DirClassFileInputsException("Unable to read file " + path.toString(), e);
        }
    }

    public static final class DirClassFileInputsException
    extends RuntimeException {
        public DirClassFileInputsException(String s, IOException e) {
            super(s, e);
        }
    }
}

