/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AbstractAapt;
import com.android.builder.internal.aapt.v2.AaptV2CommandBuilder;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.tools.aapt2.Aapt2Jni;
import com.android.tools.aapt2.Aapt2RenamingConventions;
import com.android.tools.aapt2.Aapt2Result;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.List;
import java.util.concurrent.Future;

public class AaptV2Jni
extends AbstractAapt {
    private final File intermediateDir;
    private final ProcessOutputHandler processOutputHandler;
    private final WaitableExecutor executor;

    public AaptV2Jni(File intermediateDir, WaitableExecutor executor, ProcessOutputHandler processOutputHandler) {
        this.intermediateDir = intermediateDir;
        this.executor = executor;
        this.processOutputHandler = processOutputHandler;
    }

    @Override
    protected ListenableFuture<Void> makeValidatedPackage(AaptPackageConfig config) throws AaptException {
        if (config.getResourceOutputApk() != null) {
            try {
                Files.deleteIfExists(config.getResourceOutputApk().toPath());
            }
            catch (IOException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        ImmutableList<String> args = AaptV2CommandBuilder.makeLink(config, this.intermediateDir);
        Aapt2Result aapt2Result = Aapt2Jni.link(args);
        AaptV2Jni.writeMessages(this.processOutputHandler, aapt2Result.getMessages());
        if (aapt2Result.getReturnCode() == 0) {
            return Futures.immediateFuture(null);
        }
        return Futures.immediateFailedFuture((Throwable)AaptV2Jni.buildException("link", args, aapt2Result));
    }

    public Future<File> compile(CompileResourceRequest request) throws Exception {
        return this.executor.execute(() -> {
            ImmutableList<String> args = AaptV2CommandBuilder.makeCompile(request);
            Aapt2Result aapt2Result = Aapt2Jni.compile(args);
            AaptV2Jni.writeMessages(this.processOutputHandler, aapt2Result.getMessages());
            if (aapt2Result.getReturnCode() == 0) {
                return new File(request.getOutput(), Aapt2RenamingConventions.compilationRename(request.getInput()));
            }
            throw AaptV2Jni.buildException("compile", args, aapt2Result);
        });
    }

    public void start() {
    }

    public void end() throws InterruptedException {
    }

    public File compileOutputFor(CompileResourceRequest request) {
        return new File(request.getOutput(), Aapt2RenamingConventions.compilationRename(request.getInput()));
    }

    private static AaptException buildException(String action, List<String> args, Aapt2Result aapt2Result) {
        StringBuilder builder = new StringBuilder();
        builder.append("AAPT2 ").append(action).append(" failed:\naapt2 ").append(action).append(" ").append(Joiner.on((char)' ').join(args)).append("\n");
        if (aapt2Result.getMessages().isEmpty()) {
            builder.append("No issues were reported");
        } else {
            builder.append("Issues:\n - ").append(Joiner.on((String)"\n - ").join(aapt2Result.getMessages()));
        }
        return new AaptException(builder.toString(), new Object[0]);
    }

    private static void writeMessages(ProcessOutputHandler processOutputHandler, List<Aapt2Result.Message> messages) throws AaptException {
        ProcessOutput output;
        if (messages.isEmpty()) {
            return;
        }
        try (ProcessOutput ignored = output = processOutputHandler.createOutput();
             PrintWriter err = new PrintWriter(output.getErrorOutput());
             PrintWriter out = new PrintWriter(output.getStandardOutput());){
            for (Aapt2Result.Message message : messages) {
                switch (message.getLevel()) {
                    case NOTE: {
                        out.println(message.toString());
                        break;
                    }
                    case WARN: 
                    case ERROR: {
                        err.println(message.toString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AaptException(e, "Unexpected error handling AAPT output", new Object[0]);
        }
        try {
            processOutputHandler.handleOutput(output);
        }
        catch (ProcessException e) {
            throw new AaptException(e, "Unexpected error handling AAPT output", new Object[0]);
        }
    }
}

