/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.IdProvider;
import com.android.builder.symbols.ResourceValuesXmlParseException;
import com.android.builder.symbols.Symbol;
import com.android.builder.symbols.SymbolJavaType;
import com.android.builder.symbols.SymbolTable;
import com.android.builder.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ResourceValuesXmlParser {
    private ResourceValuesXmlParser() {
    }

    public static SymbolTable parse(Document xmlDocument, IdProvider idProvider) {
        Element root = xmlDocument.getDocumentElement();
        if (root == null) {
            throw new ResourceValuesXmlParseException("XML document does not have a root element.");
        }
        if (!"resources".equals(root.getTagName())) {
            throw new ResourceValuesXmlParseException("XML document root is not 'resources'");
        }
        if (root.getNamespaceURI() != null) {
            throw new ResourceValuesXmlParseException("XML document root has a namespace");
        }
        SymbolTable.Builder builder = SymbolTable.builder();
        ArrayList<Symbol> enumSymbols = new ArrayList<Symbol>();
        for (Node current = root.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            ResourceValuesXmlParser.parseChild((Element)current, builder, idProvider, enumSymbols);
        }
        for (Symbol enumSymbol : enumSymbols) {
            if (builder.contains(enumSymbol)) continue;
            builder.add(enumSymbol);
        }
        return builder.build();
    }

    private static void parseChild(Element child, SymbolTable.Builder builder, IdProvider idProvider, List<Symbol> enumSymbols) {
        ResourceType resourceType;
        String type = child.getTagName();
        if (type.equals("item")) {
            type = child.getAttribute("type");
        }
        if (type.contains(":")) {
            type = type.substring(type.lastIndexOf(58) + 1, type.length());
        }
        if ((resourceType = ResourceType.getEnum((String)type)) == null) {
            throw new ResourceValuesXmlParseException("Unknown resource value XML element '" + type + "'");
        }
        if (resourceType == ResourceType.PUBLIC) {
            return;
        }
        String name = SymbolUtils.canonicalizeValueResourceName(ResourceValuesXmlParser.getMandatoryAttr(child, "name"));
        switch (resourceType) {
            case ANIM: 
            case ANIMATOR: 
            case ARRAY: 
            case BOOL: 
            case COLOR: 
            case DIMEN: 
            case DRAWABLE: 
            case FONT: 
            case FRACTION: 
            case ID: 
            case INTEGER: 
            case INTERPOLATOR: 
            case LAYOUT: 
            case MENU: 
            case MIPMAP: 
            case PLURALS: 
            case RAW: 
            case STRING: 
            case STYLE: 
            case TRANSITION: 
            case XML: {
                builder.add(Symbol.createSymbol(resourceType, name, SymbolJavaType.INT, idProvider.next(resourceType)));
                break;
            }
            case DECLARE_STYLEABLE: {
                ResourceValuesXmlParser.parseDeclareStyleable(child, idProvider, name, builder, enumSymbols);
                break;
            }
            case ATTR: {
                ResourceValuesXmlParser.parseAttr(child, idProvider, name, builder, enumSymbols);
                break;
            }
            case PUBLIC: {
                throw new AssertionError((Object)"Already checked above.");
            }
            default: {
                throw new ResourceValuesXmlParseException("Unknown resource value XML element '" + type + "'");
            }
        }
    }

    private static void parseDeclareStyleable(Element declareStyleable, IdProvider idProvider, String name, SymbolTable.Builder builder, List<Symbol> enumSymbols) {
        ArrayList<String> attrValues = new ArrayList<String>();
        Node attrNode = declareStyleable.getFirstChild();
        while (attrNode != null) {
            if (attrNode.getNodeType() != 1) {
                attrNode = attrNode.getNextSibling();
                continue;
            }
            Element attrElement = (Element)attrNode;
            String tagName = attrElement.getTagName();
            if (tagName.equals("item")) {
                tagName = attrElement.getAttribute("type");
            }
            if (!tagName.equals(ResourceType.ATTR.getName()) || attrElement.getNamespaceURI() != null) {
                throw new ResourceValuesXmlParseException(String.format("Illegal type under declare-styleable: was <%s>, only accepted is <attr>", tagName));
            }
            String attrName = SymbolUtils.canonicalizeValueResourceName(ResourceValuesXmlParser.getMandatoryAttr(attrElement, "name"));
            ResourceValuesXmlParser.parseAttr(attrElement, idProvider, attrName, builder, enumSymbols);
            String attrValue = idProvider.next(ResourceType.STYLEABLE);
            Symbol newStyleable = Symbol.createSymbol(ResourceType.STYLEABLE, name + "_" + attrName, SymbolJavaType.INT, attrValue);
            builder.add(newStyleable);
            attrValues.add(attrValue);
            attrNode = attrNode.getNextSibling();
        }
        builder.add(Symbol.createSymbol(ResourceType.STYLEABLE, name, SymbolJavaType.INT_LIST, "{" + Joiner.on((char)',').join(attrValues) + "}"));
    }

    private static void parseAttr(Element attr, IdProvider idProvider, String name, SymbolTable.Builder builder, List<Symbol> enumSymbols) {
        Node enumNode = attr.getFirstChild();
        while (enumNode != null) {
            if (enumNode.getNodeType() != 1) {
                enumNode = enumNode.getNextSibling();
                continue;
            }
            Element enumElement = (Element)enumNode;
            String tagName = enumElement.getTagName();
            if (tagName.equals("item")) {
                tagName = enumElement.getAttribute("type");
            }
            if (!tagName.equals("enum") || enumElement.getNamespaceURI() != null) {
                enumNode = enumNode.getNextSibling();
                continue;
            }
            Symbol newEnum = Symbol.createSymbol(ResourceType.ID, SymbolUtils.canonicalizeValueResourceName(ResourceValuesXmlParser.getMandatoryAttr(enumElement, "name")), SymbolJavaType.INT, idProvider.next(ResourceType.ID));
            enumSymbols.add(newEnum);
            enumNode = enumNode.getNextSibling();
        }
        Symbol newAttr = Symbol.createSymbol(ResourceType.ATTR, name, SymbolJavaType.INT, idProvider.next(ResourceType.ATTR));
        if (!builder.contains(newAttr)) {
            builder.add(newAttr);
        }
    }

    private static String getMandatoryAttr(Element element, String attrName) {
        Attr attr = element.getAttributeNodeNS(null, attrName);
        if (attr == null) {
            throw new ResourceValuesXmlParseException("Element '" + element.getTagName() + "' should have attribute '" + attrName + "'");
        }
        return attr.getValue();
    }
}

