/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.Symbol;
import com.android.builder.symbols.SymbolJavaType;
import com.android.builder.symbols.SymbolTable;
import com.android.builder.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.TreeSet;

public final class SymbolIo {
    public static final String ANDROID_ATTR_PREFIX = "android_";

    private SymbolIo() {
    }

    public static SymbolTable read(File file, String tablePackage) throws IOException {
        int lineIndex;
        List<String> lines;
        try {
            lines = Files.readAllLines(file.toPath(), Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        SymbolTable.Builder table = SymbolTable.builder();
        String line = null;
        try {
            int count = lines.size();
            for (lineIndex = 1; lineIndex <= count; ++lineIndex) {
                line = lines.get(lineIndex - 1);
                SymbolData data = SymbolIo.readLine(line, null);
                if (data.resourceType == ResourceType.STYLEABLE) {
                    SymbolData subData;
                    if (data.javaType != SymbolJavaType.INT_LIST) continue;
                    ArrayList childrenNames = Lists.newArrayList();
                    String data_name = data.name + "_";
                    while (lineIndex < count && (subData = SymbolIo.readLine(lines.get(lineIndex), (resourceType, javaType) -> resourceType.equals(ResourceType.STYLEABLE.getName()) && javaType.equals(SymbolJavaType.INT.getTypeName()))) != null) {
                        ++lineIndex;
                        if (!subData.name.startsWith(data_name)) continue;
                        String indexName = subData.name.substring(data_name.length());
                        if (indexName.startsWith(ANDROID_ATTR_PREFIX)) {
                            indexName = "android:" + indexName.substring(ANDROID_ATTR_PREFIX.length());
                        }
                        childrenNames.add(indexName);
                    }
                    table.add(Symbol.createSymbol(data.resourceType, data.name, data.javaType, data.value, childrenNames));
                    continue;
                }
                table.add(Symbol.createSymbol(data.resourceType, data.name, data.javaType, data.value));
            }
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new IOException(String.format("File format error reading %s line %d: '%s'", file.getAbsolutePath(), lineIndex, line), e);
        }
        if (tablePackage != null) {
            table.tablePackage(tablePackage);
        }
        return table.build();
    }

    private static SymbolData readLine(String line, SymbolFilter filter) throws IOException {
        int pos = line.indexOf(32);
        String typeName = line.substring(0, pos);
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        int pos2 = line.indexOf(32, pos + 1);
        String className = line.substring(pos + 1, pos2);
        if (filter != null && !filter.validate(className, typeName)) {
            return null;
        }
        ResourceType resourceType = ResourceType.getEnum((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        int pos3 = line.indexOf(32, pos2 + 1);
        String name = line.substring(pos2 + 1, pos3);
        String value = line.substring(pos3 + 1);
        return new SymbolData(resourceType, name, type, value);
    }

    public static void write(SymbolTable table, File file) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Symbol s : table.allSymbols()) {
            lines.add(s.getJavaType().getTypeName() + " " + s.getResourceType().getName() + " " + s.getName() + " " + s.getValue());
            if (s.getJavaType() != SymbolJavaType.INT_LIST) continue;
            Preconditions.checkArgument((s.getResourceType() == ResourceType.STYLEABLE ? 1 : 0) != 0, (Object)"Only resource type 'styleable' is allowed to have java type 'int[]'");
            List<String> children = s.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                lines.add(SymbolJavaType.INT.getTypeName() + " " + ResourceType.STYLEABLE.getName() + " " + s.getName() + "_" + children.get(i) + " " + i);
            }
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             PrintWriter pw = new PrintWriter(fos);){
            lines.forEach(pw::println);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static File exportToJava(SymbolTable table, File directory, boolean finalIds) {
        Preconditions.checkArgument((boolean)directory.isDirectory());
        Splitter splitter = Splitter.on((char)'.');
        Iterable directories = splitter.split((CharSequence)table.getTablePackage());
        File file = directory;
        for (String d : directories) {
            file = new File(file, d);
        }
        FileUtils.mkdirs((File)file);
        file = new File(file, "R.java");
        EnumSet<ResourceType> resourceTypes = EnumSet.noneOf(ResourceType.class);
        table.allSymbols().forEach(s -> resourceTypes.add(s.getResourceType()));
        String idModifiers = finalIds ? "public static final" : "public static";
        try (FileOutputStream fos = new FileOutputStream(file);
             PrintWriter pw = new PrintWriter(fos);){
            pw.println("/* AUTO-GENERATED FILE.  DO NOT MODIFY.");
            pw.println(" *");
            pw.println(" * This class was automatically generated by the");
            pw.println(" * gradle plugin from the resource data it found. It");
            pw.println(" * should not be modified by hand.");
            pw.println(" */");
            if (!table.getTablePackage().isEmpty()) {
                pw.println("package " + table.getTablePackage() + ";");
            }
            pw.println();
            pw.println("public final class R {");
            String typeName = SymbolJavaType.INT.getTypeName();
            for (ResourceType rt : resourceTypes) {
                pw.println("    public static final class " + rt + " {");
                TreeSet<Symbol> syms = new TreeSet<Symbol>(Comparator.comparing(Symbol::getName));
                table.allSymbols().forEach(sym -> {
                    if (sym.getResourceType().equals((Object)rt)) {
                        syms.add((Symbol)sym);
                    }
                });
                for (Symbol s2 : syms) {
                    String name = s2.getName();
                    pw.println("        " + idModifiers + " " + s2.getJavaType().getTypeName() + " " + name + " = " + s2.getValue() + ";");
                    if (s2.getJavaType() != SymbolJavaType.INT_LIST) continue;
                    Preconditions.checkArgument((s2.getResourceType() == ResourceType.STYLEABLE ? 1 : 0) != 0, (Object)"Only resource type 'styleable' is allowed to have java type 'int[]'");
                    List<String> children = s2.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        pw.println("        " + idModifiers + " " + typeName + " " + name + "_" + SymbolUtils.canonicalizeValueResourceName(children.get(i)) + " = " + i + ";");
                    }
                }
                pw.println("    }");
            }
            pw.println("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return file;
    }

    @FunctionalInterface
    private static interface SymbolFilter {
        public boolean validate(String var1, String var2);
    }

    private static class SymbolData {
        final ResourceType resourceType;
        final String name;
        final SymbolJavaType javaType;
        final String value;

        public SymbolData(ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = javaType;
            this.value = value;
        }
    }
}

