/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.apkzlib.zip.ZFile;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DirDexArchive;
import com.android.builder.dexing.JarDexArchive;
import com.android.builder.dexing.NonIncrementalJarDexArchive;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

public final class DexArchives {
    public static final Predicate<Path> DEX_ENTRY_FILTER = f -> f.toString().endsWith(".dex");

    private DexArchives() {
    }

    public static DexArchive fromInput(Path path) throws IOException {
        if (ClassFileInputs.jarMatcher.matches(path)) {
            return new JarDexArchive(new ZFile(path.toFile()));
        }
        return new DirDexArchive(path);
    }

    public static DexArchive nonIncrementalArchive(Path path) throws IOException {
        if (ClassFileInputs.jarMatcher.matches(path)) {
            return new NonIncrementalJarDexArchive(path);
        }
        return new DirDexArchive(path);
    }

    static List<DexArchiveEntry> getEntriesFromSingleArchive(Path archivePath) throws IOException {
        try (DexArchive archive = DexArchives.fromInput(archivePath);){
            List<DexArchiveEntry> list = archive.getFiles();
            return list;
        }
    }

    static List<DexArchiveEntry> getAllEntriesFromArchives(Collection<Path> inputs) throws IOException {
        ArrayList entries = Lists.newArrayList();
        for (Path p : inputs) {
            entries.addAll(DexArchives.getEntriesFromSingleArchive(p));
        }
        return entries;
    }
}

