/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.apkzlib.zip.StoredEntry;
import com.android.apkzlib.zip.ZFile;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class JarClassFileInput
implements ClassFileInput {
    private final Path rootPath;
    private ZFile jarFile;

    public JarClassFileInput(Path rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public Stream<ClassFileEntry> entries(Predicate<Path> filter) {
        if (this.jarFile == null) {
            try {
                this.jarFile = new ZFile(this.rootPath.toFile());
            }
            catch (IOException e) {
                throw new JarClassFileInputsException("Unable to read jar file " + this.rootPath.toString(), e);
            }
        }
        Predicate<Path> newFilter = ((Predicate<Path>)classMatcher::matches).and(filter);
        return this.jarFile.entries().stream().filter(entry -> newFilter.test(Paths.get(entry.getCentralDirectoryHeader().getName(), new String[0]))).map(JarClassFileInput::createEntryFromEntry);
    }

    public static ClassFileEntry createEntryFromEntry(StoredEntry storedEntry) {
        return new NoCacheClassJarEntry(storedEntry);
    }

    public static class NoCacheClassJarEntry
    implements ClassFileEntry {
        final StoredEntry entry;

        public NoCacheClassJarEntry(StoredEntry storedEntry) {
            this.entry = storedEntry;
        }

        @Override
        public String name() {
            return "Zip:" + this.entry.getCentralDirectoryHeader().getName();
        }

        @Override
        public long getSize() {
            return this.entry.getCentralDirectoryHeader().getUncompressedSize();
        }

        @Override
        public Path getRelativePath() {
            return Paths.get(this.entry.getCentralDirectoryHeader().getName(), new String[0]);
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            return this.entry.read();
        }

        @Override
        public int readAllBytes(byte[] bytes) throws IOException {
            return this.entry.read(bytes);
        }
    }

    public static final class JarClassFileInputsException
    extends RuntimeException {
        public JarClassFileInputsException(String s, IOException e) {
            super(s, e);
        }
    }
}

