/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.ProcessProfileWriter;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ProcessProfileWriterFactory {
    private ScheduledExecutorService mScheduledExecutorService = Executors.newScheduledThreadPool(1);
    private ILogger mLogger = null;
    private static final Object LOCK = new Object();
    static ProcessProfileWriterFactory sINSTANCE = new ProcessProfileWriterFactory();
    private ProcessProfileWriter processProfileWriter = null;
    private boolean enableChromeTracingOutput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAndMaybeWrite(Path outputFile) throws InterruptedException {
        Object object = LOCK;
        synchronized (object) {
            if (sINSTANCE.isInitialized()) {
                Verify.verifyNotNull((Object)ProcessProfileWriterFactory.sINSTANCE.processProfileWriter);
                ProcessProfileWriterFactory.sINSTANCE.processProfileWriter.finishAndMaybeWrite(outputFile);
            }
            ProcessProfileWriterFactory.sINSTANCE.processProfileWriter = null;
        }
    }

    ProcessProfileWriterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(File rootProjectDirectoryPath, String gradleVersion, ILogger logger, boolean enableChromeTracingOutput) {
        Object object = LOCK;
        synchronized (object) {
            if (sINSTANCE.isInitialized()) {
                return;
            }
            sINSTANCE.setLogger(logger);
            sINSTANCE.setEnableChromeTracingOutput(enableChromeTracingOutput);
            ProcessProfileWriter recorder = sINSTANCE.get();
            ProcessProfileWriterFactory.setGlobalProperties(recorder, rootProjectDirectoryPath, gradleVersion, logger);
        }
    }

    private static void setGlobalProperties(ProcessProfileWriter recorder, File projectPath, String gradleVersion, ILogger logger) {
        String anonymizedProjectId;
        recorder.getProperties().setOsName(Strings.nullToEmpty((String)System.getProperty("os.name"))).setOsVersion(Strings.nullToEmpty((String)System.getProperty("os.version"))).setJavaVersion(Strings.nullToEmpty((String)System.getProperty("java.version"))).setJavaVmVersion(Strings.nullToEmpty((String)System.getProperty("java.vm.version"))).setMaxMemory(Runtime.getRuntime().maxMemory()).setGradleVersion(Strings.nullToEmpty((String)gradleVersion));
        try {
            anonymizedProjectId = Anonymizer.anonymizeUtf8((ILogger)logger, (String)projectPath.getAbsolutePath());
        }
        catch (IOException e) {
            anonymizedProjectId = "*ANONYMIZATION_ERROR*";
        }
        recorder.getProperties().setProjectId(anonymizedProjectId);
    }

    public synchronized void setLogger(ILogger iLogger) {
        this.assertRecorderNotCreated();
        this.mLogger = iLogger;
    }

    public static ProcessProfileWriterFactory getFactory() {
        return sINSTANCE;
    }

    boolean isInitialized() {
        return this.processProfileWriter != null;
    }

    private void assertRecorderNotCreated() {
        if (this.isInitialized()) {
            throw new RuntimeException("ProcessProfileWriter already created.");
        }
    }

    public static void initializeForTests() {
        sINSTANCE = new ProcessProfileWriterFactory();
        ProcessProfileWriter recorder = sINSTANCE.get();
        recorder.resetForTests();
        ProcessProfileWriterFactory.setGlobalProperties(recorder, new File("fake/path/to/test_project/"), "2.10", (ILogger)new StdLogger(StdLogger.Level.VERBOSE));
    }

    private static void initializeAnalytics(ILogger logger, ScheduledExecutorService eventLoop) {
        AnalyticsSettings settings = AnalyticsSettings.getInstance((ILogger)logger);
        UsageTracker.initialize((AnalyticsSettings)settings, (ScheduledExecutorService)eventLoop);
        UsageTracker tracker = UsageTracker.getInstance();
        tracker.setMaxJournalTime(10L, TimeUnit.MINUTES);
        tracker.setMaxJournalSize(1000);
    }

    synchronized ProcessProfileWriter get() {
        if (this.processProfileWriter == null) {
            if (this.mLogger == null) {
                this.mLogger = new StdLogger(StdLogger.Level.INFO);
            }
            ProcessProfileWriterFactory.initializeAnalytics(this.mLogger, this.mScheduledExecutorService);
            this.processProfileWriter = new ProcessProfileWriter(this.enableChromeTracingOutput);
        }
        return this.processProfileWriter;
    }

    public void setEnableChromeTracingOutput(boolean enableChromeTracingOutput) {
        this.enableChromeTracingOutput = enableChromeTracingOutput;
    }
}

