/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.AutoValue_Symbol;
import com.android.builder.symbols.SymbolJavaType;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ValueResourceNameValidator;
import com.android.resources.ResourceType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class Symbol {
    public static final List<String> NO_CHILDREN = ImmutableList.of();

    public static Symbol createSymbol(ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
        Symbol.validateSymbol(name, resourceType);
        return new AutoValue_Symbol(resourceType, value, name, javaType, NO_CHILDREN);
    }

    public static Symbol createSymbol(ResourceType resourceType, String name, SymbolJavaType javaType, String value, List<String> children) {
        Symbol.validateSymbol(name, resourceType);
        return new AutoValue_Symbol(resourceType, value, name, javaType, children);
    }

    private static void validateSymbol(String name, ResourceType resourceType) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Resource name cannot be null");
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0, (Object)("Resource name cannot contain dots: " + name));
        try {
            ValueResourceNameValidator.validate((String)name, (ResourceType)resourceType, null);
        }
        catch (MergingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public abstract ResourceType getResourceType();

    public abstract String getValue();

    public abstract String getName();

    public abstract SymbolJavaType getJavaType();

    public abstract List<String> getChildren();
}

