/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.util.ByteArray;
import com.android.dx.util.ByteArrayAnnotatedOutput;
import com.android.utils.PathUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class DxDexArchiveBuilder
extends DexArchiveBuilder {
    private static final Logger LOGGER = Logger.getLogger(DxDexArchiveBuilder.class.getName());
    private final DexArchiveBuilderConfig config;
    private byte[] inStorage;
    private DexFile.Storage outStorage;

    public DxDexArchiveBuilder(DexArchiveBuilderConfig config) {
        this.config = config;
        this.outStorage = config.getOutBufferSize() > 0 ? new DexFile.Storage(new byte[config.getOutBufferSize()]) : null;
    }

    @Override
    public void convert(Stream<ClassFileEntry> entries, DexArchive output) throws DexArchiveBuilderException {
        this.inStorage = this.config.getInBufferSize() > 0 ? new byte[this.config.getInBufferSize()] : null;
        try {
            entries.forEach(classFileEntry -> {
                try {
                    ByteArray byteArray;
                    if (this.inStorage != null) {
                        if (classFileEntry.getSize() > (long)this.inStorage.length) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.log(Level.FINER, "File too big " + classFileEntry.getSize() + " : " + classFileEntry.getRelativePath() + " vs " + this.inStorage.length);
                            }
                            this.inStorage = new byte[(int)classFileEntry.getSize()];
                        }
                        int readBytes = classFileEntry.readAllBytes(this.inStorage);
                        byteArray = new ByteArray(this.inStorage, 0, readBytes);
                    } else {
                        byteArray = new ByteArray(classFileEntry.readAllBytes());
                    }
                    this.dex(classFileEntry.getRelativePath(), byteArray, output);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, String.format("Error while processing %s", classFileEntry.getRelativePath()), e);
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            throw DexArchiveBuilderException.wrap(e);
        }
    }

    public void dex(Path relativePath, ByteArray classBytes, DexArchive output) throws IOException {
        String unixClassFile = PathUtils.toSystemIndependentPath((Path)relativePath);
        DirectClassFile cf = new DirectClassFile(classBytes, unixClassFile, true);
        cf.setAttributeFactory(StdAttributeFactory.THE_ONE);
        cf.getMagic();
        DexFile dexFile = new DexFile(this.config.getDexOptions());
        ClassDefItem classDefItem = CfTranslator.translate(this.config.getDxContext(), cf, null, this.config.getCfOptions(), this.config.getDexOptions(), dexFile);
        dexFile.add(classDefItem);
        if (this.outStorage != null) {
            ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = dexFile.writeTo(this.outStorage);
            output.addFile(ClassFileEntry.withDexExtension(relativePath), byteArrayAnnotatedOutput.getArray(), 0, byteArrayAnnotatedOutput.getCursor());
        } else {
            byte[] bytes = dexFile.toDex(null, false);
            output.addFile(ClassFileEntry.withDexExtension(relativePath), bytes, 0, bytes.length);
        }
    }
}

