/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class NonIncrementalJarDexArchive
implements DexArchive {
    private final Path targetPath;
    private final JarOutputStream jarOutputStream;

    public NonIncrementalJarDexArchive(Path targetPath) throws IOException {
        this.targetPath = targetPath;
        this.jarOutputStream = new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(targetPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW)));
    }

    @Override
    public Path getRootPath() {
        return this.targetPath;
    }

    @Override
    public void addFile(Path relativePath, InputStream inputStream) throws IOException {
        this.jarOutputStream.putNextEntry(new ZipEntry(relativePath.toString()));
        ByteStreams.copy((InputStream)inputStream, (OutputStream)this.jarOutputStream);
        this.jarOutputStream.flush();
        this.jarOutputStream.closeEntry();
    }

    @Override
    public void addFile(Path relativePath, byte[] bytes, int offset, int end) throws IOException {
        this.jarOutputStream.putNextEntry(new ZipEntry(relativePath.toString()));
        this.jarOutputStream.write(bytes, offset, end);
        this.jarOutputStream.flush();
        this.jarOutputStream.closeEntry();
    }

    @Override
    public void removeFile(Path relativePath) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<DexArchiveEntry> getFiles() throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void close() throws IOException {
        this.jarOutputStream.flush();
        this.jarOutputStream.close();
    }
}

