/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.builder.internal.incremental.DependencyData;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class AidlProcessor
implements SourceSearcher.SourceFileProcessor {
    private final String mAidlExecutable;
    private final String mFrameworkLocation;
    private final List<File> mImportFolders;
    private final File mSourceOutputDir;
    private final File mPackagedOutputDir;
    private Collection<String> mPackageWhiteList;
    private final DependencyFileProcessor mDependencyFileProcessor;
    private final ProcessExecutor mProcessExecutor;
    private final ProcessOutputHandler mProcessOutputHandler;

    public AidlProcessor(String aidlExecutable, String frameworkLocation, List<File> importFolders, File sourceOutputDir, File packagedOutputDir, Collection<String> packageWhiteList, DependencyFileProcessor dependencyFileProcessor, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler) {
        this.mAidlExecutable = aidlExecutable;
        this.mFrameworkLocation = frameworkLocation;
        this.mImportFolders = importFolders;
        this.mSourceOutputDir = sourceOutputDir;
        this.mPackagedOutputDir = packagedOutputDir;
        this.mPackageWhiteList = packageWhiteList;
        this.mDependencyFileProcessor = dependencyFileProcessor;
        this.mProcessExecutor = processExecutor;
        this.mProcessOutputHandler = processOutputHandler;
    }

    @Override
    public void processFile(File sourceFolder, File sourceFile) throws ProcessException, IOException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.mAidlExecutable);
        builder.addArgs("-p" + this.mFrameworkLocation);
        builder.addArgs("-o" + this.mSourceOutputDir.getAbsolutePath());
        for (File f : this.mImportFolders) {
            builder.addArgs("-I" + f.getAbsolutePath());
        }
        File depFile = File.createTempFile("aidl", ".d");
        builder.addArgs("-d" + depFile.getAbsolutePath());
        builder.addArgs(sourceFile.getAbsolutePath());
        ProcessResult result = this.mProcessExecutor.execute(builder.createProcess(), this.mProcessOutputHandler);
        result.rethrowFailure().assertNormalExitValue();
        DependencyData data = this.mDependencyFileProcessor.processFile(depFile);
        if (this.mPackagedOutputDir != null && data != null) {
            boolean isWhiteListed;
            boolean isParcelable = data.getOutputFiles().isEmpty();
            String relative = FileUtils.toSystemIndependentPath((String)FileOpUtils.makeRelative((File)sourceFolder, (File)sourceFile, (FileOp)FileOpUtils.create()));
            boolean bl = isWhiteListed = this.mPackageWhiteList != null && this.mPackageWhiteList.contains(relative);
            if (isParcelable || isWhiteListed) {
                File destFile = new File(this.mPackagedOutputDir, relative);
                destFile.getParentFile().mkdirs();
                Files.copy((File)sourceFile, (File)destFile);
                data.addSecondaryOutputFile(destFile.getPath());
            }
        }
        FileUtils.delete((File)depFile);
    }

    @Override
    public void initOnFirstFile() {
    }
}

