/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public class SourceSearcher {
    private final Collection<File> mSourceFolders;
    private final String[] mExtensions;
    private WaitableExecutor mExecutor;
    private boolean initialized = false;

    public SourceSearcher(Collection<File> sourceFolders, String ... extensions) {
        this.mSourceFolders = sourceFolders;
        this.mExtensions = extensions;
    }

    public SourceSearcher(File sourceFolder, String ... extensions) {
        this.mSourceFolders = ImmutableList.of((Object)sourceFolder);
        this.mExtensions = extensions;
    }

    public void setUseExecutor(boolean useExecutor) {
        this.mExecutor = useExecutor ? WaitableExecutor.useGlobalSharedThreadPool() : null;
    }

    public void search(SourceFileProcessor processor) throws ProcessException, InterruptedException, IOException {
        for (File file : this.mSourceFolders) {
            this.processFile(file, file, processor);
        }
        if (this.mExecutor != null) {
            this.mExecutor.waitForTasksWithQuickFail(true);
        }
    }

    private void processFile(File rootFolder, File file, SourceFileProcessor processor) throws ProcessException, IOException {
        File[] children;
        if (file.isFile()) {
            if (this.checkExtension(file)) {
                if (!this.initialized) {
                    processor.initOnFirstFile();
                    this.initialized = true;
                }
                if (this.mExecutor != null) {
                    this.mExecutor.execute(() -> {
                        processor.processFile(rootFolder, file);
                        return null;
                    });
                } else {
                    processor.processFile(rootFolder, file);
                }
            }
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.processFile(rootFolder, child, processor);
            }
        }
    }

    private boolean checkExtension(File file) {
        if (this.mExtensions.length == 0) {
            return true;
        }
        String filename = file.getName();
        int pos = filename.lastIndexOf(46);
        if (pos != -1) {
            String extension = filename.substring(pos + 1);
            for (String ext : this.mExtensions) {
                if (!ext.equalsIgnoreCase(extension)) continue;
                return true;
            }
        }
        return false;
    }

    public static interface SourceFileProcessor {
        public void processFile(File var1, File var2) throws ProcessException, IOException;

        public void initOnFirstFile();
    }
}

