/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.AutoValue_SymbolTable;
import com.android.builder.symbols.Symbol;
import com.android.resources.ResourceType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;

public abstract class SymbolTable {
    public static final String R_CLASS_NAME = "R";

    private static SymbolTable createSymbolTable(String tablePackage, ImmutableMap<String, Symbol> symbols) {
        return new AutoValue_SymbolTable(tablePackage, symbols);
    }

    public abstract String getTablePackage();

    public abstract ImmutableMap<String, Symbol> getSymbols();

    private static String key(Symbol symbol) {
        return SymbolTable.key(symbol.getResourceType(), symbol.getName());
    }

    public static String key(ResourceType resourceType, String name) {
        return resourceType.name() + " " + name;
    }

    public boolean contains(ResourceType resourceType, String name) {
        return this.getSymbols().containsKey((Object)SymbolTable.key(resourceType, name));
    }

    public ImmutableCollection<Symbol> allSymbols() {
        return this.getSymbols().values();
    }

    public SymbolTable filter(SymbolTable table) {
        ImmutableMap.Builder symbols = ImmutableMap.builder();
        for (Map.Entry e : this.getSymbols().entrySet()) {
            if (!table.getSymbols().containsKey(e.getKey())) continue;
            symbols.put(e.getKey(), e.getValue());
        }
        return SymbolTable.createSymbolTable(this.getTablePackage(), (ImmutableMap<String, Symbol>)symbols.build());
    }

    public SymbolTable merge(SymbolTable m) {
        return SymbolTable.merge(Arrays.asList(this, m));
    }

    public SymbolTable rename(String tablePackage) {
        return SymbolTable.createSymbolTable(tablePackage, this.getSymbols());
    }

    public static SymbolTable merge(List<SymbolTable> tables) {
        Builder builder = SymbolTable.builder();
        boolean first = true;
        for (SymbolTable t : tables) {
            if (first) {
                builder.tablePackage(t.getTablePackage());
                first = false;
            }
            for (Symbol s : t.allSymbols()) {
                if (builder.contains(s)) continue;
                builder.add(s);
            }
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String tablePackage = "";
        private Map<String, Symbol> symbols = new HashMap<String, Symbol>();

        private Builder() {
        }

        public Builder add(Symbol symbol) {
            String key = SymbolTable.key(symbol);
            if (this.symbols.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate symbol in table with resource type '" + symbol.getResourceType() + "' and symbol name '" + symbol.getName() + "'");
            }
            this.symbols.put(key, symbol);
            return this;
        }

        public Builder addAll(Collection<Symbol> symbols) {
            symbols.forEach(this::add);
            return this;
        }

        public Builder tablePackage(String tablePackage) {
            if (!tablePackage.isEmpty()) {
                Arrays.asList(tablePackage.split("\\.")).forEach(p -> Preconditions.checkArgument((boolean)SourceVersion.isIdentifier(p)));
            }
            this.tablePackage = tablePackage;
            return this;
        }

        public boolean contains(Symbol symbol) {
            return this.symbols.containsKey(SymbolTable.key(symbol));
        }

        public Symbol get(Symbol symbol) {
            return this.symbols.get(SymbolTable.key(symbol));
        }

        public SymbolTable build() {
            return SymbolTable.createSymbolTable(this.tablePackage, (ImmutableMap<String, Symbol>)ImmutableMap.copyOf(this.symbols));
        }
    }
}

