/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zip.compress;

import com.android.apkzlib.zip.CompressionResult;
import com.android.apkzlib.zip.compress.DeflateExecutionCompressor;
import com.android.apkzlib.zip.compress.ExecutorCompressor;
import com.android.apkzlib.zip.utils.ByteTracker;
import com.android.apkzlib.zip.utils.CloseableByteSource;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public class BestAndDefaultDeflateExecutorCompressor
extends ExecutorCompressor {
    @Nonnull
    private final DeflateExecutionCompressor defaultDeflater;
    @Nonnull
    private final DeflateExecutionCompressor bestDeflater;
    private final double minRatio;

    public BestAndDefaultDeflateExecutorCompressor(@Nonnull Executor executor, @Nonnull ByteTracker tracker, double minRatio) {
        super(executor);
        Preconditions.checkArgument((minRatio >= 0.0 ? 1 : 0) != 0, (Object)"minRatio < 0.0");
        Preconditions.checkArgument((minRatio <= 1.0 ? 1 : 0) != 0, (Object)"minRatio > 1.0");
        this.defaultDeflater = new DeflateExecutionCompressor(executor, tracker, -1);
        this.bestDeflater = new DeflateExecutionCompressor(executor, tracker, 9);
        this.minRatio = minRatio;
    }

    @Override
    @Nonnull
    protected CompressionResult immediateCompress(@Nonnull CloseableByteSource source) throws Exception {
        CompressionResult defaultResult = this.defaultDeflater.immediateCompress(source);
        CompressionResult bestResult = this.bestDeflater.immediateCompress(source);
        double sizeRatio = (double)bestResult.getSize() / (double)defaultResult.getSize();
        if (sizeRatio >= this.minRatio) {
            return defaultResult;
        }
        return bestResult;
    }
}

