/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.apkzlib.utils.CachedSupplier;
import com.android.apkzlib.zip.StoredEntry;
import com.android.apkzlib.zip.ZFile;
import com.android.builder.files.RelativeFile;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.ide.common.res2.FileStatus;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LazyIncrementalFileMergerInput
implements IncrementalFileMergerInput {
    private final String name;
    final CachedSupplier<ImmutableMap<RelativeFile, FileStatus>> updates;
    final CachedSupplier<ImmutableMap<String, RelativeFile>> updatePaths;
    final CachedSupplier<ImmutableMap<String, RelativeFile>> filePaths;
    final CachedSupplier<ImmutableSet<File>> zips;
    Map<File, ZFile> openZips;

    public LazyIncrementalFileMergerInput(String name, CachedSupplier<ImmutableMap<RelativeFile, FileStatus>> updates, CachedSupplier<ImmutableSet<RelativeFile>> files) {
        this.name = name;
        this.updates = updates;
        this.updatePaths = new CachedSupplier<ImmutableMap>(() -> {
            ImmutableMap.Builder pathsBuilder = ImmutableMap.builder();
            for (Map.Entry e : ((ImmutableMap)updates.get()).entrySet()) {
                pathsBuilder.put((Object)((RelativeFile)e.getKey()).getOsIndependentRelativePath(), e.getKey());
            }
            return pathsBuilder.build();
        });
        this.filePaths = new CachedSupplier<ImmutableMap>(() -> {
            ImmutableMap.Builder pathsBuilder = ImmutableMap.builder();
            for (RelativeFile rf : (ImmutableSet)files.get()) {
                pathsBuilder.put((Object)rf.getOsIndependentRelativePath(), (Object)rf);
            }
            return pathsBuilder.build();
        });
        this.zips = new CachedSupplier<ImmutableSet>(() -> {
            HashSet<File> zips = new HashSet<File>();
            HashSet<File> known = new HashSet<File>();
            for (RelativeFile rf : (ImmutableSet)files.get()) {
                if (known.contains(rf.getBase())) continue;
                known.add(rf.getBase());
                if (!rf.getBase().isFile()) continue;
                zips.add(rf.getBase());
            }
            return ImmutableSet.copyOf(zips);
        });
        this.openZips = null;
    }

    @Override
    public ImmutableSet<String> getUpdatedPaths() {
        return this.updatePaths.get().keySet();
    }

    @Override
    public ImmutableSet<String> getAllPaths() {
        return this.filePaths.get().keySet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FileStatus getFileStatus(String path) {
        RelativeFile rf = (RelativeFile)this.updatePaths.get().get((Object)path);
        if (rf == null) {
            return null;
        }
        return (FileStatus)this.updates.get().get((Object)rf);
    }

    @Override
    public InputStream openPath(String path) {
        Preconditions.checkState((this.openZips != null ? 1 : 0) != 0, (Object)"input not open");
        RelativeFile rf = (RelativeFile)this.filePaths.get().get((Object)path);
        Preconditions.checkState((rf != null ? 1 : 0) != 0, (Object)("Unknown file " + rf));
        if (this.zips.get().contains((Object)rf.getBase())) {
            ZFile zf = this.openZips.get(rf.getBase());
            assert (zf != null);
            StoredEntry entry = zf.get(path);
            assert (entry != null);
            try {
                return entry.open();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try {
            return new FileInputStream(rf.getFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void open() {
        Preconditions.checkState((this.openZips == null ? 1 : 0) != 0, (Object)"input already open");
        HashMap<File, ZFile> open = new HashMap<File, ZFile>();
        UncheckedIOException failure = null;
        for (File f : this.zips.get()) {
            try {
                ZFile zf = new ZFile(f);
                open.put(f, zf);
            }
            catch (IOException e) {
                failure = new UncheckedIOException(e);
                break;
            }
        }
        if (failure != null) {
            for (ZFile zf : open.values()) {
                try {
                    zf.close();
                }
                catch (IOException e) {
                    failure.addSuppressed(e);
                }
            }
            throw failure;
        }
        this.openZips = open;
    }

    @Override
    public void close() {
        Preconditions.checkState((this.openZips != null ? 1 : 0) != 0, (Object)"input not open");
        try (Closer closer = Closer.create();){
            for (ZFile zf : this.openZips.values()) {
                closer.register((Closeable)zf);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.openZips = null;
        }
    }
}

