/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.AutoValue_SymbolTable;
import com.android.builder.symbols.Symbol;
import com.android.resources.ResourceType;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;

public abstract class SymbolTable {
    private static SymbolTable createSymbolTable(String tablePackage, ImmutableTable<ResourceType, String, Symbol> symbols) {
        return new AutoValue_SymbolTable(tablePackage, symbols);
    }

    public abstract String getTablePackage();

    public abstract ImmutableTable<ResourceType, String, Symbol> getSymbols();

    public SymbolTable filter(SymbolTable table) {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (ResourceType resourceType : this.getSymbols().rowKeySet()) {
            ImmutableCollection symbols = this.getSymbols().row((Object)resourceType).values();
            ImmutableSet filteringSymbolNames = table.getSymbols().row((Object)resourceType).keySet();
            for (Symbol symbol : symbols) {
                if (!filteringSymbolNames.contains((Object)symbol.getName())) continue;
                builder.put((Object)resourceType, (Object)symbol.getName(), (Object)symbol);
            }
        }
        return SymbolTable.createSymbolTable(this.getTablePackage(), (ImmutableTable<ResourceType, String, Symbol>)builder.build());
    }

    public SymbolTable merge(SymbolTable m) {
        return SymbolTable.merge(Arrays.asList(this, m));
    }

    public SymbolTable rename(String tablePackage) {
        return SymbolTable.createSymbolTable(tablePackage, this.getSymbols());
    }

    public static SymbolTable merge(List<SymbolTable> tables) {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        HashSet<String> present = new HashSet<String>();
        for (ResourceType resourceType : ResourceType.values()) {
            present.clear();
            for (SymbolTable t : tables) {
                ImmutableMap tableSymbolMap = t.getSymbols().row((Object)resourceType);
                if (tableSymbolMap == null || tableSymbolMap.isEmpty()) continue;
                for (Symbol s : tableSymbolMap.values()) {
                    String name = s.getName();
                    if (present.contains(name)) continue;
                    present.add(name);
                    builder.put((Object)resourceType, (Object)name, (Object)s);
                }
            }
        }
        String packageName = tables.isEmpty() ? "" : tables.get(0).getTablePackage();
        return SymbolTable.createSymbolTable(packageName, (ImmutableTable<ResourceType, String, Symbol>)builder.build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String tablePackage = "";
        private final Table<ResourceType, String, Symbol> symbols = Tables.newCustomTable((Map)Maps.newEnumMap(ResourceType.class), HashMap::new);

        private Builder() {
        }

        public Builder add(Symbol symbol) {
            if (this.symbols.contains((Object)symbol.getResourceType(), (Object)symbol.getName())) {
                throw new IllegalArgumentException("Duplicate symbol in table with resource type '" + symbol.getResourceType() + "' and symbol name '" + symbol.getName() + "'");
            }
            this.symbols.put((Object)symbol.getResourceType(), (Object)symbol.getName(), (Object)symbol);
            return this;
        }

        public Builder addAll(Collection<Symbol> symbols) {
            symbols.forEach(this::add);
            return this;
        }

        public Builder tablePackage(String tablePackage) {
            if (!tablePackage.isEmpty() && !SourceVersion.isName(tablePackage)) {
                for (String segment : Splitter.on((char)'.').split((CharSequence)tablePackage)) {
                    if (!SourceVersion.isIdentifier(segment)) {
                        throw new IllegalArgumentException("Package '" + tablePackage + "' from AndroidManifest.xml is not a valid Java package name as '" + segment + "' is not a valid Java identifier.");
                    }
                    if (!SourceVersion.isKeyword(segment)) continue;
                    throw new IllegalArgumentException("Package '" + tablePackage + "' from AndroidManifest.xml is not a valid Java package name as '" + segment + "' is a Java keyword.");
                }
                throw new IllegalArgumentException("Package '" + tablePackage + "' from AndroidManifest.xml is not a valid Java package name.");
            }
            this.tablePackage = tablePackage;
            return this;
        }

        public boolean contains(Symbol symbol) {
            return this.contains(symbol.getResourceType(), symbol.getName());
        }

        public boolean contains(ResourceType resourceType, String name) {
            return this.symbols.contains((Object)resourceType, (Object)name);
        }

        public Symbol get(Symbol symbol) {
            return (Symbol)this.symbols.get((Object)symbol.getResourceType(), (Object)symbol.getName());
        }

        public SymbolTable build() {
            return SymbolTable.createSymbolTable(this.tablePackage, (ImmutableTable<ResourceType, String, Symbol>)ImmutableTable.copyOf(this.symbols));
        }
    }
}

