/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PrintClassList {
    public static void main(String[] args) throws IOException, ExecutionException {
        List<String> dexFiles = Arrays.asList(args);
        AndroidApp.Builder builder = AndroidApp.builder();
        if (args[0].endsWith("map")) {
            builder.setProguardMapFile(Paths.get(args[0], new String[0]));
            dexFiles = dexFiles.subList(1, dexFiles.size());
        }
        builder.addProgramFiles(ListUtils.map(dexFiles, x$0 -> Paths.get(x$0, new String[0])), false);
        ExecutorService executorService = Executors.newCachedThreadPool();
        DexApplication application = new ApplicationReader(builder.build(), new InternalOptions(), new Timing("PrintClassList")).read(executorService);
        ClassNameMapper map = application.getProguardMap();
        for (DexProgramClass clazz : application.classes()) {
            System.out.print(PrintClassList.maybeDeobfuscateType(map, clazz.type));
            System.out.println();
            PrintClassList.printMethods(clazz.directMethods(), map);
            PrintClassList.printMethods(clazz.virtualMethods(), map);
            PrintClassList.printFields(clazz.staticFields(), map);
            PrintClassList.printFields(clazz.instanceFields(), map);
        }
        executorService.shutdown();
    }

    private static void printMethods(DexEncodedMethod[] methods, ClassNameMapper map) {
        for (DexEncodedMethod encodedMethod : methods) {
            DexMethod method = encodedMethod.method;
            if (map != null) {
                System.out.println(map.originalNameOf(method));
                continue;
            }
            MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(method);
            System.out.println(method.holder.toSourceString() + " " + signature);
        }
    }

    private static void printFields(DexEncodedField[] fields, ClassNameMapper map) {
        for (DexEncodedField encodedField : fields) {
            DexField field = encodedField.field;
            if (map != null) {
                System.out.println(map.originalNameOf(field));
                continue;
            }
            MemberNaming.FieldSignature signature = new MemberNaming.FieldSignature(field.name.toSourceString(), field.type.toSourceString());
            System.out.println(field.clazz.toSourceString() + " " + signature);
        }
    }

    private static String maybeDeobfuscateType(ClassNameMapper map, DexType type) {
        return map == null ? type.toSourceString() : map.originalNameOf(type);
    }
}

