/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexAccessFlags;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;

public class DexEncodedField
extends KeyedDexItem<DexField> {
    public static final DexEncodedField[] EMPTY_ARRAY = new DexEncodedField[0];
    public final DexField field;
    public final DexAccessFlags accessFlags;
    public DexAnnotationSet annotations;
    public final DexValue staticValue;

    public DexEncodedField(DexField field, DexAccessFlags accessFlags, DexAnnotationSet annotations, DexValue staticValue) {
        assert (!accessFlags.isStatic() || staticValue != null);
        this.field = field;
        this.accessFlags = accessFlags;
        this.annotations = annotations;
        this.staticValue = staticValue;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.field.collectIndexedItems(indexedItems);
        this.annotations.collectIndexedItems(indexedItems);
        if (this.staticValue != null) {
            this.staticValue.collectIndexedItems(indexedItems);
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        this.annotations.collectMixedSectionItems(mixedItems);
    }

    public String toString() {
        return "Encoded field " + this.field;
    }

    @Override
    public String toSmaliString() {
        return this.field.toSmaliString();
    }

    @Override
    public String toSourceString() {
        return this.field.toSourceString();
    }

    @Override
    public DexField getKey() {
        return this.field;
    }

    public boolean hasAnnotation() {
        return !this.annotations.isEmpty();
    }

    public Instruction valueAsConstInstruction(AppInfo appInfo, Value dest) {
        if (this.accessFlags.isStatic() && this.accessFlags.isPublic() && this.accessFlags.isFinal()) {
            DexClass clazz = appInfo.definitionFor(this.field.getHolder());
            assert (clazz != null) : "Class for the field must be present";
            return this.staticValue.asConstInstruction(clazz.hasClassInitializer(), dest);
        }
        return null;
    }

    public DexEncodedField toRenamedField(DexString name, DexItemFactory dexItemFactory) {
        return new DexEncodedField(dexItemFactory.createField(this.field.clazz, this.field.type, name), this.accessFlags, this.annotations, this.staticValue);
    }

    public DexEncodedField toTypeSubstitutedField(DexField field) {
        if (this.field == field) {
            return this;
        }
        return new DexEncodedField(field, this.accessFlags, this.annotations, this.staticValue);
    }
}

