/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;

public abstract class Binop
extends Instruction {
    protected final NumericType type;

    public Binop(NumericType type, Value dest, Value left, Value right) {
        super(dest);
        this.type = type;
        this.addInValue(left);
        this.addInValue(right);
    }

    public NumericType getNumericType() {
        return this.type;
    }

    public Value leftValue() {
        return (Value)this.inValues.get(0);
    }

    public Value rightValue() {
        return (Value)this.inValues.get(1);
    }

    public abstract boolean isCommutative();

    public boolean isTwoAddr(DexBuilder builder) {
        if (this.rightValue().needsRegister() && this.leftValue().needsRegister()) {
            int leftRegister = builder.allocatedRegister(this.leftValue(), this.getNumber());
            int rightRegister = builder.allocatedRegister(this.rightValue(), this.getNumber());
            int destRegister = builder.allocatedRegister(this.outValue, this.getNumber());
            return (leftRegister == destRegister || this.isCommutative() && rightRegister == destRegister) && leftRegister <= 15 && rightRegister <= 15;
        }
        return false;
    }

    boolean fitsInDexInstruction(Value value) {
        return this.fitsInLit16Instruction(value);
    }

    boolean fitsInLit16Instruction(Value value) {
        return this.type == NumericType.INT && value.isConstant() && value.getConstInstruction().asConstNumber().is16Bit();
    }

    boolean fitsInLit8Instruction(Value value) {
        return this.type == NumericType.INT && value.isConstant() && value.getConstInstruction().asConstNumber().is8Bit();
    }

    int maxInOutValueRegisterSize() {
        if (this.fitsInDexInstruction(this.rightValue())) {
            return this.rightValue().getConstInstruction().asConstNumber().is8Bit() ? 255 : 15;
        }
        return 255;
    }

    @Override
    public int maxInValueRegister() {
        return this.maxInOutValueRegisterSize();
    }

    @Override
    public int maxOutValueRegister() {
        return this.maxInOutValueRegisterSize();
    }

    int foldIntegers(int left, int right) {
        throw new Unreachable("Unsupported integer folding for " + this);
    }

    long foldLongs(long left, long right) {
        throw new Unreachable("Unsupported long folding for " + this);
    }

    float foldFloat(float left, float right) {
        throw new Unreachable("Unsupported float folding for " + this);
    }

    double foldDouble(double left, double right) {
        throw new Unreachable("Unsupported float folding for " + this);
    }

    @Override
    public boolean isBinop() {
        return true;
    }

    @Override
    public Binop asBinop() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfo info, DexType holder) {
        return Inliner.Constraint.ALWAYS;
    }
}

