/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class DeadCodeRemover {
    public static void removeDeadCode(IRCode code, CodeRewriter codeRewriter, InternalOptions options) {
        LinkedList<BasicBlock> worklist = new LinkedList<BasicBlock>();
        DominatorTree dominator = new DominatorTree(code);
        code.clearMarks();
        worklist.addAll(code.blocks);
        BasicBlock block = (BasicBlock)worklist.poll();
        while (block != null) {
            if (!block.isMarked()) {
                DeadCodeRemover.removeDeadInstructions(worklist, code, block, options);
                DeadCodeRemover.removeDeadPhis(worklist, block, options);
                DeadCodeRemover.removeUnneededCatchHandlers(worklist, block, dominator);
            }
            block = (BasicBlock)worklist.poll();
        }
        code.removeMarkedBlocks();
        assert (code.isConsistentSSA());
        codeRewriter.rewriteMoveResult(code);
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Value value) {
        BasicBlock block = value.isPhi() ? value.asPhi().getBlock() : value.definition.getBlock();
        if (!block.isMarked()) {
            worklist.add(block);
        }
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Instruction instruction) {
        for (Value inValue : instruction.inValues()) {
            DeadCodeRemover.updateWorklist(worklist, inValue);
        }
        for (Value debugValue : instruction.getDebugValues()) {
            DeadCodeRemover.updateWorklist(worklist, debugValue);
        }
        Value previousLocalValue = instruction.getPreviousLocalValue();
        if (previousLocalValue != null) {
            DeadCodeRemover.updateWorklist(worklist, previousLocalValue);
        }
    }

    private static void removeDeadPhis(Queue<BasicBlock> worklist, BasicBlock block, InternalOptions options) {
        ArrayList<Phi> toRemove = new ArrayList<Phi>();
        for (Phi phi : block.getPhis()) {
            if (!phi.isDead(options)) continue;
            toRemove.add(phi);
            for (Value operand : phi.getOperands()) {
                operand.removePhiUser(phi);
                DeadCodeRemover.updateWorklist(worklist, operand);
            }
        }
        if (!toRemove.isEmpty()) {
            int i;
            ArrayList<Phi> newPhis = new ArrayList<Phi>(block.getPhis().size() - toRemove.size());
            int toRemoveIndex = 0;
            List<Phi> phis = block.getPhis();
            for (i = 0; i < phis.size() && toRemoveIndex < toRemove.size(); ++i) {
                Phi phi = phis.get(i);
                if (phi == toRemove.get(toRemoveIndex)) {
                    ++toRemoveIndex;
                    continue;
                }
                newPhis.add(phi);
            }
            newPhis.addAll(phis.subList(i, phis.size()));
            block.setPhis(newPhis);
        }
    }

    private static void removeDeadInstructions(Queue<BasicBlock> worklist, IRCode code, BasicBlock block, InternalOptions options) {
        InstructionListIterator iterator = block.listIterator(block.getInstructions().size());
        while (iterator.hasPrevious()) {
            Instruction current = (Instruction)iterator.previous();
            if (current.isInvoke() && current.outValue() != null && current.outValue().numberOfAllUsers() == 0) {
                current.setOutValue(null);
            }
            if (!current.canBeDeadCode(code, options)) continue;
            Value outValue = current.outValue();
            assert (outValue != null);
            if (!outValue.isDead(options)) continue;
            DeadCodeRemover.updateWorklist(worklist, current);
            outValue.clearUsers();
            iterator.remove();
        }
    }

    private static void removeUnneededCatchHandlers(Queue<BasicBlock> worklist, BasicBlock block, DominatorTree dominator) {
        if (block.hasCatchHandlers() && !block.canThrow()) {
            CatchHandlers<BasicBlock> handlers = block.getCatchHandlers();
            for (BasicBlock target : handlers.getUniqueTargets()) {
                for (BasicBlock unlinked : block.unlink(target, dominator)) {
                    if (unlinked.isMarked()) continue;
                    InstructionIterator iterator = unlinked.iterator();
                    while (iterator.hasNext()) {
                        DeadCodeRemover.updateWorklist(worklist, (Instruction)iterator.next());
                    }
                    unlinked.mark();
                }
            }
        }
    }
}

