/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import java.util.Arrays;
import java.util.BitSet;

public class RegisterPositions {
    private static final int INITIAL_SIZE = 16;
    private int limit;
    private int[] backing;
    private BitSet registerHoldsConstant;

    public RegisterPositions(int limit) {
        this.limit = limit;
        this.backing = new int[16];
        for (int i = 0; i < 16; ++i) {
            this.backing[i] = Integer.MAX_VALUE;
        }
        this.registerHoldsConstant = new BitSet(limit);
    }

    public boolean holdsConstant(int index) {
        return this.registerHoldsConstant.get(index);
    }

    public void set(int index, int value, boolean holdsConstant) {
        if (index >= this.backing.length) {
            this.grow(index + 1);
        }
        this.backing[index] = value;
        this.registerHoldsConstant.set(index, holdsConstant);
    }

    public int get(int index) {
        if (index < this.backing.length) {
            return this.backing[index];
        }
        assert (index < this.limit);
        return Integer.MAX_VALUE;
    }

    public void grow(int minSize) {
        int size;
        for (size = this.backing.length; size < minSize; size *= 2) {
        }
        size = Math.min(size, this.limit);
        int oldSize = this.backing.length;
        this.backing = Arrays.copyOf(this.backing, size);
        for (int i = oldSize; i < size; ++i) {
            this.backing[i] = Integer.MAX_VALUE;
        }
    }
}

