/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEntry;
import com.android.tools.r8.graph.DexDebugEventBuilder;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.utils.InternalOptions;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;

public class DebugStripper {
    private static final int USED_MORE_THAN_ONCE = 0;
    private static final int USED_ONCE = -1;
    private final ClassNameMapper classNameMapper;
    private final InternalOptions options;
    private final DexItemFactory dexItemFactory;

    public DebugStripper(ClassNameMapper classNameMapper, InternalOptions options, DexItemFactory dexItemFactory) {
        this.classNameMapper = classNameMapper;
        this.options = options;
        this.dexItemFactory = dexItemFactory;
    }

    private String descriptorToName(String descriptor) {
        return descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
    }

    private MemberNaming.Range findRange(int value, List<MemberNaming.Range> ranges, MemberNaming.Range defaultRange) {
        for (MemberNaming.Range range : ranges) {
            if (!range.contains(value)) continue;
            return range;
        }
        return defaultRange;
    }

    private NumberedDebugInfo processDebugInfo(DexEncodedMethod method, DexDebugInfo info, MemberNaming naming, int startLine) {
        if (info == null || naming == null) {
            return new NumberedDebugInfo(0, null);
        }
        List<MemberNaming.Range> ranges = naming.getInlineRanges();
        MemberNaming.Range currentRange = naming.topLevelRange;
        DexDebugEventBuilder builder = new DexDebugEventBuilder(method, this.dexItemFactory);
        int entryCount = 0;
        for (DexDebugEntry entry : info.computeEntries()) {
            boolean addEntry = false;
            if (currentRange != null && !currentRange.contains(entry.line)) {
                currentRange = null;
                addEntry = true;
            }
            if (currentRange == null && (currentRange = this.findRange(entry.line, ranges, naming.topLevelRange)) != null) {
                addEntry = true;
            }
            if (!addEntry) continue;
            if (entryCount == 0 && entry.address > 0) {
                ++entryCount;
                builder.setPosition(0, startLine);
            }
            int line = this.options.skipDebugLineNumberOpt ? entry.line : startLine + ranges.indexOf(currentRange) + 1;
            builder.setPosition(entry.address, line);
            ++entryCount;
        }
        if (entryCount == 0) {
            ++entryCount;
            builder.setPosition(0, startLine);
        }
        return new NumberedDebugInfo(entryCount, builder.build());
    }

    private void processCode(DexEncodedMethod encodedMethod, MemberNaming naming, Reference2IntMap<DexString> nameCounts) {
        int startLine;
        if (encodedMethod.getCode() == null) {
            return;
        }
        DexCode code = encodedMethod.getCode().asDexCode();
        DexString name = encodedMethod.method.name;
        DexDebugInfo originalInfo = code.getDebugInfo();
        if (originalInfo == null) {
            return;
        }
        boolean isUsedOnce = false;
        if (this.options.skipDebugLineNumberOpt) {
            startLine = originalInfo.startLine;
        } else {
            int nameCount = nameCounts.getInt((Object)name);
            if (nameCount == -1) {
                isUsedOnce = true;
                startLine = 0;
            } else {
                startLine = nameCount;
            }
        }
        NumberedDebugInfo numberedInfo = this.processDebugInfo(encodedMethod, originalInfo, naming, startLine);
        DexDebugInfo newInfo = numberedInfo.info;
        if (!this.options.skipDebugLineNumberOpt) {
            int previousCount = nameCounts.getInt((Object)name);
            nameCounts.put((Object)name, previousCount + numberedInfo.numberOfEntries);
            if (newInfo != null && isUsedOnce && newInfo.events.length == 0) {
                newInfo = null;
            } else if (naming != null && newInfo != null) {
                naming.setCollapsedStartLineNumber(startLine);
                naming.setOriginalStartLineNumber(originalInfo.startLine);
            }
        }
        code.setDebugInfo(newInfo);
    }

    private void processMethod(DexEncodedMethod method, ClassNaming classNaming, Reference2IntMap<DexString> nameCounts) {
        MemberNaming naming = null;
        if (classNaming != null) {
            MemberNaming.MethodSignature renamedSignature = this.classNameMapper.getRenamedMethodSignature(method.method);
            naming = classNaming.lookup(renamedSignature);
        }
        this.processCode(method, naming, nameCounts);
    }

    private void processMethods(DexEncodedMethod[] methods, ClassNaming naming, Reference2IntMap<DexString> nameCounts) {
        if (methods == null) {
            return;
        }
        for (DexEncodedMethod method : methods) {
            this.processMethod(method, naming, nameCounts);
        }
    }

    public void processClass(DexProgramClass clazz) {
        if (!clazz.hasMethodsOrFields()) {
            return;
        }
        String name = this.descriptorToName(clazz.type.toDescriptorString());
        ClassNaming naming = this.classNameMapper == null ? null : this.classNameMapper.getClassNaming(name);
        Reference2IntOpenHashMap nameCounts = new Reference2IntOpenHashMap();
        this.setIntialNameCounts((Reference2IntMap<DexString>)nameCounts, clazz.directMethods());
        this.setIntialNameCounts((Reference2IntMap<DexString>)nameCounts, clazz.virtualMethods());
        this.processMethods(clazz.directMethods(), naming, (Reference2IntMap<DexString>)nameCounts);
        this.processMethods(clazz.virtualMethods(), naming, (Reference2IntMap<DexString>)nameCounts);
    }

    private void setIntialNameCounts(Reference2IntMap<DexString> nameCounts, DexEncodedMethod[] methods) {
        for (DexEncodedMethod method : methods) {
            if (nameCounts.containsKey((Object)method.method.name)) {
                nameCounts.put((Object)method.method.name, 0);
                continue;
            }
            nameCounts.put((Object)method.method.name, -1);
        }
    }

    private static class NumberedDebugInfo {
        final int numberOfEntries;
        final DexDebugInfo info;

        public NumberedDebugInfo(int numberOfEntries, DexDebugInfo info) {
            this.numberOfEntries = numberOfEntries;
            this.info = info;
        }
    }
}

