/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.aapt2;

import com.android.SdkConstants;
import com.android.tools.aapt2.Aapt2Exception;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.io.Resources;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

enum Aapt2JniPlatform {
    WIN_64("win64", HashCode.fromString((String)"247a7e1d8a2d41bbc78d70e955aba2e0e0f28510667b008e4767e2dbc09d129d"), "libwinpthread-1.dll", "libaapt2_jni.dll"),
    WIN_32("win32", HashCode.fromString((String)"89edc789ff014204e00c6c227d85343d1fa758d3ac85c432462b8498a1b4f1ca"), "libwinpthread-1.dll", "libaapt2_jni.dll"),
    MAC_64("mac64", HashCode.fromString((String)"76acbf9b3587ba8339b3a07c7b4cdba8a3b8364611e7ee63fcade9699e3bb8d4"), "libc++.dylib", "libaapt2_jni.dylib"),
    LINUX_64("linux64", HashCode.fromString((String)"be6ce5d680fbd21271d2de31bf53589c4003cff3fcb17cbdbf7261af7c868b1e"), "libc++.so", "libaapt2_jni.so");

    private final String directoryName;
    private final HashCode cacheKey;
    private final ImmutableList<String> fileNames;

    private Aapt2JniPlatform(String directoryName, HashCode cacheKey, String ... fileNames) {
        this.directoryName = directoryName;
        this.cacheKey = cacheKey;
        this.fileNames = ImmutableList.copyOf((Object[])fileNames);
    }

    static Aapt2JniPlatform getCurrentPlatform() {
        boolean is64Bit = System.getProperty("os.arch").contains("64");
        switch (SdkConstants.CURRENT_PLATFORM) {
            case 2: {
                return is64Bit ? WIN_64 : WIN_32;
            }
            case 3: {
                if (!is64Bit) {
                    throw new Aapt2Exception("32-bit JVM is not supported");
                }
                return MAC_64;
            }
            case 1: {
                if (!is64Bit) {
                    throw new Aapt2Exception("32-bit JVM is not supported");
                }
                return LINUX_64;
            }
        }
        throw new IllegalStateException("Unknown platform");
    }

    HashCode getCacheKey() {
        return this.cacheKey;
    }

    void writeToDirectory(Path directory) throws IOException {
        for (String fileName : this.fileNames) {
            URL url = this.getResource(fileName);
            BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
            Throwable throwable = null;
            try {
                Files.copy(inputStream, directory.resolve(fileName), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)inputStream).close();
            }
        }
    }

    List<Path> getFiles(Path cacheDirectory) {
        return this.fileNames.stream().map(cacheDirectory::resolve).collect(Collectors.toList());
    }

    private URL getResource(String fileName) {
        return Resources.getResource((String)(this.directoryName + "/" + fileName));
    }
}

