/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.naming.NamingLens;
import java.io.UTFDataFormatException;
import java.util.Arrays;

public class DexString
extends IndexedDexItem
implements PresortedComparable<DexString> {
    public static final DexString[] EMPTY_ARRAY = new DexString[0];
    public final int size;
    public final byte[] content;

    DexString(int size, byte[] content) {
        this.size = size;
        this.content = content;
    }

    DexString(String string) {
        this.size = string.length();
        this.content = DexString.encode(string);
    }

    @Override
    public int computeHashCode() {
        return this.size * 7 + Arrays.hashCode(this.content);
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexString) {
            DexString o = (DexString)other;
            return this.size == o.size && Arrays.equals(this.content, o.content);
        }
        return false;
    }

    public String toString() {
        try {
            return this.decode();
        }
        catch (UTFDataFormatException e) {
            throw new RuntimeException("Bad format", e);
        }
    }

    public int numberOfLeadingSquareBrackets() {
        int result;
        for (result = 0; this.content.length > result && this.content[result] == 91; ++result) {
        }
        return result;
    }

    private String decode() throws UTFDataFormatException {
        int s = 0;
        int p = 0;
        char[] out = new char[this.size];
        while (true) {
            int b;
            char a;
            if ((a = (char)(this.content[p++] & 0xFF)) == '\u0000') {
                return new String(out, 0, s);
            }
            out[s] = a;
            if (a < '\u0080') {
                ++s;
                continue;
            }
            if ((a & 0xE0) == 192) {
                if (((b = this.content[p++] & 0xFF) & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) != 224) break;
            b = this.content[p++] & 0xFF;
            int c = this.content[p++] & 0xFF;
            if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                throw new UTFDataFormatException("bad second or third byte");
            }
            out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
        }
        throw new UTFDataFormatException("bad byte");
    }

    private static int countBytes(String string) {
        int result = 0;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            result = ch != '\u0000' && ch <= '\u007f' ? ++result : (ch <= '\u07ff' ? (result += 2) : (result += 3));
            assert (result > 0);
        }
        return result + 1;
    }

    private static byte[] encode(String string) {
        byte[] result = new byte[DexString.countBytes(string)];
        int offset = 0;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch != '\u0000' && ch <= '\u007f') {
                result[offset++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                result[offset++] = (byte)(0xC0 | 0x1F & ch >> 6);
                result[offset++] = (byte)(0x80 | 0x3F & ch);
                continue;
            }
            result[offset++] = (byte)(0xE0 | 0xF & ch >> 12);
            result[offset++] = (byte)(0x80 | 0x3F & ch >> 6);
            result[offset++] = (byte)(0x80 | 0x3F & ch);
        }
        result[offset] = 0;
        return result;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        indexedItems.addString(this);
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public int compareTo(DexString other) {
        return this.sortedCompareTo(other.getSortedIndex());
    }

    @Override
    public int slowCompareTo(DexString other) {
        int index = 0;
        while (true) {
            char b2;
            char b1;
            int diff;
            if ((diff = (b1 = (char)(this.content[index] & 0xFF)) - (b2 = (char)(other.content[index] & 0xFF))) != 0) {
                if (b1 == '\u0000' || b2 == '\u0000') {
                    return diff;
                }
                if (b1 == '\u00c0' && (this.content[index + 1] & 0xFF) == 128 || b2 == '\u00c0' && (other.content[index + 1] & 0xFF) == 128) {
                    return b1 == '\u00c0' && (this.content[index + 1] & 0xFF) == 128 ? -1 : 1;
                }
                return diff;
            }
            if (b1 == '\u0000') {
                return 0;
            }
            ++index;
        }
    }

    @Override
    public int slowCompareTo(DexString other, NamingLens lens) {
        return this.slowCompareTo(other);
    }

    @Override
    public int layeredCompareTo(DexString other, NamingLens lens) {
        return this.slowCompareTo(other);
    }

    private boolean isSimpleNameChar(char ch) {
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if (ch == '$' || ch == '-' || ch == '_') {
            return true;
        }
        if (ch >= '\u00a1' && ch <= '\u1fff') {
            return true;
        }
        if (ch >= '\u2010' && ch <= '\u2027') {
            return true;
        }
        if (ch >= '\u2030' && ch <= '\ud7ff') {
            return true;
        }
        if (ch >= '\ue000' && ch <= '\uffef') {
            return true;
        }
        return ch >= '\u10000' && ch <= '\u10ffff';
    }

    private boolean isValidClassDescriptor(String string) {
        if (string.length() < 3 || string.charAt(0) != 'L' || string.charAt(string.length() - 1) != ';') {
            return false;
        }
        if (string.charAt(1) == '/' || string.charAt(string.length() - 2) == '/') {
            return false;
        }
        for (int i = 1; i < string.length() - 1; ++i) {
            char ch = string.charAt(i);
            if (ch == '/' || this.isSimpleNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidMethodName(String string) {
        if (string.isEmpty()) {
            return false;
        }
        if (string.charAt(0) == '<' && (string.equals("<init>") || string.equals("<clinit>"))) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (this.isSimpleNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidFieldName(String string) {
        if (string.isEmpty()) {
            return false;
        }
        int start = 0;
        int end = string.length();
        if (string.charAt(0) == '<') {
            if (string.charAt(string.length() - 1) == '>') {
                start = 1;
                end = string.length() - 1;
            } else {
                return false;
            }
        }
        for (int i = start; i < end; ++i) {
            if (this.isSimpleNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isValidMethodName() {
        try {
            return this.isValidMethodName(this.decode());
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    public boolean isValidFieldName() {
        try {
            return this.isValidFieldName(this.decode());
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    public boolean isValidClassDescriptor() {
        try {
            return this.isValidClassDescriptor(this.decode());
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    public String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toString());
        builder.append(" [");
        for (int i = 0; i < this.content.length; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(Integer.toHexString(this.content[i] & 0xFF));
        }
        builder.append("]");
        return builder.toString();
    }
}

