/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ProgramClassVisitor;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class ObjectToOffsetMapping {
    private final int virtualFileId;
    private final DexProgramClass[] classes;
    private final DexProto[] protos;
    private final DexType[] types;
    private final DexMethod[] methods;
    private final DexField[] fields;
    private final DexString[] strings;
    private final DexCallSite[] callSites;
    private final DexMethodHandle[] methodHandles;
    private DexString firstJumboString;

    public ObjectToOffsetMapping(int virtualFileId, DexApplication application, DexProgramClass[] classes, DexProto[] protos, DexType[] types, DexMethod[] methods, DexField[] fields, DexString[] strings, DexCallSite[] callSites, DexMethodHandle[] methodHandles) {
        assert (application != null);
        assert (classes != null);
        assert (protos != null);
        assert (types != null);
        assert (methods != null);
        assert (fields != null);
        assert (strings != null);
        assert (callSites != null);
        assert (methodHandles != null);
        this.virtualFileId = virtualFileId;
        this.classes = ObjectToOffsetMapping.sortClasses(application, classes);
        this.protos = protos;
        this.types = types;
        this.methods = methods;
        this.fields = fields;
        this.strings = strings;
        this.callSites = callSites;
        this.methodHandles = methodHandles;
        Arrays.sort(protos);
        this.setIndexes(protos);
        Arrays.sort(types);
        this.setIndexes(types);
        Arrays.sort(methods);
        this.setIndexes(methods);
        Arrays.sort(fields);
        this.setIndexes(fields);
        Arrays.sort(strings);
        this.setIndexes(strings);
        this.setIndexes(callSites);
        this.setIndexes(methodHandles);
    }

    private static DexProgramClass[] sortClasses(DexApplication application, DexProgramClass[] classes) {
        Arrays.sort(classes, (o1, o2) -> o1.type.descriptor.slowCompareTo(o2.type.descriptor));
        SortingProgramClassVisitor classVisitor = new SortingProgramClassVisitor(application, classes);
        classVisitor.run(classes);
        return classVisitor.getSortedClasses();
    }

    private void setIndexes(IndexedDexItem[] items) {
        int index = 0;
        for (IndexedDexItem item : items) {
            item.assignVirtualFileIndex(this.virtualFileId, index);
            if (index > 65535) {
                assert (item instanceof DexString);
                if (index == 65536) {
                    this.firstJumboString = (DexString)item;
                }
            }
            ++index;
        }
    }

    public DexMethod[] getMethods() {
        return this.methods;
    }

    public DexProgramClass[] getClasses() {
        return this.classes;
    }

    public DexType[] getTypes() {
        return this.types;
    }

    public DexProto[] getProtos() {
        return this.protos;
    }

    public DexField[] getFields() {
        return this.fields;
    }

    public DexString[] getStrings() {
        return this.strings;
    }

    public DexCallSite[] getCallSites() {
        return this.callSites;
    }

    public DexMethodHandle[] getMethodHandles() {
        return this.methodHandles;
    }

    public boolean hasJumboStrings() {
        return this.firstJumboString != null;
    }

    public DexString getFirstJumboString() {
        return this.firstJumboString;
    }

    private boolean isContainedInMapping(IndexedDexItem item) {
        return item.getVirtualFileIndex(this.virtualFileId) != -2;
    }

    public int getOffsetFor(DexProto proto) {
        assert (this.isContainedInMapping(proto)) : "Missing dependency: " + proto;
        return proto.getVirtualFileIndex(this.virtualFileId);
    }

    public int getOffsetFor(DexField field) {
        assert (this.isContainedInMapping(field)) : "Missing dependency: " + field;
        return field.getVirtualFileIndex(this.virtualFileId);
    }

    public int getOffsetFor(DexMethod method) {
        assert (this.isContainedInMapping(method)) : "Missing dependency: " + method;
        return method.getVirtualFileIndex(this.virtualFileId);
    }

    public int getOffsetFor(DexString string) {
        assert (this.isContainedInMapping(string)) : "Missing dependency: " + string;
        return string.getVirtualFileIndex(this.virtualFileId);
    }

    public int getOffsetFor(DexType type) {
        assert (this.isContainedInMapping(type)) : "Missing dependency: " + type;
        return type.getVirtualFileIndex(this.virtualFileId);
    }

    public int getOffsetFor(DexCallSite callSite) {
        assert (this.isContainedInMapping(callSite)) : "Missing dependency: " + callSite;
        return callSite.getVirtualFileIndex(this.virtualFileId);
    }

    public int getOffsetFor(DexMethodHandle methodHandle) {
        assert (this.isContainedInMapping(methodHandle)) : "Missing dependency: " + methodHandle;
        return methodHandle.getVirtualFileIndex(this.virtualFileId);
    }

    private static class SortingProgramClassVisitor
    extends ProgramClassVisitor {
        private final Set<DexClass> classSet = Sets.newIdentityHashSet();
        private final DexProgramClass[] sortedClasses;
        private int index = 0;

        public SortingProgramClassVisitor(DexApplication application, DexProgramClass[] classes) {
            super(application);
            this.sortedClasses = new DexProgramClass[classes.length];
            Collections.addAll(this.classSet, classes);
        }

        @Override
        public void visit(DexType type) {
        }

        @Override
        public void visit(DexClass clazz) {
            if (this.classSet.contains(clazz)) {
                assert (this.index < this.sortedClasses.length);
                this.sortedClasses[this.index++] = (DexProgramClass)clazz;
            }
        }

        public DexProgramClass[] getSortedClasses() {
            assert (this.index == this.sortedClasses.length);
            return this.sortedClasses;
        }
    }
}

