/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.ConstStringJumbo;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;

public class ConstString
extends ConstInstruction {
    private final DexString value;

    public ConstString(Value dest, DexString value) {
        super(dest);
        dest.markNeverNull();
        this.value = value;
    }

    public Value dest() {
        return this.outValue;
    }

    public DexString getValue() {
        return this.value;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.registerStringReference(this.value);
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        if (builder.isJumboString(this.value)) {
            builder.add((Instruction)this, new ConstStringJumbo(dest, this.value));
        } else {
            builder.add((Instruction)this, new com.android.tools.r8.code.ConstString(dest, this.value));
        }
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        return other.asConstString().value == this.value;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.value.slowCompareTo(other.asConstString().value);
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "ConstString has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.value + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isConstString() {
        return true;
    }

    @Override
    public ConstString asConstString() {
        return this;
    }
}

