/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokePolymorphic;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CallGraph;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningInfo;

public class InliningOracle {
    final Inliner inliner;
    final DexEncodedMethod method;
    final Value receiver;
    final CallGraph callGraph;
    private final InliningInfo info;

    public InliningOracle(Inliner inliner, DexEncodedMethod method, Value receiver, CallGraph callGraph) {
        this.inliner = inliner;
        this.method = method;
        this.receiver = receiver;
        this.callGraph = callGraph;
        this.info = null;
    }

    public void finish() {
    }

    DexEncodedMethod validateCandidate(InvokeMethod invoke) {
        DexEncodedMethod candidate = invoke.computeSingleTarget(this.inliner.appInfo);
        if (candidate == null || candidate.getCode() == null || this.inliner.appInfo.definitionFor(candidate.method.getHolder()).isLibraryClass()) {
            if (this.info != null) {
                this.info.exclude(invoke, "No inlinee");
            }
            return null;
        }
        if (this.method == candidate) {
            assert (!candidate.getOptimizationInfo().forceInline());
            return null;
        }
        if (candidate.accessFlags.isSynchronized()) {
            if (this.info != null) {
                this.info.exclude(invoke, "Inlinee candidate is synchronized");
            }
            return null;
        }
        if (this.callGraph.isBreaker(this.method, candidate)) {
            return null;
        }
        if (!this.inliner.hasInliningAccess(this.method, candidate)) {
            if (this.info != null) {
                this.info.exclude(invoke, "Inlinee candidate does not have right access flags");
            }
            return null;
        }
        return candidate;
    }

    private Inliner.Reason computeInliningReason(DexEncodedMethod target) {
        if (target.getOptimizationInfo().forceInline()) {
            return Inliner.Reason.FORCE;
        }
        if (this.callGraph.hasSingleCallSite(target)) {
            return Inliner.Reason.SINGLE_CALLER;
        }
        if (this.isDoubleInliningTarget(target)) {
            return Inliner.Reason.DUAL_CALLER;
        }
        return Inliner.Reason.SIMPLE;
    }

    public Inliner.InlineAction computeForInvokeWithReceiver(InvokeMethodWithReceiver invoke) {
        boolean receiverIsNeverNull = invoke.receiverIsNeverNull();
        if (!receiverIsNeverNull) {
            if (this.info != null) {
                this.info.exclude(invoke, "receiver for candidate can be null");
            }
            return null;
        }
        DexEncodedMethod target = invoke.computeSingleTarget(this.inliner.appInfo);
        if (target == null) {
            if (this.info != null) {
                this.info.exclude(invoke, "could not find single target");
            }
            return null;
        }
        if (target == this.method) {
            assert (!target.getOptimizationInfo().forceInline());
            return null;
        }
        if (target.getCode() == null) {
            return null;
        }
        DexClass holder = this.inliner.appInfo.definitionFor(target.method.getHolder());
        if (holder.isInterface()) {
            if (this.info != null) {
                this.info.exclude(invoke, "Do not inline target if method holder is an interface class");
            }
            return null;
        }
        if (holder.isLibraryClass()) {
            return null;
        }
        if (target.accessFlags.isSynchronized()) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is synchronized");
            }
            return null;
        }
        Inliner.Reason reason = this.computeInliningReason(target);
        if (!target.isInliningCandidate(this.method, reason != Inliner.Reason.SIMPLE)) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is not identified for inlining");
            }
            return null;
        }
        if (this.callGraph.isBreaker(this.method, target)) {
            return null;
        }
        if (!this.inliner.hasInliningAccess(this.method, target)) {
            if (this.info != null) {
                this.info.exclude(invoke, "target does not have right access");
            }
            return null;
        }
        if (reason == Inliner.Reason.DUAL_CALLER && this.inliner.doubleInlining(this.method, target) == null) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is not ready for double inlining");
            }
            return null;
        }
        if (this.info != null) {
            this.info.include(invoke.getType(), target);
        }
        return new Inliner.InlineAction(target, invoke, reason);
    }

    public Inliner.InlineAction computeForInvokeVirtual(InvokeVirtual invoke) {
        return this.computeForInvokeWithReceiver(invoke);
    }

    public Inliner.InlineAction computeForInvokeInterface(InvokeInterface invoke) {
        return this.computeForInvokeWithReceiver(invoke);
    }

    public Inliner.InlineAction computeForInvokeDirect(InvokeDirect invoke) {
        return this.computeForInvokeWithReceiver(invoke);
    }

    private boolean canInlineStaticInvoke(DexEncodedMethod method, DexEncodedMethod target) {
        DexType targetHolder = target.method.getHolder();
        if (method.method.getHolder() == targetHolder) {
            return true;
        }
        DexClass clazz = this.inliner.appInfo.definitionFor(targetHolder);
        return clazz != null && !clazz.hasNonTrivialClassInitializer();
    }

    private synchronized boolean isDoubleInliningTarget(DexEncodedMethod candidate) {
        return this.callGraph.hasDoubleCallSite(candidate) && candidate.getCode().isDexCode() && candidate.getCode().asDexCode().instructions.length <= 10;
    }

    public Inliner.InlineAction computeForInvokeStatic(InvokeStatic invoke) {
        DexEncodedMethod candidate = this.validateCandidate(invoke);
        if (candidate == null) {
            return null;
        }
        Inliner.Reason reason = this.computeInliningReason(candidate);
        if (!candidate.isInliningCandidate(this.method, reason != Inliner.Reason.SIMPLE)) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is not identified for inlining");
            }
            return null;
        }
        if (!this.canInlineStaticInvoke(this.method, candidate)) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is static but we cannot guarantee class has been initialized");
            }
            return null;
        }
        if (reason == Inliner.Reason.DUAL_CALLER && this.inliner.doubleInlining(this.method, candidate) == null) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is not ready for double inlining");
            }
            return null;
        }
        if (this.info != null) {
            this.info.include(invoke.getType(), candidate);
        }
        return new Inliner.InlineAction(candidate, invoke, reason);
    }

    public Inliner.InlineAction computeForInvokeSuper(InvokeSuper invoke) {
        DexEncodedMethod candidate = this.validateCandidate(invoke);
        if (candidate == null) {
            if (this.info != null) {
                this.info.exclude(invoke, "not a valid inlining target");
            }
            return null;
        }
        if (this.info != null) {
            this.info.include(invoke.getType(), candidate);
        }
        return new Inliner.InlineAction(candidate, invoke, Inliner.Reason.SIMPLE);
    }

    public Inliner.InlineAction computeForInvokePolymorpic(InvokePolymorphic invoke) {
        if (this.info != null) {
            this.info.exclude(invoke, "inlining through invoke signature polymorpic is not supported");
        }
        return null;
    }
}

