/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.BasicBlockInstructionsEquivalence;
import com.android.tools.r8.ir.optimize.InstructionEquivalence;
import com.android.tools.r8.ir.optimize.MoveEliminator;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.google.common.base.Equivalence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class PeepholeOptimizer {
    public static void optimize(IRCode code, LinearScanRegisterAllocator allocator) {
        PeepholeOptimizer.removeIdenticalPredecessorBlocks(code, allocator);
        PeepholeOptimizer.removeRedundantInstructions(code, allocator);
        PeepholeOptimizer.shareIdenticalBlockSuffix(code, allocator);
        assert (code.isConsistentGraph());
    }

    private static void shareIdenticalBlockSuffix(IRCode code, RegisterAllocator allocator) {
        IdentityHashMap newBlocks;
        Collection<BasicBlock> blocks = code.blocks;
        do {
            int startNumberOfNewBlock = code.getHighestBlockNumber() + 1;
            newBlocks = new IdentityHashMap();
            for (BasicBlock block : blocks) {
                InstructionEquivalence equivalence = new InstructionEquivalence(allocator);
                HashMap<Equivalence.Wrapper, List> lastInstructionToBlocks = new HashMap<Equivalence.Wrapper, List>();
                for (BasicBlock pred : block.getPredecessors()) {
                    if (!pred.exit().isGoto() || pred.getSuccessors().size() != 1 || pred.getInstructions().size() <= 1) continue;
                    LinkedList<Instruction> instructions = pred.getInstructions();
                    Instruction lastInstruction = (Instruction)instructions.get(instructions.size() - 2);
                    List value = lastInstructionToBlocks.computeIfAbsent(equivalence.wrap(lastInstruction), k -> new ArrayList());
                    value.add(pred);
                }
                for (List predsWithSameLastInstruction : lastInstructionToBlocks.values()) {
                    if (predsWithSameLastInstruction.size() < 2) continue;
                    BasicBlock firstPred = (BasicBlock)predsWithSameLastInstruction.get(0);
                    int commonSuffixSize = firstPred.getInstructions().size();
                    for (int i = 1; i < predsWithSameLastInstruction.size(); ++i) {
                        BasicBlock pred = (BasicBlock)predsWithSameLastInstruction.get(i);
                        assert (pred.exit().isGoto());
                        commonSuffixSize = Math.min(commonSuffixSize, PeepholeOptimizer.sharedSuffixSizeExcludingExit(firstPred, pred, allocator));
                    }
                    assert (commonSuffixSize >= 1);
                    int blockNumber = startNumberOfNewBlock + newBlocks.size();
                    BasicBlock newBlock = PeepholeOptimizer.createAndInsertBlockForSuffix(blockNumber, commonSuffixSize, predsWithSameLastInstruction, block);
                    newBlocks.put(predsWithSameLastInstruction.get(0), newBlock);
                }
            }
            ListIterator<BasicBlock> blockIterator = code.listIterator();
            while (blockIterator.hasNext()) {
                BasicBlock block;
                block = blockIterator.next();
                if (!newBlocks.containsKey(block)) continue;
                blockIterator.add((BasicBlock)newBlocks.get(block));
            }
        } while (!(blocks = newBlocks.values()).isEmpty());
    }

    private static BasicBlock createAndInsertBlockForSuffix(int blockNumber, int suffixSize, List<BasicBlock> preds, BasicBlock block) {
        BasicBlock newBlock = BasicBlock.createGotoBlock(blockNumber);
        BasicBlock first = preds.get(0);
        InstructionListIterator from = first.listIterator(first.getInstructions().size() - 1);
        boolean movedThrowingInstruction = false;
        for (int i = 0; i < suffixSize; ++i) {
            Instruction instruction = (Instruction)from.previous();
            movedThrowingInstruction = movedThrowingInstruction || instruction.instructionTypeCanThrow();
            newBlock.getInstructions().addFirst(instruction);
            instruction.setBlock(newBlock);
        }
        if (movedThrowingInstruction && first.hasCatchHandlers()) {
            newBlock.transferCatchHandlers(first);
        }
        for (BasicBlock pred : preds) {
            LinkedList<Instruction> instructions = pred.getInstructions();
            Instruction exit = instructions.removeLast();
            for (int i = 0; i < suffixSize; ++i) {
                instructions.removeLast();
            }
            instructions.add(exit);
            newBlock.getPredecessors().add(pred);
            pred.replaceSuccessor(block, newBlock);
            block.getPredecessors().remove(pred);
            if (!movedThrowingInstruction) continue;
            pred.clearCatchHandlers();
        }
        newBlock.link(block);
        return newBlock;
    }

    private static int sharedSuffixSizeExcludingExit(BasicBlock block0, BasicBlock block1, RegisterAllocator allocator) {
        InstructionListIterator it0 = block0.listIterator(block0.getInstructions().size() - 1);
        InstructionListIterator it1 = block1.listIterator(block1.getInstructions().size() - 1);
        int suffixSize = 0;
        while (it0.hasPrevious() && it1.hasPrevious()) {
            Instruction i1;
            Instruction i0 = (Instruction)it0.previous();
            if (!i0.identicalAfterRegisterAllocation(i1 = (Instruction)it1.previous(), allocator)) {
                return suffixSize;
            }
            ++suffixSize;
        }
        return suffixSize;
    }

    private static void removeIdenticalPredecessorBlocks(IRCode code, RegisterAllocator allocator) {
        boolean changed;
        BasicBlockInstructionsEquivalence equivalence = new BasicBlockInstructionsEquivalence(allocator);
        do {
            changed = false;
            for (BasicBlock block : code.blocks) {
                HashMap<Equivalence.Wrapper, Integer> blockToIndex = new HashMap<Equivalence.Wrapper, Integer>();
                for (int predIndex = 0; predIndex < block.getPredecessors().size(); ++predIndex) {
                    BasicBlock pred = block.getPredecessors().get(predIndex);
                    if (pred.getInstructions().size() == 1) continue;
                    Equivalence.Wrapper wrapper = equivalence.wrap(pred);
                    if (blockToIndex.containsKey(wrapper)) {
                        changed = true;
                        int otherPredIndex = (Integer)blockToIndex.get(wrapper);
                        BasicBlock otherPred = block.getPredecessors().get(otherPredIndex);
                        pred.clearCatchHandlers();
                        pred.getInstructions().clear();
                        for (BasicBlock succ : pred.getSuccessors()) {
                            succ.removePredecessor(pred);
                        }
                        pred.getSuccessors().clear();
                        pred.getSuccessors().add(otherPred);
                        assert (!otherPred.getPredecessors().contains(pred));
                        otherPred.getPredecessors().add(pred);
                        Goto exit = new Goto();
                        exit.setBlock(pred);
                        pred.getInstructions().add(exit);
                        continue;
                    }
                    blockToIndex.put(wrapper, predIndex);
                }
            }
        } while (changed);
    }

    private static void removeRedundantInstructions(IRCode code, LinearScanRegisterAllocator allocator) {
        for (BasicBlock block : code.blocks) {
            HashMap<Integer, ConstNumber> registerToNumber = new HashMap<Integer, ConstNumber>();
            MoveEliminator moveEliminator = new MoveEliminator(allocator);
            ListIterator iterator = block.getInstructions().listIterator();
            while (iterator.hasNext()) {
                int outRegister;
                Instruction current = (Instruction)iterator.next();
                if (moveEliminator.shouldBeEliminated(current)) {
                    iterator.remove();
                    continue;
                }
                if (current.outValue() == null || !current.outValue().needsRegister()) continue;
                Value outValue = current.outValue();
                int instructionNumber = current.getNumber();
                if (outValue.isConstant() && current.isConstNumber()) {
                    if (PeepholeOptimizer.constantSpilledAtDefinition(current.asConstNumber(), allocator)) {
                        iterator.remove();
                        continue;
                    }
                    outRegister = allocator.getRegisterForValue(outValue, instructionNumber);
                    ConstNumber numberInRegister = (ConstNumber)registerToNumber.get(outRegister);
                    if (numberInRegister != null && numberInRegister.identicalNonValueParts(current)) {
                        iterator.remove();
                        continue;
                    }
                    registerToNumber.put(outRegister, current.asConstNumber());
                    if (current.outType() != MoveType.WIDE) continue;
                    registerToNumber.remove(outRegister + 1);
                    continue;
                }
                outRegister = allocator.getRegisterForValue(outValue, instructionNumber);
                for (int i = 0; i < outValue.requiredRegisters(); ++i) {
                    registerToNumber.remove(outRegister + i);
                }
            }
        }
    }

    private static boolean constantSpilledAtDefinition(ConstNumber constNumber, LinearScanRegisterAllocator allocator) {
        if (constNumber.outValue().isFixedRegisterValue()) {
            return false;
        }
        LiveIntervals definitionIntervals = constNumber.outValue().getLiveIntervals().getSplitCovering(constNumber.getNumber());
        return definitionIntervals.isSpilledAndRematerializable(allocator);
    }
}

