/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.NamingState;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MethodNameMinifier {
    private final AppInfoWithSubtyping appInfo;
    private final RootSetBuilder.RootSet rootSet;
    private final Map<DexType, NamingState<DexProto>> states = new IdentityHashMap<DexType, NamingState<DexProto>>();
    private final NamingState<DexProto> globalState;
    private MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
    private final List<String> dictionary;

    public MethodNameMinifier(AppInfoWithSubtyping appInfo, RootSetBuilder.RootSet rootSet, List<String> dictionary) {
        this.appInfo = appInfo;
        this.rootSet = rootSet;
        this.dictionary = dictionary;
        this.globalState = NamingState.createRoot(appInfo.dexItemFactory, dictionary);
    }

    public Map<DexMethod, DexString> computeRenaming(Timing timing) {
        timing.begin("Phase 1");
        IdentityHashMap<DexType, DexType> frontierMap = new IdentityHashMap<DexType, DexType>();
        this.reserveNamesInClasses(this.appInfo.dexItemFactory.objectType, this.appInfo.dexItemFactory.objectType, null, frontierMap);
        timing.end();
        timing.begin("Phase 2");
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, iface -> this.reserveNamesInInterfaces((DexType)iface, (Map<DexType, DexType>)frontierMap));
        timing.end();
        timing.begin("Phase 3");
        IdentityHashMap<DexMethod, DexString> renaming = new IdentityHashMap<DexMethod, DexString>();
        this.assignNamesToInterfaceMethods(frontierMap, renaming, timing);
        timing.end();
        timing.begin("Phase 4");
        this.assignNamesToClassesMethods(this.appInfo.dexItemFactory.objectType, false, renaming);
        timing.end();
        timing.begin("Phase 5");
        this.assignNamesToClassesMethods(this.appInfo.dexItemFactory.objectType, true, renaming);
        timing.end();
        return renaming;
    }

    private void assignNamesToClassesMethods(DexType type, boolean doPrivates, Map<DexMethod, DexString> renaming) {
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder != null && !holder.isLibraryClass()) {
            NamingState state = this.states.computeIfAbsent(type, k -> this.states.get(holder.superType).createChild());
            this.assignNamesToMethods(holder.directMethods(), state, doPrivates, renaming);
            this.assignNamesToMethods(holder.virtualMethods(), state, doPrivates, renaming);
        }
        type.forAllExtendsSubtypes(subtype -> this.assignNamesToClassesMethods((DexType)subtype, doPrivates, renaming));
    }

    private void assignNamesToMethods(DexEncodedMethod[] methods, NamingState<DexProto> state, boolean doPrivates, Map<DexMethod, DexString> renaming) {
        for (DexEncodedMethod encodedMethod : methods) {
            if (encodedMethod.accessFlags.isPrivate() != doPrivates) continue;
            DexMethod method = encodedMethod.method;
            if (state.isReserved(method.name, method.proto) || encodedMethod.accessFlags.isConstructor()) continue;
            renaming.put(method, state.assignNewNameFor(method.name, method.proto, !doPrivates));
        }
    }

    private Set<NamingState<DexProto>> getReachableStates(DexType type, Map<DexType, DexType> frontierMap) {
        Set interfaces = Sets.newIdentityHashSet();
        interfaces.add(type);
        this.collectSuperInterfaces(type, interfaces);
        this.collectSubInterfaces(type, interfaces);
        HashSet<NamingState<DexProto>> reachableStates = new HashSet<NamingState<DexProto>>();
        for (DexType iface : interfaces) {
            reachableStates.add(this.states.get(iface));
            iface.forAllImplementsSubtypes(t -> {
                NamingState<DexProto> state = this.states.get(frontierMap.get(t));
                assert (state != null);
                reachableStates.add(state);
            });
        }
        return reachableStates;
    }

    private void assignNamesToInterfaceMethods(Map<DexType, DexType> frontierMap, Map<DexMethod, DexString> renaming, Timing timing) {
        timing.begin("Compute map");
        HashMap globalStateMap = new HashMap();
        HashMap sourceMethodsMap = new HashMap();
        HashMap originStates = new HashMap();
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, iface -> {
            assert (iface.isInterface());
            DexClass clazz = this.appInfo.definitionFor((DexType)iface);
            if (clazz != null) {
                Set<NamingState<DexProto>> collectedStates = this.getReachableStates((DexType)iface, frontierMap);
                this.addStatesToGlobalMapForMethods(clazz.directMethods(), collectedStates, globalStateMap, sourceMethodsMap, originStates, (DexType)iface);
                this.addStatesToGlobalMapForMethods(clazz.virtualMethods(), collectedStates, globalStateMap, sourceMethodsMap, originStates, (DexType)iface);
            }
        });
        timing.end();
        timing.begin("Allocate names");
        ArrayList methods = new ArrayList(globalStateMap.keySet());
        methods.sort((a, b) -> ((Set)globalStateMap.get(b)).size() - ((Set)globalStateMap.get(a)).size());
        for (Equivalence.Wrapper key : methods) {
            DexMethod method = (DexMethod)key.get();
            this.assignNameForInterfaceMethodInAllStates(method, (Set)globalStateMap.get(key), (Set)sourceMethodsMap.get(key), renaming, (NamingState)originStates.get(key));
        }
        timing.end();
    }

    private void collectSuperInterfaces(DexType iface, Set<DexType> interfaces) {
        DexClass clazz = this.appInfo.definitionFor(iface);
        if (clazz != null) {
            for (DexType type : clazz.interfaces.values) {
                if (!interfaces.add(type)) continue;
                this.collectSuperInterfaces(type, interfaces);
            }
        }
    }

    private void collectSubInterfaces(DexType iface, Set<DexType> interfaces) {
        DexClass clazz = this.appInfo.definitionFor(iface);
        iface.forAllExtendsSubtypes(subtype -> {
            assert (subtype.isInterface());
            if (interfaces.add((DexType)subtype)) {
                this.collectSubInterfaces((DexType)subtype, interfaces);
            }
        });
    }

    private void addStatesToGlobalMapForMethods(DexEncodedMethod[] methods, Set<NamingState<DexProto>> collectedStates, Map<Equivalence.Wrapper<DexMethod>, Set<NamingState<DexProto>>> globalStateMap, Map<Equivalence.Wrapper<DexMethod>, Set<DexMethod>> sourceMethodsMap, Map<Equivalence.Wrapper<DexMethod>, NamingState<DexProto>> originStates, DexType originInterface) {
        for (DexEncodedMethod method : methods) {
            Equivalence.Wrapper key = this.equivalence.wrap(method.method);
            Set stateSet = globalStateMap.computeIfAbsent((Equivalence.Wrapper<DexMethod>)key, k -> new HashSet());
            stateSet.addAll(collectedStates);
            sourceMethodsMap.computeIfAbsent((Equivalence.Wrapper<DexMethod>)key, k -> new HashSet()).add(method.method);
            originStates.putIfAbsent((Equivalence.Wrapper<DexMethod>)key, this.states.get(originInterface));
        }
    }

    private void assignNameForInterfaceMethodInAllStates(DexMethod method, Set<NamingState<DexProto>> collectedStates, Set<DexMethod> sourceMethods, Map<DexMethod, DexString> renaming, NamingState<DexProto> originState) {
        boolean isReserved = false;
        if (this.globalState.isReserved(method.name, method.proto)) {
            for (NamingState<DexProto> state : collectedStates) {
                if (!state.isReserved(method.name, method.proto)) continue;
                isReserved = true;
                break;
            }
            if (isReserved) {
                for (NamingState<DexProto> state : collectedStates) {
                    state.reserveName(method.name, method.proto);
                }
                return;
            }
        }
        DexString candidate = null;
        block2: do {
            candidate = originState.assignNewNameFor(method.name, method.proto, false);
            for (NamingState<DexProto> state : collectedStates) {
                if (state.isAvailable(method.name, method.proto, candidate)) continue;
                candidate = null;
                continue block2;
            }
        } while (candidate == null);
        for (NamingState<DexProto> state : collectedStates) {
            state.addRenaming(method.name, method.proto, candidate);
        }
        for (DexMethod sourceMethod : sourceMethods) {
            renaming.put(sourceMethod, candidate);
        }
    }

    private void reserveNamesInClasses(DexType type, DexType libraryFrontier, NamingState<DexProto> parent, Map<DexType, DexType> frontierMap) {
        assert (!type.isInterface());
        DexClass holder = this.appInfo.definitionFor(type);
        NamingState<DexProto> state = this.allocateNamingStateAndReserve(holder, type, libraryFrontier, parent, frontierMap);
        type.forAllExtendsSubtypes(subtype -> {
            assert (!subtype.isInterface());
            this.reserveNamesInClasses((DexType)subtype, holder == null || holder.isLibraryClass() ? subtype : libraryFrontier, state, frontierMap);
        });
    }

    private void reserveNamesInInterfaces(DexType type, Map<DexType, DexType> frontierMap) {
        assert (type.isInterface());
        frontierMap.put(type, type);
        DexClass holder = this.appInfo.definitionFor(type);
        this.allocateNamingStateAndReserve(holder, type, type, null, frontierMap);
    }

    private NamingState<DexProto> allocateNamingStateAndReserve(DexClass holder, DexType type, DexType libraryFrontier, NamingState<DexProto> parent, Map<DexType, DexType> frontierMap) {
        frontierMap.put(type, libraryFrontier);
        NamingState state = this.states.computeIfAbsent(libraryFrontier, ignore -> parent == null ? NamingState.createRoot(this.appInfo.dexItemFactory, this.dictionary) : parent.createChild());
        if (holder != null) {
            boolean keepAll = holder.isLibraryClass() || holder.accessFlags.isAnnotation();
            holder.forEachMethod(method -> this.reserveNamesForMethod((DexEncodedMethod)method, keepAll, state));
        }
        return state;
    }

    private void reserveNamesForMethod(DexEncodedMethod method, boolean keepAll, NamingState<DexProto> state) {
        if (keepAll || this.rootSet.noObfuscation.contains(method)) {
            state.reserveName(method.method.name, method.method.proto);
            this.globalState.reserveName(method.method.name, method.method.proto);
        }
    }
}

