/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.naming.DictionaryReader;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProguardConfiguration {
    private final DexItemFactory dexItemFactory;
    private final List<Path> injars;
    private final List<Path> libraryjars;
    private final String packagePrefix;
    private final boolean allowAccessModification;
    private final boolean ignoreWarnings;
    private final boolean obfuscating;
    private final boolean shrinking;
    private final boolean printUsage;
    private final Path printUsageFile;
    private final boolean printMapping;
    private final Path printMappingOutput;
    private final boolean verbose;
    private final List<String> attributesRemovalPatterns;
    private final ImmutableSet<ProguardTypeMatcher> dontWarnPatterns;
    protected final ImmutableList<ProguardConfigurationRule> rules;
    private final boolean printSeeds;
    private final Path seedFile;
    private final List<String> obfuscationDictionary;
    private final List<String> classObfuscationDictionary;
    private final List<String> packageObfuscationDictionary;

    private ProguardConfiguration(DexItemFactory factory, List<Path> injars, List<Path> libraryjars, String packagePrefix, boolean allowAccessModification, boolean ignoreWarnings, boolean obfuscating, boolean shrinking, boolean printUsage, Path printUsageFile, boolean printMapping, Path printMappingOutput, boolean verbose, List<String> attributesRemovalPatterns, Set<ProguardTypeMatcher> dontWarnPatterns, List<ProguardConfigurationRule> rules, boolean printSeeds, Path seedFile, List<String> obfuscationDictionary, List<String> classObfuscationDictionary, List<String> packageObfuscationDictionary) {
        this.dexItemFactory = factory;
        this.injars = ImmutableList.copyOf(injars);
        this.libraryjars = ImmutableList.copyOf(libraryjars);
        this.packagePrefix = packagePrefix;
        this.allowAccessModification = allowAccessModification;
        this.ignoreWarnings = ignoreWarnings;
        this.obfuscating = obfuscating;
        this.shrinking = shrinking;
        this.printUsage = printUsage;
        this.printUsageFile = printUsageFile;
        this.printMapping = printMapping;
        this.printMappingOutput = printMappingOutput;
        this.verbose = verbose;
        this.attributesRemovalPatterns = ImmutableList.copyOf(attributesRemovalPatterns);
        this.dontWarnPatterns = ImmutableSet.copyOf(dontWarnPatterns);
        this.rules = ImmutableList.copyOf(rules);
        this.printSeeds = printSeeds;
        this.seedFile = seedFile;
        this.obfuscationDictionary = obfuscationDictionary;
        this.classObfuscationDictionary = classObfuscationDictionary;
        this.packageObfuscationDictionary = packageObfuscationDictionary;
    }

    public static Builder builder(DexItemFactory dexItemFactory) {
        return new Builder(dexItemFactory);
    }

    public DexItemFactory getDexItemFactory() {
        return this.dexItemFactory;
    }

    public boolean isDefaultConfiguration() {
        return false;
    }

    public List<Path> getInjars() {
        return this.injars;
    }

    public List<Path> getLibraryjars() {
        return this.libraryjars;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public boolean getAllowAccessModification() {
        return this.allowAccessModification;
    }

    public boolean isPrintingMapping() {
        return this.printMapping;
    }

    public Path getPrintMappingOutput() {
        return this.printMappingOutput;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public boolean isObfuscating() {
        return this.obfuscating;
    }

    public boolean isShrinking() {
        return this.shrinking;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public Path getPrintUsageFile() {
        return this.printUsageFile;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public List<String> getAttributesRemovalPatterns() {
        return this.attributesRemovalPatterns;
    }

    public ImmutableSet<ProguardTypeMatcher> getDontWarnPatterns() {
        return this.dontWarnPatterns;
    }

    public ImmutableList<ProguardConfigurationRule> getRules() {
        return this.rules;
    }

    public List<String> getObfuscationDictionary() {
        return this.obfuscationDictionary;
    }

    public List<String> getPackageObfuscationDictionary() {
        return this.packageObfuscationDictionary;
    }

    public List<String> getClassObfuscationDictionary() {
        return this.classObfuscationDictionary;
    }

    public static ProguardConfiguration defaultConfiguration(DexItemFactory dexItemFactory) {
        DefaultProguardConfiguration config = new DefaultProguardConfiguration(dexItemFactory);
        return config;
    }

    public boolean getPrintSeeds() {
        return this.printSeeds;
    }

    public Path getSeedFile() {
        return this.seedFile;
    }

    public static class DefaultProguardConfiguration
    extends ProguardConfiguration {
        public DefaultProguardConfiguration(DexItemFactory factory) {
            super(factory, (List)ImmutableList.of(), (List)ImmutableList.of(), "", false, false, false, false, false, null, false, null, false, (List)ImmutableList.of(), (Set)ImmutableSet.of(), (List)ImmutableList.of((Object)ProguardKeepRule.defaultKeepAllRule()), false, null, (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of());
        }

        @Override
        public boolean isDefaultConfiguration() {
            return true;
        }
    }

    public static class Builder {
        private final List<Path> injars = new ArrayList<Path>();
        private final List<Path> libraryjars = new ArrayList<Path>();
        private String packagePrefix = null;
        private boolean allowAccessModification = false;
        private boolean ignoreWarnings = false;
        private boolean obfuscating = true;
        private boolean shrinking = true;
        private boolean printUsage = false;
        private Path printUsageFile;
        private boolean printMapping;
        private Path printMappingOutput;
        private boolean verbose = false;
        private final List<String> attributesRemovalPatterns = new ArrayList<String>();
        private final Set<ProguardTypeMatcher> dontWarnPatterns = new HashSet<ProguardTypeMatcher>();
        protected final List<ProguardConfigurationRule> rules = new ArrayList<ProguardConfigurationRule>();
        private final DexItemFactory dexItemFactory;
        private boolean printSeeds;
        private Path seedFile;
        private Path obfuscationDictionary;
        private Path classObfuscationDictionary;
        private Path packageObfuscationDictionary;

        private Builder(DexItemFactory dexItemFactory) {
            this.dexItemFactory = dexItemFactory;
        }

        public void addInjars(List<Path> injars) {
            this.injars.addAll(injars);
        }

        public void addLibraryJars(List<Path> libraryJars) {
            this.libraryjars.addAll(libraryJars);
        }

        public void setPackagePrefix(String packagePrefix) {
            this.packagePrefix = packagePrefix;
        }

        public void setAllowAccessModification(boolean allowAccessModification) {
            this.allowAccessModification = allowAccessModification;
        }

        public void setIgnoreWarnings(boolean ignoreWarnings) {
            this.ignoreWarnings = ignoreWarnings;
        }

        public void setObfuscating(boolean obfuscate) {
            this.obfuscating = obfuscate;
        }

        public void setShrinking(boolean shrinking) {
            this.shrinking = shrinking;
        }

        public void setPrintUsage(boolean printUsage) {
            this.printUsage = printUsage;
        }

        public void setPrintUsageFile(Path printUsageFile) {
            this.printUsageFile = printUsageFile;
        }

        public void setPrintMapping(boolean printMapping) {
            this.printMapping = printMapping;
        }

        public void setPrintMappingOutput(Path file) {
            this.printMappingOutput = file;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public void addAttributeRemovalPattern(String attributesRemovalPattern) {
            this.attributesRemovalPatterns.add(attributesRemovalPattern);
        }

        public void addRule(ProguardConfigurationRule rule) {
            this.rules.add(rule);
        }

        public void addDontWarnPattern(ProguardTypeMatcher pattern) {
            this.dontWarnPatterns.add(pattern);
        }

        public void setSeedFile(Path seedFile) {
            this.seedFile = seedFile;
        }

        public void setPrintSeed(boolean printSeeds) {
            this.printSeeds = printSeeds;
        }

        public void setObfuscationDictionary(Path obfuscationDictionary) {
            this.obfuscationDictionary = obfuscationDictionary;
        }

        public void setClassObfuscationDictionary(Path classObfuscationDictionary) {
            this.classObfuscationDictionary = classObfuscationDictionary;
        }

        public void setPackageObfuscationDictionary(Path packageObfuscationDictionary) {
            this.packageObfuscationDictionary = packageObfuscationDictionary;
        }

        public ProguardConfiguration build() {
            return new ProguardConfiguration(this.dexItemFactory, this.injars, this.libraryjars, this.packagePrefix, this.allowAccessModification, this.ignoreWarnings, this.obfuscating, this.shrinking, this.printUsage, this.printUsageFile, this.printMapping, this.printMappingOutput, this.verbose, this.attributesRemovalPatterns, this.dontWarnPatterns, this.rules, this.printSeeds, this.seedFile, DictionaryReader.readAllNames(this.obfuscationDictionary), DictionaryReader.readAllNames(this.classObfuscationDictionary), DictionaryReader.readAllNames(this.packageObfuscationDictionary));
        }
    }
}

