/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexAccessFlags;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import com.android.tools.r8.shaking.ProguardClassSpecification;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardMemberRuleReturnValue;
import com.android.tools.r8.shaking.ProguardMemberType;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.LongInterval;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProguardConfigurationParser {
    private final ProguardConfiguration.Builder configurationBuilder;
    private final DexItemFactory dexItemFactory;
    private static final List<String> ignoredSingleArgOptions = ImmutableList.of((Object)"protomapping", (Object)"optimizationpasses", (Object)"target");
    private static final List<String> ignoredOptionalSingleArgOptions = ImmutableList.of((Object)"keepdirectories", (Object)"runtype", (Object)"laststageoutput");
    private static final List<String> ignoredFlagOptions = ImmutableList.of((Object)"forceprocessing", (Object)"dontusemixedcaseclassnames", (Object)"dontpreverify", (Object)"experimentalshrinkunusedprotofields", (Object)"filterlibraryjarswithorginalprogramjars", (Object)"dontskipnonpubliclibraryclasses", (Object)"dontskipnonpubliclibraryclassmembers", (Object)"overloadaggressively", (Object)"invokebasemethod");
    private static final List<String> ignoredClassDescriptorOptions = ImmutableList.of((Object)"isclassnamestring", (Object)"alwaysinline", (Object)"identifiernamestring", (Object)"whyarenotsimple");
    private static final List<String> warnedSingleArgOptions = ImmutableList.of((Object)"renamesourcefileattribute", (Object)"dontnote", (Object)"printconfiguration", (Object)"outjars", (Object)"adaptresourcefilecontents");
    private static final List<String> warnedFlagOptions = ImmutableList.of((Object)"dontoptimize");
    private static final List<String> unsupportedFlagOptions = ImmutableList.of((Object)"skipnonpubliclibraryclasses");

    public ProguardConfigurationParser(DexItemFactory dexItemFactory) {
        this.dexItemFactory = dexItemFactory;
        this.configurationBuilder = ProguardConfiguration.builder(dexItemFactory);
    }

    public ProguardConfiguration getConfig() {
        return this.configurationBuilder.build();
    }

    public void parse(Path path) throws ProguardRuleParserException, IOException {
        this.parse(Collections.singletonList(path));
    }

    public void parse(List<Path> pathList) throws ProguardRuleParserException, IOException {
        for (Path path : pathList) {
            new ProguardFileParser(path).parse();
        }
    }

    private class ProguardFileParser {
        private final Path path;
        private final String contents;
        private int position = 0;
        private Path baseDirectory;

        public ProguardFileParser(Path path) throws IOException {
            this.path = path;
            this.contents = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            this.baseDirectory = path.getParent();
            if (this.baseDirectory == null) {
                this.baseDirectory = Paths.get(".", new String[0]);
            }
        }

        public void parse() throws ProguardRuleParserException {
            do {
                this.skipWhitespace();
            } while (this.parseOption());
        }

        private boolean parseOption() throws ProguardRuleParserException {
            if (this.eof()) {
                return false;
            }
            if (this.acceptArobaseInclude()) {
                return true;
            }
            this.expectChar('-');
            if (!(Iterables.any((Iterable)ignoredSingleArgOptions, this::skipOptionWithSingleArg) || Iterables.any((Iterable)ignoredOptionalSingleArgOptions, this::skipOptionWithOptionalSingleArg) || Iterables.any((Iterable)ignoredFlagOptions, this::skipFlag) || Iterables.any((Iterable)ignoredClassDescriptorOptions, this::skipOptionWithClassSpec) || this.parseOptimizationOption())) {
                String option = (String)Iterables.find((Iterable)warnedSingleArgOptions, this::skipOptionWithSingleArg, null);
                if (option != null || (option = (String)Iterables.find((Iterable)warnedFlagOptions, this::skipFlag, null)) != null) {
                    System.out.println("WARNING: Ignoring option: -" + option);
                } else {
                    option = (String)Iterables.find((Iterable)unsupportedFlagOptions, this::skipFlag, null);
                    if (option != null) {
                        throw this.parseError("Unsupported option: -" + option);
                    }
                    if (this.acceptString("keepattributes")) {
                        this.parseKeepAttributes();
                    } else if (this.acceptString("keeppackagenames")) {
                        ProguardKeepRule rule = this.parseKeepPackageNamesRule();
                        ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                    } else if (this.acceptString("checkdiscard")) {
                        ProguardKeepRule rule = this.parseCheckDiscardRule();
                        ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                    } else if (this.acceptString("keep")) {
                        ProguardKeepRule rule = this.parseKeepRule();
                        ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                    } else if (this.acceptString("whyareyoukeeping")) {
                        ProguardKeepRule rule = this.parseWhyAreYouKeepingRule();
                        ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                    } else if (this.acceptString("dontobfuscate")) {
                        ProguardConfigurationParser.this.configurationBuilder.setObfuscating(false);
                    } else if (this.acceptString("dontshrink")) {
                        ProguardConfigurationParser.this.configurationBuilder.setShrinking(false);
                    } else if (this.acceptString("printusage")) {
                        ProguardConfigurationParser.this.configurationBuilder.setPrintUsage(true);
                        this.skipWhitespace();
                        if (this.isOptionalArgumentGiven()) {
                            ProguardConfigurationParser.this.configurationBuilder.setPrintUsageFile(this.parseFileName());
                        }
                        System.out.println("WARNING: Ignoring option: -printusage");
                    } else if (this.acceptString("verbose")) {
                        ProguardConfigurationParser.this.configurationBuilder.setVerbose(true);
                    } else if (this.acceptString("ignorewarnings")) {
                        ProguardConfigurationParser.this.configurationBuilder.setIgnoreWarnings(true);
                    } else if (this.acceptString("dontwarn")) {
                        do {
                            ProguardTypeMatcher pattern = ProguardTypeMatcher.create(this.parseClassName(), ProguardTypeMatcher.ClassOrType.CLASS, ProguardConfigurationParser.this.dexItemFactory);
                            ProguardConfigurationParser.this.configurationBuilder.addDontWarnPattern(pattern);
                        } while (this.acceptChar(','));
                    } else if (this.acceptString("repackageclasses")) {
                        this.skipWhitespace();
                        if (this.acceptChar('\'')) {
                            ProguardConfigurationParser.this.configurationBuilder.setPackagePrefix(this.parsePackageNameOrEmptyString());
                            this.expectChar('\'');
                        } else {
                            ProguardConfigurationParser.this.configurationBuilder.setPackagePrefix("");
                        }
                    } else if (this.acceptString("allowaccessmodification")) {
                        ProguardConfigurationParser.this.configurationBuilder.setAllowAccessModification(true);
                    } else if (this.acceptString("printmapping")) {
                        ProguardConfigurationParser.this.configurationBuilder.setPrintMapping(true);
                        this.skipWhitespace();
                        if (this.isOptionalArgumentGiven()) {
                            ProguardConfigurationParser.this.configurationBuilder.setPrintMappingOutput(this.parseFileName());
                        }
                    } else if (this.acceptString("assumenosideeffects")) {
                        ProguardAssumeNoSideEffectRule rule = this.parseAssumeNoSideEffectsRule();
                        ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                    } else if (this.acceptString("assumevalues")) {
                        ProguardAssumeValuesRule rule = this.parseAssumeValuesRule();
                        ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                    } else if (this.acceptString("include")) {
                        this.skipWhitespace();
                        this.parseInclude();
                    } else if (this.acceptString("basedirectory")) {
                        this.skipWhitespace();
                        this.baseDirectory = this.parseFileName();
                    } else if (this.acceptString("injars")) {
                        ProguardConfigurationParser.this.configurationBuilder.addInjars(this.parseClassPath());
                    } else if (this.acceptString("libraryjars")) {
                        ProguardConfigurationParser.this.configurationBuilder.addLibraryJars(this.parseClassPath());
                    } else if (this.acceptString("printseeds")) {
                        ProguardConfigurationParser.this.configurationBuilder.setPrintSeed(true);
                        this.skipWhitespace();
                        if (this.isOptionalArgumentGiven()) {
                            ProguardConfigurationParser.this.configurationBuilder.setSeedFile(this.parseFileName());
                        }
                    } else if (this.acceptString("obfuscationdictionary")) {
                        ProguardConfigurationParser.this.configurationBuilder.setObfuscationDictionary(this.parseFileName());
                    } else if (this.acceptString("classobfuscationdictionary")) {
                        ProguardConfigurationParser.this.configurationBuilder.setClassObfuscationDictionary(this.parseFileName());
                    } else if (this.acceptString("packageobfuscationdictionary")) {
                        ProguardConfigurationParser.this.configurationBuilder.setPackageObfuscationDictionary(this.parseFileName());
                    } else {
                        throw this.parseError("Unknown option");
                    }
                }
            }
            return true;
        }

        private void parseInclude() throws ProguardRuleParserException {
            Path included = this.parseFileName();
            try {
                new ProguardFileParser(included).parse();
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                throw this.parseError("Included file '" + included.toString() + "' not found", e);
            }
            catch (IOException e) {
                throw this.parseError("Failed to read included file '" + included.toString() + "'", e);
            }
        }

        private boolean acceptArobaseInclude() throws ProguardRuleParserException {
            if (this.remainingChars() < 2) {
                return false;
            }
            if (!this.acceptChar('@')) {
                return false;
            }
            this.parseInclude();
            return true;
        }

        private void parseKeepAttributes() throws ProguardRuleParserException {
            String attributesPattern = this.acceptPatternList();
            if (attributesPattern == null) {
                throw this.parseError("Expected attribute pattern list");
            }
            ProguardConfigurationParser.this.configurationBuilder.addAttributeRemovalPattern(attributesPattern);
        }

        private boolean skipFlag(String name) {
            return this.acceptString(name);
        }

        private boolean skipOptionWithSingleArg(String name) {
            if (this.acceptString(name)) {
                this.skipSingleArgument();
                return true;
            }
            return false;
        }

        private boolean skipOptionWithOptionalSingleArg(String name) {
            if (this.acceptString(name)) {
                this.skipWhitespace();
                if (this.isOptionalArgumentGiven()) {
                    this.skipSingleArgument();
                }
                return true;
            }
            return false;
        }

        private boolean skipOptionWithClassSpec(String name) {
            if (this.acceptString(name)) {
                try {
                    ProguardKeepRule.Builder keepRuleBuilder = ProguardKeepRule.builder();
                    this.parseClassFlagsAndAnnotations(keepRuleBuilder);
                    keepRuleBuilder.setClassType(this.parseClassType());
                    keepRuleBuilder.setClassNames(this.parseClassNames());
                    this.parseInheritance(keepRuleBuilder);
                    this.parseMemberRules(keepRuleBuilder, true);
                    return true;
                }
                catch (ProguardRuleParserException e) {
                    System.out.println(e);
                    return false;
                }
            }
            return false;
        }

        private boolean parseOptimizationOption() {
            if (!this.acceptString("optimizations")) {
                return false;
            }
            this.skipWhitespace();
            do {
                this.skipOptimizationName();
                this.skipWhitespace();
            } while (this.acceptChar(','));
            return true;
        }

        private void skipOptimizationName() {
            if (this.acceptChar('!')) {
                this.skipWhitespace();
            }
            char next = this.peekChar();
            while (Character.isAlphabetic(next) || next == '/' || next == '*') {
                this.readChar();
                next = this.peekChar();
            }
        }

        private void skipSingleArgument() {
            this.skipWhitespace();
            while (!this.eof() && !Character.isWhitespace(this.peekChar())) {
                this.readChar();
            }
        }

        private ProguardKeepRule parseKeepRule() throws ProguardRuleParserException {
            ProguardKeepRule.Builder keepRuleBuilder = ProguardKeepRule.builder();
            this.parseRuleTypeAndModifiers(keepRuleBuilder);
            this.parseClassSpec(keepRuleBuilder, false);
            return keepRuleBuilder.build();
        }

        private ProguardKeepRule parseWhyAreYouKeepingRule() throws ProguardRuleParserException {
            ProguardKeepRule.Builder keepRuleBuilder = ProguardKeepRule.builder();
            keepRuleBuilder.getModifiersBuilder().setFlagsToHaveNoEffect();
            keepRuleBuilder.getModifiersBuilder().whyAreYouKeeping = true;
            keepRuleBuilder.setType(ProguardKeepRuleType.KEEP);
            this.parseClassSpec(keepRuleBuilder, false);
            return keepRuleBuilder.build();
        }

        private ProguardKeepRule parseKeepPackageNamesRule() throws ProguardRuleParserException {
            ProguardKeepRule.Builder keepRuleBuilder = ProguardKeepRule.builder();
            keepRuleBuilder.getModifiersBuilder().setFlagsToHaveNoEffect();
            keepRuleBuilder.getModifiersBuilder().keepPackageNames = true;
            keepRuleBuilder.setType(ProguardKeepRuleType.KEEP);
            keepRuleBuilder.setClassNames(this.parseClassNames());
            return keepRuleBuilder.build();
        }

        private ProguardKeepRule parseCheckDiscardRule() throws ProguardRuleParserException {
            ProguardKeepRule.Builder keepRuleBuilder = ProguardKeepRule.builder();
            keepRuleBuilder.getModifiersBuilder().setFlagsToHaveNoEffect();
            keepRuleBuilder.getModifiersBuilder().checkDiscarded = true;
            this.parseClassSpec(keepRuleBuilder, false);
            keepRuleBuilder.setType(keepRuleBuilder.getMemberRules().isEmpty() ? ProguardKeepRuleType.KEEP : ProguardKeepRuleType.KEEP_CLASS_MEMBERS);
            return keepRuleBuilder.build();
        }

        private void parseClassSpec(ProguardClassSpecification.Builder builder, boolean allowValueSpecification) throws ProguardRuleParserException {
            this.parseClassFlagsAndAnnotations(builder);
            builder.setClassType(this.parseClassType());
            builder.setClassNames(this.parseClassNames());
            this.parseInheritance(builder);
            this.parseMemberRules(builder, allowValueSpecification);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parseRuleTypeAndModifiers(ProguardKeepRule.Builder builder) throws ProguardRuleParserException {
            block5: {
                block7: {
                    block8: {
                        block6: {
                            if (!this.acceptString("names")) break block6;
                            builder.setType(ProguardKeepRuleType.KEEP);
                            builder.getModifiersBuilder().allowsShrinking = true;
                            break block5;
                        }
                        if (!this.acceptString("class")) break block7;
                        if (!this.acceptString("members")) break block8;
                        builder.setType(ProguardKeepRuleType.KEEP_CLASS_MEMBERS);
                        break block5;
                    }
                    if (this.acceptString("eswithmembers")) {
                        builder.setType(ProguardKeepRuleType.KEEP_CLASSES_WITH_MEMBERS);
                        break block5;
                    } else if (this.acceptString("membernames")) {
                        builder.setType(ProguardKeepRuleType.KEEP_CLASS_MEMBERS);
                        builder.getModifiersBuilder().allowsShrinking = true;
                        break block5;
                    } else {
                        if (!this.acceptString("eswithmembernames")) {
                            this.unacceptString("-keepclass");
                            throw this.parseError("Unknown option");
                        }
                        builder.setType(ProguardKeepRuleType.KEEP_CLASSES_WITH_MEMBERS);
                        builder.getModifiersBuilder().allowsShrinking = true;
                    }
                    break block5;
                }
                builder.setType(ProguardKeepRuleType.KEEP);
            }
            this.parseRuleModifiers(builder);
        }

        private void parseRuleModifiers(ProguardKeepRule.Builder builder) {
            while (this.acceptChar(',')) {
                if (this.acceptString("allow")) {
                    if (this.acceptString("shrinking")) {
                        builder.getModifiersBuilder().allowsShrinking = true;
                        continue;
                    }
                    if (this.acceptString("optimization")) {
                        builder.getModifiersBuilder().allowsOptimization = true;
                        continue;
                    }
                    if (!this.acceptString("obfuscation")) continue;
                    builder.getModifiersBuilder().allowsObfuscation = true;
                    continue;
                }
                if (!this.acceptString("includedescriptorclasses")) continue;
                builder.getModifiersBuilder().includeDescriptorClasses = true;
            }
        }

        private ProguardTypeMatcher parseAnnotation() throws ProguardRuleParserException {
            this.skipWhitespace();
            int startPosition = this.position;
            if (this.acceptChar('@')) {
                String className = this.parseClassName();
                if (className.equals("interface")) {
                    this.position = startPosition;
                    return null;
                }
                return ProguardTypeMatcher.create(className, ProguardTypeMatcher.ClassOrType.CLASS, ProguardConfigurationParser.this.dexItemFactory);
            }
            return null;
        }

        private boolean parseNegation() {
            this.skipWhitespace();
            return this.acceptChar('!');
        }

        private void parseClassFlagsAndAnnotations(ProguardClassSpecification.Builder builder) throws ProguardRuleParserException {
            while (true) {
                this.skipWhitespace();
                ProguardTypeMatcher annotation = this.parseAnnotation();
                if (annotation != null) {
                    assert (builder.getClassAnnotation() == null);
                    builder.setClassAnnotation(annotation);
                    continue;
                }
                DexAccessFlags flags = this.parseNegation() ? builder.getNegatedClassAccessFlags() : builder.getClassAccessFlags();
                this.skipWhitespace();
                if (this.acceptString("public")) {
                    flags.setPublic();
                    continue;
                }
                if (this.acceptString("final")) {
                    flags.setFinal();
                    continue;
                }
                if (!this.acceptString("abstract")) break;
                flags.setAbstract();
            }
        }

        private ProguardClassType parseClassType() throws ProguardRuleParserException {
            this.skipWhitespace();
            if (this.acceptString("interface")) {
                return ProguardClassType.INTERFACE;
            }
            if (this.acceptString("@interface")) {
                return ProguardClassType.ANNOTATION_INTERFACE;
            }
            if (this.acceptString("class")) {
                return ProguardClassType.CLASS;
            }
            if (this.acceptString("enum")) {
                return ProguardClassType.ENUM;
            }
            throw this.parseError("Expected interface|class|enum");
        }

        private void parseInheritance(ProguardClassSpecification.Builder classSpecificationBuilder) throws ProguardRuleParserException {
            this.skipWhitespace();
            if (this.acceptString("implements")) {
                classSpecificationBuilder.setInheritanceIsExtends(false);
            } else if (this.acceptString("extends")) {
                classSpecificationBuilder.setInheritanceIsExtends(true);
            } else {
                return;
            }
            classSpecificationBuilder.setInheritanceAnnotation(this.parseAnnotation());
            classSpecificationBuilder.setInheritanceClassName(ProguardTypeMatcher.create(this.parseClassName(), ProguardTypeMatcher.ClassOrType.CLASS, ProguardConfigurationParser.this.dexItemFactory));
        }

        private void parseMemberRules(ProguardClassSpecification.Builder classSpecificationBuilder, boolean allowValueSpecification) throws ProguardRuleParserException {
            this.skipWhitespace();
            if (!this.eof() && this.acceptChar('{')) {
                ProguardMemberRule rule = null;
                while ((rule = this.parseMemberRule(allowValueSpecification)) != null) {
                    classSpecificationBuilder.getMemberRules().add(rule);
                }
                this.skipWhitespace();
                this.expectChar('}');
            } else {
                ProguardMemberRule.Builder defaultRuleBuilder = ProguardMemberRule.builder();
                defaultRuleBuilder.setName("<init>");
                defaultRuleBuilder.setRuleType(ProguardMemberType.INIT);
                defaultRuleBuilder.setArguments(Collections.emptyList());
                classSpecificationBuilder.getMemberRules().add(defaultRuleBuilder.build());
            }
        }

        private ProguardMemberRule parseMemberRule(boolean allowValueSpecification) throws ProguardRuleParserException {
            ProguardMemberRule.Builder ruleBuilder = ProguardMemberRule.builder();
            this.skipWhitespace();
            ruleBuilder.setAnnotation(this.parseAnnotation());
            this.parseMemberAccessFlags(ruleBuilder);
            this.parseMemberPattern(ruleBuilder, allowValueSpecification);
            return ruleBuilder.isValid() ? ruleBuilder.build() : null;
        }

        private void parseMemberAccessFlags(ProguardMemberRule.Builder ruleBuilder) {
            boolean found = true;
            while (found && !this.eof()) {
                found = false;
                DexAccessFlags flags = this.parseNegation() ? ruleBuilder.getNegatedAccessFlags() : ruleBuilder.getAccessFlags();
                this.skipWhitespace();
                switch (this.peekChar()) {
                    case 'a': {
                        found = this.acceptString("abstract");
                        if (!found) break;
                        flags.setAbstract();
                        break;
                    }
                    case 'f': {
                        found = this.acceptString("final");
                        if (!found) break;
                        flags.setFinal();
                        break;
                    }
                    case 'n': {
                        found = this.acceptString("native");
                        if (!found) break;
                        flags.setNative();
                        break;
                    }
                    case 'p': {
                        found = this.acceptString("public");
                        if (found) {
                            flags.setPublic();
                            break;
                        }
                        found = this.acceptString("private");
                        if (found) {
                            flags.setPrivate();
                            break;
                        }
                        found = this.acceptString("protected");
                        if (!found) break;
                        flags.setProtected();
                        break;
                    }
                    case 's': {
                        found = this.acceptString("synchronized");
                        if (found) {
                            flags.setSynchronized();
                            break;
                        }
                        found = this.acceptString("static");
                        if (found) {
                            flags.setStatic();
                            break;
                        }
                        found = this.acceptString("strictfp");
                        if (!found) break;
                        flags.setStrict();
                        break;
                    }
                    case 't': {
                        found = this.acceptString("transient");
                        if (!found) break;
                        flags.setTransient();
                        break;
                    }
                    case 'v': {
                        found = this.acceptString("volatile");
                        if (!found) break;
                        flags.setVolatile();
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void parseMemberPattern(ProguardMemberRule.Builder ruleBuilder, boolean allowValueSpecification) throws ProguardRuleParserException {
            this.skipWhitespace();
            if (this.acceptString("<methods>")) {
                ruleBuilder.setRuleType(ProguardMemberType.ALL_METHODS);
            } else if (this.acceptString("<fields>")) {
                ruleBuilder.setRuleType(ProguardMemberType.ALL_FIELDS);
            } else if (this.acceptString("<init>")) {
                ruleBuilder.setRuleType(ProguardMemberType.INIT);
                ruleBuilder.setName("<init>");
                ruleBuilder.setArguments(this.parseArgumentList());
            } else {
                String first = this.acceptClassName();
                if (first != null) {
                    this.skipWhitespace();
                    if (first.equals("*") && this.hasNextChar(';')) {
                        ruleBuilder.setRuleType(ProguardMemberType.ALL);
                    } else if (this.hasNextChar('(')) {
                        ruleBuilder.setRuleType(ProguardMemberType.CONSTRUCTOR);
                        ruleBuilder.setName(first);
                        ruleBuilder.setArguments(this.parseArgumentList());
                    } else {
                        String second = this.acceptClassName();
                        if (second == null) throw this.parseError("Expected field or method name");
                        this.skipWhitespace();
                        if (this.hasNextChar('(')) {
                            ruleBuilder.setRuleType(ProguardMemberType.METHOD);
                            ruleBuilder.setName(second);
                            ruleBuilder.setTypeMatcher(ProguardTypeMatcher.create(first, ProguardTypeMatcher.ClassOrType.TYPE, ProguardConfigurationParser.this.dexItemFactory));
                            ruleBuilder.setArguments(this.parseArgumentList());
                        } else {
                            ruleBuilder.setRuleType(ProguardMemberType.FIELD);
                            ruleBuilder.setName(second);
                            ruleBuilder.setTypeMatcher(ProguardTypeMatcher.create(first, ProguardTypeMatcher.ClassOrType.TYPE, ProguardConfigurationParser.this.dexItemFactory));
                        }
                        this.skipWhitespace();
                        if (this.acceptString("return")) {
                            this.skipWhitespace();
                            if (this.acceptString("true")) {
                                ruleBuilder.setReturnValue(new ProguardMemberRuleReturnValue(true));
                            } else if (this.acceptString("false")) {
                                ruleBuilder.setReturnValue(new ProguardMemberRuleReturnValue(false));
                            } else {
                                String qualifiedFieldName = this.acceptFieldName();
                                if (qualifiedFieldName != null) {
                                    if (!(ruleBuilder.getTypeMatcher() instanceof ProguardTypeMatcher.MatchSpecificType)) throw this.parseError("Expected specific type");
                                    int lastDotIndex = qualifiedFieldName.lastIndexOf(".");
                                    DexType fieldType = ((ProguardTypeMatcher.MatchSpecificType)ruleBuilder.getTypeMatcher()).type;
                                    DexType fieldClass = ProguardConfigurationParser.this.dexItemFactory.createType(DescriptorUtils.javaTypeToDescriptor(qualifiedFieldName.substring(0, lastDotIndex)));
                                    DexString fieldName = ProguardConfigurationParser.this.dexItemFactory.createString(qualifiedFieldName.substring(lastDotIndex + 1));
                                    DexField field = ProguardConfigurationParser.this.dexItemFactory.createField(fieldClass, fieldType, fieldName);
                                    ruleBuilder.setReturnValue(new ProguardMemberRuleReturnValue(field));
                                } else {
                                    Integer min;
                                    Integer max = min = this.acceptInteger();
                                    if (min == null) {
                                        throw this.parseError("Expected integer value");
                                    }
                                    this.skipWhitespace();
                                    if (this.acceptString("..") && (max = this.acceptInteger()) == null) {
                                        throw this.parseError("Expected integer value");
                                    }
                                    if (!allowValueSpecification) {
                                        throw this.parseError("Unexpected value specification");
                                    }
                                    ruleBuilder.setReturnValue(new ProguardMemberRuleReturnValue(new LongInterval(min, max)));
                                }
                            }
                        }
                    }
                }
            }
            if (!ruleBuilder.isValid()) return;
            this.skipWhitespace();
            this.expectChar(';');
        }

        private List<ProguardTypeMatcher> parseArgumentList() throws ProguardRuleParserException {
            ArrayList<ProguardTypeMatcher> arguments = new ArrayList<ProguardTypeMatcher>();
            this.skipWhitespace();
            this.expectChar('(');
            this.skipWhitespace();
            if (this.acceptChar(')')) {
                return arguments;
            }
            if (this.acceptString("...")) {
                arguments.add(ProguardTypeMatcher.create("...", ProguardTypeMatcher.ClassOrType.TYPE, ProguardConfigurationParser.this.dexItemFactory));
            } else {
                String name = this.parseClassName();
                while (name != null) {
                    arguments.add(ProguardTypeMatcher.create(name, ProguardTypeMatcher.ClassOrType.TYPE, ProguardConfigurationParser.this.dexItemFactory));
                    this.skipWhitespace();
                    name = this.acceptChar(',') ? this.parseClassName() : null;
                }
            }
            this.skipWhitespace();
            this.expectChar(')');
            return arguments;
        }

        private Path parseFileName() throws ProguardRuleParserException {
            char current;
            this.skipWhitespace();
            int start = this.position;
            int end = this.position;
            while (!this.eof(end) && (current = this.contents.charAt(end)) != File.pathSeparatorChar && !Character.isWhitespace(current)) {
                ++end;
            }
            if (start == end) {
                throw this.parseError("File name expected");
            }
            this.position = end;
            return this.baseDirectory.resolve(this.contents.substring(start, end));
        }

        private List<Path> parseClassPath() throws ProguardRuleParserException {
            ArrayList<Path> classPath = new ArrayList<Path>();
            this.skipWhitespace();
            Path file = this.parseFileName();
            classPath.add(file);
            while (this.acceptChar(File.pathSeparatorChar)) {
                file = this.parseFileName();
                classPath.add(file);
            }
            return classPath;
        }

        private ProguardAssumeNoSideEffectRule parseAssumeNoSideEffectsRule() throws ProguardRuleParserException {
            ProguardAssumeNoSideEffectRule.Builder builder = ProguardAssumeNoSideEffectRule.builder();
            this.parseClassSpec(builder, true);
            return builder.build();
        }

        private ProguardAssumeValuesRule parseAssumeValuesRule() throws ProguardRuleParserException {
            ProguardAssumeValuesRule.Builder builder = ProguardAssumeValuesRule.builder();
            this.parseClassSpec(builder, true);
            return builder.build();
        }

        private void skipWhitespace() {
            while (!this.eof() && Character.isWhitespace(this.contents.charAt(this.position))) {
                ++this.position;
            }
            this.skipComment();
        }

        private void skipComment() {
            if (this.eof()) {
                return;
            }
            if (this.peekChar() == '#') {
                while (!this.eof() && this.readChar() != '\n') {
                }
                this.skipWhitespace();
            }
        }

        private boolean eof() {
            return this.position == this.contents.length();
        }

        private boolean eof(int position) {
            return position == this.contents.length();
        }

        private boolean hasNextChar(char c) {
            if (this.eof()) {
                return false;
            }
            return this.peekChar() == c;
        }

        private boolean isOptionalArgumentGiven() {
            return !this.eof() && !this.hasNextChar('-');
        }

        private boolean acceptChar(char c) {
            if (this.hasNextChar(c)) {
                ++this.position;
                return true;
            }
            return false;
        }

        private char peekChar() {
            return this.contents.charAt(this.position);
        }

        private char readChar() {
            return this.contents.charAt(this.position++);
        }

        private int remainingChars() {
            return this.contents.length() - this.position;
        }

        private void expectChar(char c) throws ProguardRuleParserException {
            if (this.eof() || this.readChar() != c) {
                throw this.parseError("Expected char '" + c + "'");
            }
        }

        private void expectString(String expected) throws ProguardRuleParserException {
            if (this.remainingChars() < expected.length()) {
                throw this.parseError("Expected string '" + expected + "'");
            }
            for (int i = 0; i < expected.length(); ++i) {
                if (expected.charAt(i) == this.readChar()) continue;
                throw this.parseError("Expected string '" + expected + "'");
            }
        }

        private boolean acceptString(String expected) {
            if (this.remainingChars() < expected.length()) {
                return false;
            }
            for (int i = 0; i < expected.length(); ++i) {
                if (expected.charAt(i) == this.contents.charAt(this.position + i)) continue;
                return false;
            }
            this.position += expected.length();
            return true;
        }

        private Integer acceptInteger() {
            char current;
            this.skipWhitespace();
            int start = this.position;
            int end = this.position;
            while (!this.eof(end) && Character.isDigit(current = this.contents.charAt(end))) {
                ++end;
            }
            if (start == end) {
                return null;
            }
            this.position = end;
            return Integer.parseInt(this.contents.substring(start, end));
        }

        private String acceptClassName() {
            char current;
            this.skipWhitespace();
            int start = this.position;
            int end = this.position;
            while (!this.eof(end) && (Character.isJavaIdentifierPart(current = this.contents.charAt(end)) || current == '.' || current == '*' || current == '?' || current == '%' || current == '[' || current == ']')) {
                ++end;
            }
            if (start == end) {
                return null;
            }
            this.position = end;
            return this.contents.substring(start, end);
        }

        private String acceptFieldName() {
            this.skipWhitespace();
            int start = this.position;
            int end = this.position;
            while (!this.eof(end)) {
                char current = this.contents.charAt(end);
                if ((start != end || !Character.isJavaIdentifierStart(current)) && (start >= end || !Character.isJavaIdentifierPart(current) && current != '.')) break;
                ++end;
            }
            if (start == end) {
                return null;
            }
            this.position = end;
            return this.contents.substring(start, end);
        }

        private String acceptPatternList() {
            char current;
            this.skipWhitespace();
            int start = this.position;
            int end = this.position;
            while (!this.eof(end) && (Character.isJavaIdentifierPart(current = this.contents.charAt(end)) || current == '!' || current == '*' || current == ',')) {
                ++end;
            }
            if (start == end) {
                return null;
            }
            this.position = end;
            return this.contents.substring(start, end);
        }

        private void unacceptString(String expected) {
            assert (this.position >= expected.length());
            this.position -= expected.length();
            for (int i = 0; i < expected.length(); ++i) {
                assert (expected.charAt(i) == this.contents.charAt(this.position + i));
            }
        }

        private void checkNotNegatedPattern() throws ProguardRuleParserException {
            this.skipWhitespace();
            if (this.acceptChar('!')) {
                throw this.parseError("Negated filters are not supported");
            }
        }

        private List<ProguardTypeMatcher> parseClassNames() throws ProguardRuleParserException {
            ArrayList<ProguardTypeMatcher> classNames = new ArrayList<ProguardTypeMatcher>();
            this.checkNotNegatedPattern();
            classNames.add(ProguardTypeMatcher.create(this.parseClassName(), ProguardTypeMatcher.ClassOrType.CLASS, ProguardConfigurationParser.this.dexItemFactory));
            this.skipWhitespace();
            while (this.acceptChar(',')) {
                this.checkNotNegatedPattern();
                classNames.add(ProguardTypeMatcher.create(this.parseClassName(), ProguardTypeMatcher.ClassOrType.CLASS, ProguardConfigurationParser.this.dexItemFactory));
                this.skipWhitespace();
            }
            return classNames;
        }

        private String parsePackageNameOrEmptyString() {
            String name = this.acceptClassName();
            return name == null ? "" : name;
        }

        private String parseClassName() throws ProguardRuleParserException {
            String name = this.acceptClassName();
            if (name == null) {
                throw this.parseError("Class name expected");
            }
            return name;
        }

        private String snippetForPosition() {
            String[] lines = this.contents.split("\n", -1);
            int remaining = this.position;
            for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
                String line = lines[lineNumber];
                if (remaining <= line.length() || lineNumber == lines.length - 1) {
                    String arrow = CharBuffer.allocate(remaining).toString().replace('\u0000', ' ') + '^';
                    return this.path.toString() + ":" + (lineNumber + 1) + ":" + remaining + "\n" + line + '\n' + arrow;
                }
                remaining -= line.length() + 1;
            }
            return this.path.toString();
        }

        private ProguardRuleParserException parseError(String message) {
            return new ProguardRuleParserException(message, this.snippetForPosition());
        }

        private ProguardRuleParserException parseError(String message, Throwable cause) {
            return new ProguardRuleParserException(message, this.snippetForPosition(), cause);
        }
    }
}

