/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleModifiers;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.ThreadUtils;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class RootSetBuilder {
    private DexApplication application;
    private final AppInfo appInfo;
    private final List<ProguardConfigurationRule> rules;
    private final Map<DexItem, ProguardKeepRule> noShrinking = new IdentityHashMap<DexItem, ProguardKeepRule>();
    private final Set<DexItem> noOptimization = Sets.newIdentityHashSet();
    private final Set<DexItem> noObfuscation = Sets.newIdentityHashSet();
    private final Set<DexItem> reasonAsked = Sets.newIdentityHashSet();
    private final Set<DexItem> keepPackageName = Sets.newIdentityHashSet();
    private final Set<ProguardConfigurationRule> rulesThatUseExtendsOrImplementsWrong = Sets.newIdentityHashSet();
    private final Set<DexItem> checkDiscarded = Sets.newIdentityHashSet();
    private final Map<DexItem, Map<DexItem, ProguardKeepRule>> dependentNoShrinking = new IdentityHashMap<DexItem, Map<DexItem, ProguardKeepRule>>();
    private final Map<DexItem, ProguardMemberRule> noSideEffects = new IdentityHashMap<DexItem, ProguardMemberRule>();
    private final Map<DexItem, ProguardMemberRule> assumedValues = new IdentityHashMap<DexItem, ProguardMemberRule>();
    private final IdentityHashMap<DexString, String> stringCache = new IdentityHashMap();
    private final IdentityHashMap<DexType, String> typeCache = new IdentityHashMap();

    public RootSetBuilder(DexApplication application, AppInfo appInfo, List<ProguardConfigurationRule> rules) {
        this.application = application;
        this.appInfo = appInfo;
        this.rules = rules;
    }

    private boolean anySuperTypeMatches(DexType type, ProguardTypeMatcher name, ProguardTypeMatcher annotation) {
        while (type != null) {
            DexClass clazz = this.application.definitionFor(type);
            if (clazz == null) {
                return false;
            }
            if (name.matches(clazz.type) && RootSetBuilder.containsAnnotation(annotation, clazz.annotations)) {
                return true;
            }
            type = clazz.superType;
        }
        return false;
    }

    private boolean anyImplementedInterfaceMatches(DexClass clazz, ProguardTypeMatcher className, ProguardTypeMatcher annotation) {
        if (clazz == null) {
            return false;
        }
        for (DexType iface : clazz.interfaces.values) {
            DexClass ifaceClass = this.application.definitionFor(iface);
            if (ifaceClass == null) {
                return false;
            }
            if ((!className.matches(iface) || !RootSetBuilder.containsAnnotation(annotation, ifaceClass.annotations)) && !this.anyImplementedInterfaceMatches(ifaceClass, className, annotation)) continue;
            return true;
        }
        if (clazz.superType == null) {
            return false;
        }
        DexClass superClass = this.application.definitionFor(clazz.superType);
        if (superClass == null) {
            return false;
        }
        return this.anyImplementedInterfaceMatches(superClass, className, annotation);
    }

    private DexType[] specificDexTypes(ProguardConfigurationRule rule) {
        for (ProguardTypeMatcher matcher : rule.getClassNames()) {
            if (matcher instanceof ProguardTypeMatcher.MatchSpecificType) continue;
            return null;
        }
        int length = rule.getClassNames().size();
        DexType[] result = new DexType[length];
        for (int i = 0; i < length; ++i) {
            result[i] = ((ProguardTypeMatcher.MatchSpecificType)rule.getClassNames().get((int)i)).type;
        }
        return result;
    }

    private void process(DexClass clazz, ProguardConfigurationRule rule) {
        if (!clazz.accessFlags.containsAllOf(rule.getClassAccessFlags())) {
            return;
        }
        if (!clazz.accessFlags.containsNoneOf(rule.getNegatedClassAccessFlags())) {
            return;
        }
        if (!RootSetBuilder.containsAnnotation(rule.getClassAnnotation(), clazz.annotations)) {
            return;
        }
        if (rule.hasInheritanceClassName()) {
            boolean extendsExpected = this.anySuperTypeMatches(clazz.superType, rule.getInheritanceClassName(), rule.getInheritanceAnnotation());
            boolean implementsExpected = false;
            if (!extendsExpected) {
                implementsExpected = this.anyImplementedInterfaceMatches(clazz, rule.getInheritanceClassName(), rule.getInheritanceAnnotation());
            }
            if (!extendsExpected && !implementsExpected) {
                return;
            }
            if (extendsExpected && !rule.getInheritanceIsExtends()) {
                if (this.rulesThatUseExtendsOrImplementsWrong.add(rule)) {
                    System.err.println("The rule `" + rule + "` uses implements but actually matches extends.");
                }
            } else if (implementsExpected && rule.getInheritanceIsExtends() && this.rulesThatUseExtendsOrImplementsWrong.add(rule)) {
                System.err.println("The rule `" + rule + "` uses extends but actually matches implements.");
            }
        }
        for (ProguardTypeMatcher className : rule.getClassNames()) {
            if (!className.matches(clazz.type)) continue;
            Set<ProguardMemberRule> memberKeepRules = rule.getMemberRules();
            if (rule instanceof ProguardKeepRule) {
                switch (((ProguardKeepRule)rule).getType()) {
                    case KEEP_CLASS_MEMBERS: {
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, clazz.type);
                        this.markMatchingFields(clazz, memberKeepRules, rule, clazz.type);
                        break;
                    }
                    case KEEP_CLASSES_WITH_MEMBERS: {
                        if (!this.allRulesSatisfied(memberKeepRules, clazz)) break;
                    }
                    case KEEP: {
                        this.markClass(clazz, rule);
                        this.markClass(clazz, rule);
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null);
                        this.markMatchingFields(clazz, memberKeepRules, rule, null);
                    }
                }
                continue;
            }
            if (rule instanceof ProguardAssumeNoSideEffectRule) {
                this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null);
                this.markMatchingFields(clazz, memberKeepRules, rule, null);
                continue;
            }
            assert (rule instanceof ProguardAssumeValuesRule);
            this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null);
            this.markMatchingFields(clazz, memberKeepRules, rule, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootSet run(ExecutorService executorService) throws ExecutionException {
        block6: {
            this.application.timing.begin("Build root set...");
            try {
                ArrayList futures = new ArrayList();
                if (this.rules == null) break block6;
                for (ProguardConfigurationRule rule : this.rules) {
                    DexType[] specifics = this.specificDexTypes(rule);
                    if (specifics != null) {
                        for (DexType type : specifics) {
                            DexClass clazz = this.application.definitionFor(type);
                            if (clazz == null) continue;
                            this.process(clazz, rule);
                        }
                        continue;
                    }
                    futures.add(executorService.submit(() -> {
                        for (DexProgramClass dexProgramClass : this.application.classes()) {
                            this.process(dexProgramClass, rule);
                        }
                        if (rule.applyToLibraryClasses()) {
                            for (DexLibraryClass dexLibraryClass : this.application.libraryClasses()) {
                                this.process(dexLibraryClass, rule);
                            }
                        }
                    }));
                }
                ThreadUtils.awaitFutures(futures);
            }
            finally {
                this.application.timing.end();
            }
        }
        return new RootSet(this.noShrinking, this.noOptimization, this.noObfuscation, this.reasonAsked, this.keepPackageName, this.checkDiscarded, this.noSideEffects, this.assumedValues, this.dependentNoShrinking);
    }

    private void markMatchingVisibleMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, DexType onlyIfClassKept) {
        HashSet methodsMarked = new HashSet();
        while (clazz != null) {
            clazz.forEachMethod(method -> this.markMethod((DexEncodedMethod)method, memberKeepRules, rule, methodsMarked, onlyIfClassKept));
            clazz = this.application.definitionFor(clazz.superType);
        }
    }

    private void markMatchingFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, DexType onlyIfClassKept) {
        clazz.forEachField(field -> this.markField((DexEncodedField)field, memberKeepRules, rule, onlyIfClassKept));
    }

    public static void writeSeeds(Iterable<DexItem> seeds, PrintStream out) {
        for (DexItem seed : seeds) {
            if (seed instanceof DexClass) {
                out.println(((DexClass)seed).type.toSourceString());
                continue;
            }
            if (seed instanceof DexEncodedField) {
                DexField field = ((DexEncodedField)seed).field;
                out.println(field.clazz.toSourceString() + ": " + field.type.toSourceString() + " " + field.name.toSourceString());
                continue;
            }
            if (!(seed instanceof DexEncodedMethod)) continue;
            DexEncodedMethod encodedMethod = (DexEncodedMethod)seed;
            DexMethod method = encodedMethod.method;
            out.print(method.holder.toSourceString() + ": ");
            if (encodedMethod.accessFlags.isConstructor()) {
                if (encodedMethod.accessFlags.isStatic()) {
                    out.print("<clinit>(");
                } else {
                    String holderName = method.holder.toSourceString();
                    String constrName = holderName.substring(holderName.lastIndexOf(46) + 1);
                    out.print(constrName + "(");
                }
            } else {
                out.print(method.proto.returnType.toSourceString() + " " + method.name.toSourceString() + "(");
            }
            boolean first = true;
            for (DexType param : method.proto.parameters.values) {
                if (!first) {
                    out.print(",");
                }
                first = false;
                out.print(param.toSourceString());
            }
            out.println(")");
        }
        out.close();
    }

    private boolean allRulesSatisfied(Collection<ProguardMemberRule> memberKeepRules, DexClass clazz) {
        for (ProguardMemberRule rule : memberKeepRules) {
            if (this.ruleSatisfied(rule, clazz)) continue;
            return false;
        }
        return true;
    }

    private boolean ruleSatisfied(ProguardMemberRule rule, DexClass clazz) {
        return this.ruleSatisfiedByMethods(rule, clazz.directMethods()) || this.ruleSatisfiedByMethods(rule, clazz.virtualMethods()) || this.ruleSatisfiedByFields(rule, clazz.staticFields()) || this.ruleSatisfiedByFields(rule, clazz.instanceFields());
    }

    private boolean ruleSatisfiedByMethods(ProguardMemberRule rule, DexEncodedMethod[] methods) {
        if (rule.getRuleType().includesMethods()) {
            for (DexEncodedMethod method : methods) {
                if (!rule.matches(method, this)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ruleSatisfiedByFields(ProguardMemberRule rule, DexEncodedField[] fields) {
        if (rule.getRuleType().includesFields()) {
            for (DexEncodedField field : fields) {
                if (!rule.matches(field, this)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsAnnotation(ProguardTypeMatcher classAnnotation, DexAnnotationSet annotations) {
        if (classAnnotation == null) {
            return true;
        }
        if (annotations.isEmpty()) {
            return false;
        }
        for (DexAnnotation annotation : annotations.annotations) {
            if (!classAnnotation.matches(annotation.annotation.type)) continue;
            return true;
        }
        return false;
    }

    public String lookupString(DexString name) {
        return this.stringCache.computeIfAbsent(name, DexString::toString);
    }

    public String lookupType(DexType type) {
        return this.typeCache.computeIfAbsent(type, DexType::toSourceString);
    }

    private void markMethod(DexEncodedMethod method, Collection<ProguardMemberRule> rules, ProguardConfigurationRule context, Set<Equivalence.Wrapper<DexMethod>> methodsMarked, DexType onlyIfClassKept) {
        if (methodsMarked.contains(MethodSignatureEquivalence.get().wrap(method.method))) {
            return;
        }
        for (ProguardMemberRule rule : rules) {
            if (!rule.matches(method, this)) continue;
            this.addItemToSets(method, context, rule, onlyIfClassKept);
        }
    }

    private void markField(DexEncodedField field, Collection<ProguardMemberRule> rules, ProguardConfigurationRule context, DexType onlyIfClassKept) {
        for (ProguardMemberRule rule : rules) {
            if (!rule.matches(field, this)) continue;
            this.addItemToSets(field, context, rule, onlyIfClassKept);
        }
    }

    private void markClass(DexClass clazz, ProguardConfigurationRule rule) {
        this.addItemToSets(clazz, rule, null, null);
    }

    private void includeDescriptor(DexItem item, DexType type, ProguardKeepRule context) {
        if (type.isArrayType()) {
            type = type.toBaseType(this.application.dexItemFactory);
        }
        if (type.isPrimitiveType()) {
            return;
        }
        DexClass definition = this.appInfo.definitionFor(type);
        if (definition == null || definition.isLibraryClass()) {
            return;
        }
        this.dependentNoShrinking.computeIfAbsent(item, x -> new IdentityHashMap()).put(definition, context);
        this.noObfuscation.add(definition);
    }

    private void includeDescriptorClasses(DexItem item, ProguardKeepRule context) {
        if (item instanceof DexEncodedMethod) {
            DexMethod method = ((DexEncodedMethod)item).method;
            this.includeDescriptor(item, method.proto.returnType, context);
            for (DexType value : method.proto.parameters.values) {
                this.includeDescriptor(item, value, context);
            }
        } else if (item instanceof DexEncodedField) {
            DexField field = ((DexEncodedField)item).field;
            this.includeDescriptor(item, field.type, context);
        } else assert (item instanceof DexClass);
    }

    private synchronized void addItemToSets(DexItem item, ProguardConfigurationRule context, ProguardMemberRule rule, DexType onlyIfClassKept) {
        if (context instanceof ProguardKeepRule) {
            ProguardKeepRule keepRule = (ProguardKeepRule)context;
            ProguardKeepRuleModifiers modifiers = keepRule.getModifiers();
            if (!modifiers.allowsShrinking) {
                if (onlyIfClassKept != null) {
                    this.dependentNoShrinking.computeIfAbsent(onlyIfClassKept, x -> new IdentityHashMap()).put(item, keepRule);
                } else {
                    this.noShrinking.put(item, keepRule);
                }
            }
            if (!modifiers.allowsOptimization) {
                this.noOptimization.add(item);
            }
            if (!modifiers.allowsObfuscation) {
                this.noObfuscation.add(item);
            }
            if (modifiers.whyAreYouKeeping) {
                assert (onlyIfClassKept == null);
                this.reasonAsked.add(item);
            }
            if (modifiers.keepPackageNames) {
                assert (onlyIfClassKept == null);
                this.keepPackageName.add(item);
            }
            if (modifiers.includeDescriptorClasses) {
                this.includeDescriptorClasses(item, keepRule);
            }
            if (modifiers.checkDiscarded) {
                this.checkDiscarded.add(item);
            }
        } else if (context instanceof ProguardAssumeNoSideEffectRule) {
            this.noSideEffects.put(item, rule);
        } else if (context instanceof ProguardAssumeValuesRule) {
            this.assumedValues.put(item, rule);
        }
    }

    public static class RootSet {
        public final Map<DexItem, ProguardKeepRule> noShrinking;
        public final Set<DexItem> noOptimization;
        public final Set<DexItem> noObfuscation;
        public final Set<DexItem> reasonAsked;
        public final Set<DexItem> keepPackageName;
        public final Set<DexItem> checkDiscarded;
        public final Map<DexItem, ProguardMemberRule> noSideEffects;
        public final Map<DexItem, ProguardMemberRule> assumedValues;
        private final Map<DexItem, Map<DexItem, ProguardKeepRule>> dependentNoShrinking;

        private boolean legalNoObfuscationItem(DexItem item) {
            if (item instanceof DexProgramClass || item instanceof DexLibraryClass || item instanceof DexEncodedMethod || !(item instanceof DexEncodedField)) {
                // empty if block
            }
            assert (item instanceof DexProgramClass || item instanceof DexLibraryClass || item instanceof DexEncodedMethod || item instanceof DexEncodedField);
            return true;
        }

        private boolean legalNoObfuscationItems(Set<DexItem> items) {
            items.forEach(this::legalNoObfuscationItem);
            return true;
        }

        private boolean legalDependentNoShrinkingItem(DexItem item) {
            if (item instanceof DexType || item instanceof DexEncodedMethod || !(item instanceof DexEncodedField)) {
                // empty if block
            }
            assert (item instanceof DexType || item instanceof DexEncodedMethod || item instanceof DexEncodedField);
            return true;
        }

        private boolean legalDependentNoShrinkingItems(Map<DexItem, Map<DexItem, ProguardKeepRule>> dependentNoShrinking) {
            dependentNoShrinking.keySet().forEach(this::legalDependentNoShrinkingItem);
            return true;
        }

        private RootSet(Map<DexItem, ProguardKeepRule> noShrinking, Set<DexItem> noOptimization, Set<DexItem> noObfuscation, Set<DexItem> reasonAsked, Set<DexItem> keepPackageName, Set<DexItem> checkDiscarded, Map<DexItem, ProguardMemberRule> noSideEffects, Map<DexItem, ProguardMemberRule> assumedValues, Map<DexItem, Map<DexItem, ProguardKeepRule>> dependentNoShrinking) {
            this.noShrinking = Collections.unmodifiableMap(noShrinking);
            this.noOptimization = Collections.unmodifiableSet(noOptimization);
            this.noObfuscation = Collections.unmodifiableSet(noObfuscation);
            this.reasonAsked = Collections.unmodifiableSet(reasonAsked);
            this.keepPackageName = Collections.unmodifiableSet(keepPackageName);
            this.checkDiscarded = Collections.unmodifiableSet(checkDiscarded);
            this.noSideEffects = Collections.unmodifiableMap(noSideEffects);
            this.assumedValues = Collections.unmodifiableMap(assumedValues);
            this.dependentNoShrinking = dependentNoShrinking;
            assert (this.legalNoObfuscationItems(noObfuscation));
            assert (this.legalDependentNoShrinkingItems(dependentNoShrinking));
        }

        Map<DexItem, ProguardKeepRule> getDependentItems(DexItem item) {
            assert (item instanceof DexType || item instanceof DexEncodedMethod || item instanceof DexEncodedField);
            return Collections.unmodifiableMap(this.dependentNoShrinking.getOrDefault(item, Collections.emptyMap()));
        }
    }
}

