/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.conversion.CallGraph;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.LensCodeRewriter;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.Outliner;
import com.android.tools.r8.utils.InternalOptions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Inliner {
    private static final int INLINING_INSTRUCTION_LIMIT = 5;
    protected final AppInfoWithSubtyping appInfo;
    private final GraphLense graphLense;
    private final InternalOptions options;
    private boolean applyDoubleInlining = false;
    private final Set<DexEncodedMethod> doubleInlineCallers = Sets.newIdentityHashSet();
    private final Set<DexEncodedMethod> doubleInlineSelectedTargets = Sets.newIdentityHashSet();
    private final Map<DexEncodedMethod, DexEncodedMethod> doubleInlineeCandidates = new HashMap<DexEncodedMethod, DexEncodedMethod>();

    public Inliner(AppInfoWithSubtyping appInfo, GraphLense graphLense, InternalOptions options) {
        this.appInfo = appInfo;
        this.graphLense = graphLense;
        this.options = options;
    }

    private Constraint instructionAllowedForInlining(DexEncodedMethod method, Instruction instruction) {
        Constraint result = instruction.inliningConstraint(this.appInfo, method.method.holder);
        if (result == Constraint.NEVER && instruction.isDebugInstruction()) {
            return Constraint.ALWAYS;
        }
        return result;
    }

    public Constraint identifySimpleMethods(IRCode code, DexEncodedMethod method) {
        BasicBlock nextBlock;
        DexCode dex = method.getCode().asDexCode();
        if (dex.instructions.length > 5) {
            return Constraint.NEVER;
        }
        Constraint result = Constraint.ALWAYS;
        ListIterator<BasicBlock> iterator = code.listIterator();
        assert (iterator.hasNext());
        BasicBlock block = iterator.next();
        do {
            nextBlock = iterator.hasNext() ? iterator.next() : null;
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                Constraint state = this.instructionAllowedForInlining(method, instruction);
                if (state == Constraint.NEVER) {
                    return Constraint.NEVER;
                }
                if (state.ordinal() >= result.ordinal()) continue;
                result = state;
            }
        } while ((block = nextBlock) != null);
        return result;
    }

    boolean hasInliningAccess(DexEncodedMethod method, DexEncodedMethod target) {
        if (target.accessFlags.isPublic()) {
            return true;
        }
        DexType methodHolder = method.method.getHolder();
        DexType targetHolder = target.method.getHolder();
        if (target.accessFlags.isPrivate()) {
            return methodHolder == targetHolder;
        }
        if (target.accessFlags.isProtected() && methodHolder.isSubtypeOf(targetHolder, this.appInfo)) {
            return true;
        }
        return methodHolder.isSamePackage(targetHolder);
    }

    synchronized DexEncodedMethod doubleInlining(DexEncodedMethod method, DexEncodedMethod target) {
        if (!this.applyDoubleInlining) {
            if (this.doubleInlineeCandidates.containsKey(target)) {
                this.doubleInlineCallers.add(this.doubleInlineeCandidates.get(target));
                this.doubleInlineCallers.add(method);
                this.doubleInlineSelectedTargets.add(target);
            } else {
                this.doubleInlineeCandidates.put(target, method);
            }
            return null;
        }
        if (!this.doubleInlineSelectedTargets.contains(target)) {
            return null;
        }
        return target;
    }

    public synchronized void processDoubleInlineCallers(IRConverter converter, OptimizationFeedback feedback) {
        if (this.doubleInlineCallers.size() > 0) {
            this.applyDoubleInlining = true;
            for (DexEncodedMethod method : this.doubleInlineCallers) {
                converter.processMethod(method, feedback, Outliner::noProcessing);
                assert (method.isProcessed());
            }
        }
    }

    private int numberOfInstructions(IRCode code) {
        int numOfInstructions = 0;
        for (BasicBlock block : code.blocks) {
            numOfInstructions += block.getInstructions().size();
        }
        return numOfInstructions;
    }

    private boolean legalConstructorInline(DexEncodedMethod method, IRCode code) {
        if (method.accessFlags.isConstructor()) {
            return true;
        }
        InstructionIterator iterator = code.instructionIterator();
        Instruction instruction = (Instruction)iterator.next();
        assert (instruction.isArgument());
        Value unInitializedObject = instruction.outValue();
        while (iterator.hasNext()) {
            instruction = (Instruction)iterator.next();
            if (!instruction.inValues().contains(unInitializedObject)) continue;
            return instruction.isInvokeDirect() && this.appInfo.dexItemFactory.isConstructor(instruction.asInvokeDirect().getInvokedMethod());
        }
        assert (false) : "Execution should never reach this point";
        return false;
    }

    private Value receiverValue(DexEncodedMethod method, IRCode code) {
        if (method.accessFlags.isStatic()) {
            return null;
        }
        return code.collectArguments().get(0);
    }

    public void performInlining(DexEncodedMethod method, IRCode code, CallGraph callGraph) {
        int instruction_allowance = 1500;
        if ((instruction_allowance -= this.numberOfInstructions(code)) < 0) {
            return;
        }
        this.computeReceiverMustBeNonNull(code);
        Value receiver = this.receiverValue(method, code);
        InliningOracle oracle = new InliningOracle(this, method, receiver, callGraph);
        ArrayList<BasicBlock> blocksToRemove = new ArrayList<BasicBlock>();
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext() && instruction_allowance >= 0) {
            BasicBlock block = blockIterator.next();
            if (blocksToRemove.contains(block)) continue;
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext() && instruction_allowance >= 0) {
                IRCode inlinee;
                boolean forceInline;
                DexEncodedMethod target;
                InvokeMethod invoke;
                InlineAction result;
                Instruction current = (Instruction)iterator.next();
                if (!current.isInvokeMethod() || (result = (invoke = current.asInvokeMethod()).computeInlining(oracle)) == null || (target = this.appInfo.lookup(invoke.getType(), invoke.getInvokedMethod())) == null) continue;
                boolean bl = forceInline = result.reason == Reason.FORCE;
                if (!target.isProcessed() && !forceInline || (inlinee = result.buildIR(code.valueNumberGenerator, this.appInfo, this.graphLense, this.options)) == null || block.hasCatchHandlers() && inlinee.getNormalExitBlock() == null || callGraph.isBreaker(method, target)) continue;
                if (!target.isProcessed()) {
                    assert (forceInline);
                    this.performInlining(target, inlinee, callGraph);
                }
                if (target.accessFlags.isConstructor() && !this.legalConstructorInline(method, inlinee) || !forceInline && !result.target.isPublicInlining() && method.method.getHolder() != result.target.method.getHolder()) continue;
                DexType downcast = null;
                if (invoke.isInvokeMethodWithReceiver() && result.target.method.getHolder() != target.method.getHolder()) {
                    downcast = result.target.method.getHolder();
                }
                iterator.previous();
                if ((instruction_allowance -= this.numberOfInstructions(inlinee)) >= 0 || result.forceInline()) {
                    iterator.inlineInvoke(code, inlinee, blockIterator, blocksToRemove, downcast);
                }
                if (!method.accessFlags.isBridge()) continue;
                method.accessFlags.unsetSynthetic();
                method.accessFlags.unsetBridge();
            }
        }
        oracle.finish();
        code.removeBlocks(blocksToRemove);
        assert (code.isConsistentSSA());
    }

    private void computeReceiverMustBeNonNull(IRCode code) {
        DominatorTree dominatorTree = new DominatorTree(code);
        InstructionIterator it = code.instructionIterator();
        block0: while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            if (!instruction.isInvokeMethodWithReceiver()) continue;
            Value receiverValue = instruction.inValues().get(0);
            for (Instruction user : receiverValue.uniqueUsers()) {
                if (!user.isInvokeMethodWithReceiver() || user.inValues().get(0) != receiverValue || user.getBlock().hasCatchHandlers() || !dominatorTree.strictlyDominatedBy(instruction.getBlock(), user.getBlock())) continue;
                instruction.asInvokeMethodWithReceiver().setIsDominatedByCallWithSameReceiver();
                continue block0;
            }
        }
    }

    public static class InlineAction {
        public final DexEncodedMethod target;
        public final Invoke invoke;
        public final Reason reason;

        public InlineAction(DexEncodedMethod target, Invoke invoke, Reason reason) {
            this.target = target;
            this.invoke = invoke;
            this.reason = reason;
        }

        public boolean forceInline() {
            return this.reason != Reason.SIMPLE;
        }

        public IRCode buildIR(ValueNumberGenerator generator, AppInfoWithSubtyping appInfo, GraphLense graphLense, InternalOptions options) {
            if (this.target.isProcessed()) {
                assert (this.target.getCode().isDexCode());
                return this.target.buildIR(generator, options);
            }
            IRCode code = this.target.getCode().isJarCode() ? this.target.getCode().asJarCode().buildIR(this.target, generator, options) : this.target.getCode().asDexCode().buildIR(this.target, generator, options);
            new LensCodeRewriter(graphLense, appInfo).rewrite(code, this.target);
            return code;
        }
    }

    public static enum Reason {
        FORCE,
        SINGLE_CALLER,
        DUAL_CALLER,
        SIMPLE;

    }

    public static enum Constraint {
        NEVER,
        PRIVATE,
        PACKAGE,
        ALWAYS;

    }
}

