/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Move;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import java.util.HashSet;

class MoveEliminator {
    private final HashSet<Move> activeMoves = new HashSet();
    private final RegisterAllocator allocator;

    MoveEliminator(RegisterAllocator allocator) {
        this.allocator = allocator;
    }

    public boolean shouldBeEliminated(Instruction instruction) {
        if (instruction.isMove()) {
            int moveDstRegister;
            Move move = instruction.asMove();
            int moveSrcRegister = this.allocator.getRegisterForValue(move.src(), move.getNumber());
            if (moveSrcRegister == (moveDstRegister = this.allocator.getRegisterForValue(move.dest(), move.getNumber()))) {
                return true;
            }
            for (Move activeMove : this.activeMoves) {
                int activeMoveSrcRegister = this.allocator.getRegisterForValue(activeMove.src(), activeMove.getNumber());
                int activeMoveDstRegister = this.allocator.getRegisterForValue(activeMove.dest(), activeMove.getNumber());
                if (activeMoveSrcRegister != moveSrcRegister || activeMoveDstRegister != moveDstRegister) continue;
                return true;
            }
        }
        if (instruction.outValue() != null && instruction.outValue().needsRegister()) {
            Value defined = instruction.outValue();
            int definedRegister = this.allocator.getRegisterForValue(defined, instruction.getNumber());
            this.activeMoves.removeIf(m -> {
                int moveSrcRegister = this.allocator.getRegisterForValue(m.inValues().get(0), m.getNumber());
                int moveDstRegister = this.allocator.getRegisterForValue(m.outValue(), m.getNumber());
                for (int i = 0; i < defined.requiredRegisters(); ++i) {
                    if (definedRegister + i != moveDstRegister && definedRegister + i != moveSrcRegister) continue;
                    return true;
                }
                return false;
            });
        }
        if (instruction.isMove()) {
            this.activeMoves.add(instruction.asMove());
        }
        return false;
    }
}

