/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.DebugLocalsChange;
import com.android.tools.r8.ir.code.DebugPosition;
import com.android.tools.r8.ir.code.Instruction;
import it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMaps;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class DexDebugEventBuilder {
    private static final int NO_PC_INFO = -1;
    private static final int NO_LINE_INFO = -1;
    private final DexEncodedMethod method;
    private final DexItemFactory factory;
    private ArrayList<DebugLocalInfo> arguments;
    private Int2ReferenceMap<DebugLocalInfo> lastKnownLocals;
    private Int2ReferenceMap<DebugLocalInfo> pendingLocals = null;
    private boolean pendingLocalChanges = false;
    private int emittedPc = -1;
    private int emittedLine = -1;
    private DexString emittedFile = null;
    private Int2ReferenceMap<DebugLocalInfo> emittedLocals;
    private int lastMoveInstructionPc = -1;
    private final List<DexDebugEvent> events = new ArrayList<DexDebugEvent>();
    private int startLine = -1;

    public DexDebugEventBuilder(DexEncodedMethod method, DexItemFactory factory) {
        this.method = method;
        this.factory = factory;
    }

    public void setPosition(int pc, int line) {
        this.emitDebugPosition(pc, line, null);
    }

    public void add(int pc, Instruction instruction) {
        if (instruction.getBlock().entry() == instruction) {
            this.updateBlockEntry(instruction);
        }
        assert (this.pendingLocals != null);
        if (instruction.isDebugPosition()) {
            this.emitDebugPosition(pc, instruction.asDebugPosition());
            return;
        }
        if (instruction.isArgument()) {
            this.startArgument(instruction.asArgument());
        } else if (instruction.isDebugLocalsChange()) {
            this.updateLocals(instruction.asDebugLocalsChange());
        } else {
            if (instruction.getBlock().exit() == instruction) {
                this.pendingLocals = null;
                this.pendingLocalChanges = false;
                return;
            }
            if (instruction.isMoveException()) {
                this.lastMoveInstructionPc = pc;
            } else {
                this.emitLocalChanges(pc);
            }
        }
    }

    public DexDebugInfo build() {
        assert (this.pendingLocals == null);
        assert (!this.pendingLocalChanges);
        if (this.startLine == -1) {
            return null;
        }
        DexString[] params = new DexString[this.method.method.proto.parameters.values.length];
        if (this.arguments != null) {
            assert (params.length == this.arguments.size());
            for (int i = 0; i < this.arguments.size(); ++i) {
                DebugLocalInfo local = this.arguments.get(i);
                params[i] = local == null || local.signature != null ? null : local.name;
            }
        }
        return new DexDebugInfo(this.startLine, params, this.events.toArray(new DexDebugEvent[this.events.size()]));
    }

    private void updateBlockEntry(Instruction instruction) {
        assert (this.pendingLocals == null);
        assert (!this.pendingLocalChanges);
        Int2ReferenceMap<DebugLocalInfo> locals = instruction.getBlock().getLocalsAtEntry();
        if (locals == null) {
            this.pendingLocals = Int2ReferenceMaps.emptyMap();
        } else {
            this.pendingLocals = new Int2ReferenceOpenHashMap(locals);
            this.pendingLocalChanges = true;
        }
        if (this.emittedLocals == null) {
            this.initialize(locals);
        }
    }

    private void initialize(Int2ReferenceMap<DebugLocalInfo> locals) {
        assert (this.arguments == null);
        assert (this.emittedLocals == null);
        assert (this.lastKnownLocals == null);
        assert (this.startLine == -1);
        if (locals == null) {
            this.emittedLocals = Int2ReferenceMaps.emptyMap();
            this.lastKnownLocals = Int2ReferenceMaps.emptyMap();
            return;
        }
        this.emittedLocals = new Int2ReferenceOpenHashMap();
        for (Int2ReferenceMap.Entry entry : locals.int2ReferenceEntrySet()) {
            if (((DebugLocalInfo)entry.getValue()).signature != null) continue;
            this.emittedLocals.put(entry.getIntKey(), entry.getValue());
        }
        this.lastKnownLocals = new Int2ReferenceOpenHashMap(this.emittedLocals);
    }

    private void startArgument(Argument argument) {
        if (this.arguments == null) {
            this.arguments = new ArrayList(this.method.method.proto.parameters.values.length);
        }
        if (!argument.outValue().isThis()) {
            this.arguments.add(argument.getLocalInfo());
        }
    }

    private void updateLocals(DebugLocalsChange change) {
        this.pendingLocalChanges = true;
        for (Int2ReferenceMap.Entry end : change.getEnding().int2ReferenceEntrySet()) {
            assert (this.pendingLocals.get(end.getIntKey()) == end.getValue());
            this.pendingLocals.remove(end.getIntKey());
        }
        for (Int2ReferenceMap.Entry start : change.getStarting().int2ReferenceEntrySet()) {
            assert (!this.pendingLocals.containsKey(start.getIntKey()));
            this.pendingLocals.put(start.getIntKey(), start.getValue());
        }
    }

    private boolean localsChanged() {
        if (!this.pendingLocalChanges) {
            return false;
        }
        this.pendingLocalChanges = !DexDebugEventBuilder.localsEqual(this.emittedLocals, this.pendingLocals);
        return this.pendingLocalChanges;
    }

    private void emitDebugPosition(int pc, DebugPosition position) {
        this.emitDebugPosition(pc, position.line, position.file);
    }

    private void emitDebugPosition(int pc, int line, DexString file) {
        int emitPc = this.lastMoveInstructionPc != -1 ? this.lastMoveInstructionPc : pc;
        this.lastMoveInstructionPc = -1;
        assert (this.emittedPc != emitPc);
        if (this.startLine == -1) {
            assert (this.emittedLine == -1);
            this.startLine = line;
            this.emittedLine = line;
        }
        DexDebugEventBuilder.emitAdvancementEvents(this.emittedPc, this.emittedLine, this.emittedFile, emitPc, line, file, this.events, this.factory);
        this.emittedPc = emitPc;
        this.emittedLine = line;
        this.emittedFile = file;
        if (this.localsChanged()) {
            DexDebugEventBuilder.emitLocalChangeEvents(this.emittedLocals, this.pendingLocals, this.lastKnownLocals, this.events, this.factory);
            assert (DexDebugEventBuilder.localsEqual(this.emittedLocals, this.pendingLocals));
        }
        this.pendingLocalChanges = false;
    }

    private void emitLocalChanges(int pc) {
        if (this.localsChanged()) {
            int emitPc = this.lastMoveInstructionPc != -1 ? this.lastMoveInstructionPc : pc;
            this.lastMoveInstructionPc = -1;
            DexDebugEventBuilder.emitAdvancementEvents(this.emittedPc, this.emittedLine, this.emittedFile, emitPc, this.emittedLine, this.emittedFile, this.events, this.factory);
            this.emittedPc = emitPc;
            DexDebugEventBuilder.emitLocalChangeEvents(this.emittedLocals, this.pendingLocals, this.lastKnownLocals, this.events, this.factory);
            this.pendingLocalChanges = false;
            assert (DexDebugEventBuilder.localsEqual(this.emittedLocals, this.pendingLocals));
        }
    }

    private static void emitAdvancementEvents(int previousPc, int previousLine, DexString previousFile, int nextPc, int nextLine, DexString nextFile, List<DexDebugEvent> events, DexItemFactory factory) {
        int lineDelta;
        int pcDelta = previousPc == -1 ? nextPc : nextPc - previousPc;
        int n = lineDelta = nextLine == -1 ? 0 : nextLine - previousLine;
        assert (pcDelta >= 0);
        if (nextFile != previousFile) {
            events.add(factory.createSetFile(nextFile));
        }
        if (lineDelta < -4 || lineDelta - -4 >= 15) {
            events.add(factory.createAdvanceLine(lineDelta));
            lineDelta = 0;
        }
        if (pcDelta >= 16) {
            events.add(factory.createAdvancePC(pcDelta));
            pcDelta = 0;
        }
        int specialOpcode = 10 + (lineDelta - -4) + 15 * pcDelta;
        assert (specialOpcode >= 10);
        assert (specialOpcode <= 255);
        events.add(factory.createDefault(specialOpcode));
    }

    public static void emitLocalChangeEvents(Int2ReferenceMap<DebugLocalInfo> previousLocals, Int2ReferenceMap<DebugLocalInfo> nextLocals, Int2ReferenceMap<DebugLocalInfo> lastKnownLocals, List<DexDebugEvent> events, DexItemFactory factory) {
        DebugLocalInfo local;
        int register;
        Int2ReferenceAVLTreeMap ending = new Int2ReferenceAVLTreeMap();
        Int2ReferenceAVLTreeMap starting = new Int2ReferenceAVLTreeMap();
        for (Int2ReferenceMap.Entry entry : previousLocals.int2ReferenceEntrySet()) {
            register = entry.getIntKey();
            local = (DebugLocalInfo)entry.getValue();
            if (nextLocals.get(register) == local) continue;
            ending.put(register, (Object)local);
        }
        for (Int2ReferenceMap.Entry entry : nextLocals.int2ReferenceEntrySet()) {
            register = entry.getIntKey();
            local = (DebugLocalInfo)entry.getValue();
            if (previousLocals.get(register) == local) continue;
            starting.put(register, (Object)local);
        }
        assert (!ending.isEmpty() || !starting.isEmpty());
        for (Int2ReferenceMap.Entry end : ending.int2ReferenceEntrySet()) {
            register = end.getIntKey();
            if (starting.containsKey(register)) continue;
            previousLocals.remove(register);
            events.add(factory.createEndLocal(register));
        }
        for (Int2ReferenceMap.Entry start : starting.int2ReferenceEntrySet()) {
            register = start.getIntKey();
            local = (DebugLocalInfo)start.getValue();
            previousLocals.put(register, (Object)local);
            if (lastKnownLocals.get(register) == local) {
                events.add(factory.createRestartLocal(register));
                continue;
            }
            events.add(new DexDebugEvent.StartLocal(register, local));
            lastKnownLocals.put(register, (Object)local);
        }
    }

    private static boolean localsEqual(Int2ReferenceMap<DebugLocalInfo> locals1, Int2ReferenceMap<DebugLocalInfo> locals2) {
        if (locals1 == locals2) {
            return true;
        }
        if (locals1.size() != locals2.size()) {
            return false;
        }
        for (Int2ReferenceMap.Entry entry : locals1.int2ReferenceEntrySet()) {
            if (locals2.get(entry.getIntKey()) == entry.getValue()) continue;
            return false;
        }
        return true;
    }
}

