/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.CompilationException;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileUtils {
    public static final String APK_EXTENSION = ".apk";
    public static final String CLASS_EXTENSION = ".class";
    public static final String DEX_EXTENSION = ".dex";
    public static final String JAR_EXTENSION = ".jar";
    public static final String ZIP_EXTENSION = ".zip";
    public static final String DEFAULT_DEX_FILENAME = "classes.dex";

    public static boolean isDexFile(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        return name.endsWith(DEX_EXTENSION);
    }

    public static boolean isClassFile(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        return name.endsWith(CLASS_EXTENSION);
    }

    public static boolean isJarFile(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        return name.endsWith(JAR_EXTENSION);
    }

    public static boolean isZipFile(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        return name.endsWith(ZIP_EXTENSION);
    }

    public static boolean isApkFile(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        return name.endsWith(APK_EXTENSION);
    }

    public static boolean isArchive(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        return name.endsWith(APK_EXTENSION) || name.endsWith(JAR_EXTENSION) || name.endsWith(ZIP_EXTENSION);
    }

    public static List<String> readTextFile(Path file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String line;
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    public static void writeTextFile(Path file, List<String> lines) throws IOException {
        Files.write(file, lines, new OpenOption[0]);
    }

    public static void writeTextFile(Path file, String ... lines) throws IOException {
        Files.write(file, Arrays.asList(lines), new OpenOption[0]);
    }

    public static Path validateOutputFile(Path path) throws CompilationException {
        if (path != null) {
            boolean isJarOrZip;
            boolean bl = isJarOrZip = FileUtils.isZipFile(path) || FileUtils.isJarFile(path);
            if (!(isJarOrZip || Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]))) {
                throw new CompilationException("Invalid output: " + path + "\nOutput must be a .zip or .jar archive or an existing directory");
            }
        }
        return path;
    }

    public static OutputStream openPathWithDefault(Closer closer, Path file, PrintStream defaultOutput, OpenOption ... openOptions) throws IOException {
        OutputStream mapOut;
        if (file == null) {
            mapOut = defaultOutput;
        } else {
            mapOut = Files.newOutputStream(file, openOptions);
            closer.register((Closeable)mapOut);
        }
        return mapOut;
    }
}

