/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.errors;

public class MainDexError
extends RuntimeException {
    private final boolean hasMainDexList;
    private final long numOfMethods;
    private final long numOfFields;
    private final long maxNumOfEntries;

    public MainDexError(boolean hasMainDexList, long numOfMethods, long numOfFields, long maxNumOfEntries) {
        this.hasMainDexList = hasMainDexList;
        this.numOfMethods = numOfMethods;
        this.numOfFields = numOfFields;
        this.maxNumOfEntries = maxNumOfEntries;
    }

    private String getGeneralMessage() {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Cannot fit requested classes in ");
        messageBuilder.append(this.hasMainDexList ? "the main-" : "a single ");
        messageBuilder.append("dex file.\n");
        return messageBuilder.toString();
    }

    private String getNumberRelatedMessage() {
        StringBuilder messageBuilder = new StringBuilder();
        if (this.numOfMethods > this.maxNumOfEntries) {
            messageBuilder.append("# methods: ");
            messageBuilder.append(this.numOfMethods);
            messageBuilder.append(" > ").append(this.maxNumOfEntries).append('\n');
        }
        if (this.numOfFields > this.maxNumOfEntries) {
            messageBuilder.append("# fields: ");
            messageBuilder.append(this.numOfFields);
            messageBuilder.append(" > ").append(this.maxNumOfEntries).append('\n');
        }
        return messageBuilder.toString();
    }

    @Override
    public String getMessage() {
        return this.getGeneralMessage() + this.getNumberRelatedMessage();
    }

    public String getMessageForD8() {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(this.getGeneralMessage());
        if (this.hasMainDexList) {
            messageBuilder.append("Classes required by the main-dex list ");
            messageBuilder.append("do not fit in one dex.\n");
        } else {
            messageBuilder.append("Try supplying a main-dex list.\n");
        }
        messageBuilder.append(this.getNumberRelatedMessage());
        return messageBuilder.toString();
    }

    public String getMessageForR8() {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(this.getGeneralMessage());
        if (this.hasMainDexList) {
            messageBuilder.append("Classes required by main dex rules and the main-dex list ");
            messageBuilder.append("do not fit in one dex.\n");
        } else {
            messageBuilder.append("Try supplying a main-dex list or main dex rules.\n");
        }
        messageBuilder.append(this.getNumberRelatedMessage());
        return messageBuilder.toString();
    }
}

