/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.Cmp;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewArrayFilledData;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.SwitchUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LongInterval;
import com.google.common.base.Equivalence;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CodeRewriter {
    private static final int UNKNOWN_CAN_THROW = 0;
    private static final int CAN_THROW = 1;
    private static final int CANNOT_THROW = 2;
    private static final int MAX_FILL_ARRAY_SIZE = 8192;
    private static final int STOP_SHARED_CONSTANT_THRESHOLD = 50;
    private final AppInfo appInfo;
    private final DexItemFactory dexItemFactory;
    private final Set<DexMethod> libraryMethodsReturningReceiver;

    public CodeRewriter(AppInfo appInfo, Set<DexMethod> libraryMethodsReturningReceiver) {
        this.appInfo = appInfo;
        this.dexItemFactory = appInfo.dexItemFactory;
        this.libraryMethodsReturningReceiver = libraryMethodsReturningReceiver;
    }

    public static boolean removedUnneededDebugPositions(IRCode code) {
        CodeRewriter.computeThrowsColorForAllBlocks(code);
        for (BasicBlock block : code.blocks) {
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                Instruction instruction = (Instruction)iterator.next();
                if (!instruction.isDebugPosition() || CodeRewriter.getThrowsColorForBlock(block, iterator.nextIndex()) != 2) continue;
                iterator.remove();
            }
        }
        return true;
    }

    private static void computeThrowsColorForAllBlocks(IRCode code) {
        code.clearMarks();
        LinkedList<BasicBlock> blocks = code.blocks;
        ArrayList<BasicBlock> worklist = new ArrayList<BasicBlock>();
        for (int i = blocks.size() - 1; i >= 0; --i) {
            BasicBlock block = (BasicBlock)blocks.get(i);
            block.setColor(2);
            int color = CodeRewriter.getThrowsColorForBlock(block, 0);
            block.setColor(color);
            if (color != 0) continue;
            worklist.add(block);
        }
        ArrayList<BasicBlock> remaining = new ArrayList<BasicBlock>(worklist.size());
        while (!worklist.isEmpty()) {
            ImmutableList work = new ImmutableList.Builder().addAll(worklist).addAll(remaining).build();
            worklist.clear();
            remaining.clear();
            for (BasicBlock block : work) {
                if (!block.hasColor(0)) continue;
                block.setColor(2);
                int color = CodeRewriter.getThrowsColorForSuccessors(block);
                block.setColor(color);
                if (color == 0) {
                    remaining.add(block);
                    continue;
                }
                for (BasicBlock predecessor : block.getNormalPredecessors()) {
                    if (!predecessor.hasColor(0)) continue;
                    worklist.add(predecessor);
                }
            }
        }
        for (BasicBlock block : remaining) {
            assert (!block.canThrow());
            block.setColor(2);
        }
    }

    private static int getThrowsColorForBlock(BasicBlock block, int index) {
        InstructionListIterator iterator = block.listIterator(index);
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (instruction.isDebugPosition()) {
                return 2;
            }
            if (!instruction.instructionTypeCanThrow()) continue;
            return 1;
        }
        return CodeRewriter.getThrowsColorForSuccessors(block);
    }

    private static int getThrowsColorForSuccessors(BasicBlock block) {
        int color = 2;
        for (BasicBlock successor : block.getNormalSucessors()) {
            if (successor.hasColor(1)) {
                return 1;
            }
            if (!successor.hasColor(0)) continue;
            color = 0;
        }
        return color;
    }

    private static boolean removedTrivialGotos(IRCode code) {
        BasicBlock nextBlock;
        ListIterator<BasicBlock> iterator = code.listIterator();
        assert (iterator.hasNext());
        BasicBlock block = iterator.next();
        do {
            nextBlock = iterator.hasNext() ? iterator.next() : null;
            BasicBlock blk = block;
            assert (!block.isTrivialGoto() || block.exit().asGoto().getTarget() == block || block.getPredecessors().stream().anyMatch(b -> b.exit().fallthroughBlock() == blk));
            assert (!block.isTrivialGoto() || block.exit().asGoto().getTarget() != nextBlock);
        } while ((block = nextBlock) != null);
        return true;
    }

    private static BasicBlock endOfGotoChain(BasicBlock block) {
        block.mark();
        BasicBlock target = block;
        while (target.isTrivialGoto()) {
            BasicBlock nextTarget = target.exit().asGoto().getTarget();
            if (nextTarget.isMarked()) {
                CodeRewriter.clearTrivialGotoMarks(block);
                return nextTarget;
            }
            nextTarget.mark();
            target = nextTarget;
        }
        CodeRewriter.clearTrivialGotoMarks(block);
        return target;
    }

    private static void clearTrivialGotoMarks(BasicBlock block) {
        while (block.isMarked()) {
            block.clearMark();
            if (!block.isTrivialGoto()) continue;
            block = block.exit().asGoto().getTarget();
        }
    }

    private static void collapsTrivialGoto(BasicBlock block, BasicBlock nextBlock, List<BasicBlock> blocksToRemove) {
        if (block.exit().asGoto().getTarget() == block) {
            return;
        }
        BasicBlock target = CodeRewriter.endOfGotoChain(block);
        boolean needed = false;
        if (target != nextBlock) {
            for (BasicBlock pred : block.getPredecessors()) {
                if (pred.exit().fallthroughBlock() != block) continue;
                needed = true;
                break;
            }
        }
        if (target == block) {
            target = block.exit().asGoto().getTarget();
        }
        if (!needed) {
            blocksToRemove.add(block);
            for (BasicBlock pred : block.getPredecessors()) {
                pred.replaceSuccessor(block, target);
            }
            for (BasicBlock succ : block.getSuccessors()) {
                succ.getPredecessors().remove(block);
            }
            for (BasicBlock pred : block.getPredecessors()) {
                if (target.getPredecessors().contains(pred)) continue;
                target.getPredecessors().add(pred);
            }
        }
    }

    private static void collapsIfTrueTarget(BasicBlock block) {
        If insn = block.exit().asIf();
        BasicBlock target = insn.getTrueTarget();
        BasicBlock newTarget = CodeRewriter.endOfGotoChain(target);
        BasicBlock fallthrough = insn.fallthroughBlock();
        BasicBlock newFallthrough = CodeRewriter.endOfGotoChain(fallthrough);
        if (target != newTarget) {
            insn.getBlock().replaceSuccessor(target, newTarget);
            target.getPredecessors().remove(block);
            if (!newTarget.getPredecessors().contains(block)) {
                newTarget.getPredecessors().add(block);
            }
        }
        if (block.exit().isIf() && (insn = block.exit().asIf()).getTrueTarget() == newFallthrough) {
            block.replaceSuccessor(insn.getTrueTarget(), fallthrough);
            assert (block.exit().isGoto());
            assert (block.exit().asGoto().getTarget() == fallthrough);
        }
    }

    private static void collapsNonFallthroughSwitchTargets(BasicBlock block) {
        Switch insn = block.exit().asSwitch();
        BasicBlock fallthroughBlock = insn.fallthroughBlock();
        HashSet<BasicBlock> replacedBlocks = new HashSet<BasicBlock>();
        for (int j = 0; j < insn.targetBlockIndices().length; ++j) {
            BasicBlock newTarget;
            BasicBlock target = insn.targetBlock(j);
            if (target == fallthroughBlock || target == (newTarget = CodeRewriter.endOfGotoChain(target)) || replacedBlocks.contains(target)) continue;
            insn.getBlock().replaceSuccessor(target, newTarget);
            target.getPredecessors().remove(block);
            if (!newTarget.getPredecessors().contains(block)) {
                newTarget.getPredecessors().add(block);
            }
            replacedBlocks.add(target);
        }
    }

    public void rewriteSwitch(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                int caseBlockIndex;
                Switch theSwitch;
                Instruction instruction = (Instruction)iterator.next();
                if (!instruction.isSwitch() || (theSwitch = instruction.asSwitch()).numberOfKeys() != 1) continue;
                int fallthroughBlockIndex = theSwitch.getFallthroughBlockIndex();
                if (fallthroughBlockIndex < (caseBlockIndex = theSwitch.targetBlockIndices()[0])) {
                    block.swapSuccessorsByIndex(fallthroughBlockIndex, caseBlockIndex);
                }
                if (theSwitch.getFirstKey() == 0) {
                    iterator.replaceCurrentInstruction(new If(If.Type.EQ, theSwitch.value()));
                    continue;
                }
                ConstNumber labelConst = code.createIntConstant(theSwitch.getFirstKey());
                iterator.previous();
                iterator.add(labelConst);
                Instruction dummy = (Instruction)iterator.next();
                assert (dummy == theSwitch);
                If theIf = new If(If.Type.EQ, (List<Value>)ImmutableList.of((Object)theSwitch.value(), (Object)labelConst.dest()));
                iterator.replaceCurrentInstruction(theIf);
            }
        }
    }

    public void removeSwitchMaps(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction staticGet;
                Switch switchInsn;
                SwitchUtils.EnumSwitchInfo info;
                Instruction insn = (Instruction)it.next();
                if (!insn.isSwitch() || (info = SwitchUtils.analyzeSwitchOverEnum(switchInsn = insn.asSwitch(), this.appInfo.withLiveness())) == null) continue;
                Int2IntArrayMap targetMap = new Int2IntArrayMap();
                IntArrayList keys = new IntArrayList(switchInsn.numberOfKeys());
                for (int i = 0; i < switchInsn.numberOfKeys(); ++i) {
                    assert (switchInsn.targetBlockIndices()[i] != switchInsn.getFallthroughBlockIndex());
                    int key = info.ordinalsMap.getInt(info.indexMap.get(switchInsn.getKey(i)));
                    keys.add(key);
                    targetMap.put(key, switchInsn.targetBlockIndices()[i]);
                }
                keys.sort(Comparator.naturalOrder());
                int[] targets = new int[keys.size()];
                for (int i = 0; i < keys.size(); ++i) {
                    targets[i] = targetMap.get(keys.getInt(i));
                }
                Switch newSwitch = new Switch(info.ordinalInvoke.outValue(), keys.toIntArray(), targets, switchInsn.getFallthroughBlockIndex());
                it.replaceCurrentInstruction(newSwitch);
                Instruction arrayGet = info.arrayGet;
                if (arrayGet.outValue().numberOfUsers() == 0) {
                    arrayGet.inValues().forEach(v -> v.removeUser(arrayGet));
                    arrayGet.getBlock().removeInstruction(arrayGet);
                }
                if ((staticGet = info.staticGet).outValue().numberOfUsers() != 0) continue;
                assert (staticGet.inValues().isEmpty());
                staticGet.getBlock().removeInstruction(staticGet);
            }
        }
    }

    public static void collapsTrivialGotos(DexEncodedMethod method, IRCode code) {
        BasicBlock nextBlock;
        assert (code.isConsistentGraph());
        ArrayList<BasicBlock> blocksToRemove = new ArrayList<BasicBlock>();
        ListIterator<BasicBlock> iterator = code.listIterator();
        assert (iterator.hasNext());
        BasicBlock block = iterator.next();
        code.clearMarks();
        do {
            BasicBlock basicBlock = nextBlock = iterator.hasNext() ? iterator.next() : null;
            if (block.isTrivialGoto()) {
                CodeRewriter.collapsTrivialGoto(block, nextBlock, blocksToRemove);
            }
            if (block.exit().isIf()) {
                CodeRewriter.collapsIfTrueTarget(block);
            }
            if (block.exit().isSwitch()) {
                CodeRewriter.collapsNonFallthroughSwitchTargets(block);
            }
            block = nextBlock;
        } while (nextBlock != null);
        code.removeBlocks(blocksToRemove);
        while (!blocksToRemove.isEmpty()) {
            blocksToRemove = new ArrayList();
            iterator = code.listIterator();
            block = iterator.next();
            do {
                BasicBlock basicBlock = nextBlock = iterator.hasNext() ? iterator.next() : null;
                if (!block.isTrivialGoto()) continue;
                CodeRewriter.collapsTrivialGoto(block, nextBlock, blocksToRemove);
            } while ((block = nextBlock) != null);
            code.removeBlocks(blocksToRemove);
        }
        assert (CodeRewriter.removedTrivialGotos(code));
        assert (code.isConsistentGraph());
    }

    public void identifyReturnsArgument(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        Return ret;
        if (code.getNormalExitBlock() != null && !(ret = code.getNormalExitBlock().exit().asReturn()).isReturnVoid()) {
            Value returnValue = ret.returnValue();
            if (returnValue.isArgument()) {
                int index = code.collectArguments().indexOf(returnValue);
                assert (index != -1);
                feedback.methodReturnsArgument(method, index);
            }
            if (returnValue.isConstant() && returnValue.definition.isConstNumber()) {
                long value = returnValue.definition.asConstNumber().getRawValue();
                feedback.methodReturnsConstant(method, value);
            }
            if (returnValue.isNeverNull()) {
                feedback.methodNeverReturnsNull(method);
            }
        }
    }

    private boolean checkArgumentType(InvokeMethod invoke, DexMethod target, int argumentIndex) {
        DexType returnType = invoke.getInvokedMethod().proto.returnType;
        if (invoke.isInvokeStatic()) {
            return invoke.getInvokedMethod().proto.parameters.values[argumentIndex] == returnType;
        }
        if (argumentIndex == 0) {
            return invoke.getInvokedMethod().getHolder() == returnType;
        }
        return invoke.getInvokedMethod().proto.parameters.values[argumentIndex - 1] == returnType;
    }

    public void rewriteMoveResult(IRCode code) {
        AppInfoWithSubtyping appInfoWithSubtyping = this.appInfo.withSubtyping();
        InstructionIterator iterator = code.instructionIterator();
        while (iterator.hasNext()) {
            int argumentIndex;
            DexMethod invokedMethod;
            DexEncodedMethod definition;
            DexEncodedMethod target;
            InvokeMethod invoke;
            Instruction current = (Instruction)iterator.next();
            if (!current.isInvokeMethod() || (invoke = current.asInvokeMethod()).outValue() == null || invoke.outValue().getLocalInfo() != null) continue;
            boolean isLibraryMethodReturningReceiver = this.libraryMethodsReturningReceiver.contains(invoke.getInvokedMethod());
            if (isLibraryMethodReturningReceiver) {
                if (!this.checkArgumentType(invoke, invoke.getInvokedMethod(), 0)) continue;
                invoke.outValue().replaceUsers(invoke.arguments().get(0));
                invoke.setOutValue(null);
                continue;
            }
            if (appInfoWithSubtyping == null || (target = invoke.computeSingleTarget(appInfoWithSubtyping)) == null || (definition = this.appInfo.definitionFor(invokedMethod = target.method)) == null || !definition.getOptimizationInfo().returnsArgument() || (argumentIndex = definition.getOptimizationInfo().getReturnedArgument()) == -1 || !this.checkArgumentType(invoke, target.method, argumentIndex)) continue;
            Value argument = invoke.arguments().get(argumentIndex);
            assert (invoke.outType() == argument.outType() || invoke.outType() == MoveType.OBJECT && argument.outType() == MoveType.SINGLE && argument.getConstInstruction().asConstNumber().isZero());
            invoke.outValue().replaceUsers(argument);
            invoke.setOutValue(null);
        }
        assert (code.isConsistentGraph());
    }

    public void disableAssertions(IRCode code) {
        InstructionIterator iterator = code.instructionIterator();
        while (iterator.hasNext()) {
            Instruction current = (Instruction)iterator.next();
            if (current.isInvokeMethod()) {
                InvokeMethod invoke = current.asInvokeMethod();
                if (invoke.getInvokedMethod() != this.dexItemFactory.classMethods.desiredAssertionStatus) continue;
                iterator.replaceCurrentInstruction(code.createFalse());
                continue;
            }
            if (current.isStaticPut()) {
                StaticPut staticPut = current.asStaticPut();
                if (staticPut.getField().name != this.dexItemFactory.assertionsDisabled) continue;
                iterator.remove();
                continue;
            }
            if (!current.isStaticGet()) continue;
            StaticGet staticGet = current.asStaticGet();
            if (staticGet.getField().name != this.dexItemFactory.assertionsDisabled) continue;
            iterator.replaceCurrentInstruction(code.createTrue());
        }
    }

    private boolean isClassNameConstant(DexEncodedMethod method, StaticPut put) {
        InvokeVirtual invoke;
        if (put.getField().type != this.dexItemFactory.stringType) {
            return false;
        }
        return put.inValue().definition != null && put.inValue().definition.isInvokeVirtual() && ((invoke = put.inValue().definition.asInvokeVirtual()).getInvokedMethod() == this.dexItemFactory.classMethods.getSimpleName || invoke.getInvokedMethod() == this.dexItemFactory.classMethods.getName) && invoke.inValues().get((int)0).definition.isConstClass() && invoke.inValues().get((int)0).definition.asConstClass().getValue() == method.method.getHolder();
    }

    public void collectClassInitializerDefaults(DexEncodedMethod method, IRCode code) {
        if (!method.isClassInitializer()) {
            return;
        }
        DominatorTree dominatorTree = new DominatorTree(code);
        BasicBlock exit = code.getNormalExitBlock();
        if (exit == null) {
            return;
        }
        IdentityHashMap puts = Maps.newIdentityHashMap();
        for (BasicBlock block : dominatorTree.dominatorBlocks(exit)) {
            InstructionListIterator iterator = block.listIterator(block.getInstructions().size());
            while (iterator.hasPrevious()) {
                StaticPut put;
                DexField field;
                Instruction current = (Instruction)iterator.previous();
                if (current.isStaticPut() && (field = (put = current.asStaticPut()).getField()).getHolder() == method.method.getHolder()) {
                    if (put.inValue().isConstant()) {
                        if ((field.type.isClassType() || field.type.isArrayType()) && put.inValue().getConstInstruction().isConstNumber() && put.inValue().getConstInstruction().asConstNumber().isZero()) {
                            puts.put(put.getField(), put);
                        } else if (field.type.isPrimitiveType() || field.type == this.dexItemFactory.stringType) {
                            puts.put(put.getField(), put);
                        }
                    } else if (this.isClassNameConstant(method, put)) {
                        puts.put(put.getField(), put);
                    }
                }
                if (!current.isStaticGet() || !puts.containsKey(current.asStaticGet().getField())) continue;
                puts.remove(current.asStaticGet().getField());
            }
        }
        if (!puts.isEmpty()) {
            InstructionListIterator iterator;
            for (StaticPut put : puts.values()) {
                ConstInstruction cnst;
                DexField field = put.getField();
                DexEncodedField encodedField = this.appInfo.definitionFor(field);
                if (field.type == this.dexItemFactory.stringType) {
                    if (put.inValue().isConstant()) {
                        if (put.inValue().getConstInstruction().isConstNumber()) {
                            assert (put.inValue().getConstInstruction().asConstNumber().isZero());
                            encodedField.staticValue = DexValue.DexValueNull.NULL;
                            continue;
                        }
                        cnst = put.inValue().getConstInstruction().asConstString();
                        encodedField.staticValue = new DexValue.DexValueString(((ConstString)cnst).getValue());
                        continue;
                    }
                    InvokeVirtual invoke = put.inValue().definition.asInvokeVirtual();
                    String name = method.method.getHolder().toSourceString();
                    if (invoke.getInvokedMethod() == this.dexItemFactory.classMethods.getSimpleName) {
                        String simpleName = name.substring(name.lastIndexOf(46) + 1);
                        encodedField.staticValue = new DexValue.DexValueString(this.dexItemFactory.createString(simpleName));
                        continue;
                    }
                    assert (invoke.getInvokedMethod() == this.dexItemFactory.classMethods.getName);
                    encodedField.staticValue = new DexValue.DexValueString(this.dexItemFactory.createString(name));
                    continue;
                }
                if (field.type.isClassType() || field.type.isArrayType()) {
                    if (put.inValue().getConstInstruction().isConstNumber() && put.inValue().getConstInstruction().asConstNumber().isZero()) {
                        encodedField.staticValue = DexValue.DexValueNull.NULL;
                        continue;
                    }
                    throw new Unreachable("Unexpected default value for field type " + field.type + ".");
                }
                cnst = put.inValue().getConstInstruction().asConstNumber();
                if (field.type == this.dexItemFactory.booleanType) {
                    encodedField.staticValue = DexValue.DexValueBoolean.create(((ConstNumber)cnst).getBooleanValue());
                    continue;
                }
                if (field.type == this.dexItemFactory.byteType) {
                    encodedField.staticValue = DexValue.DexValueByte.create((byte)((ConstNumber)cnst).getIntValue());
                    continue;
                }
                if (field.type == this.dexItemFactory.shortType) {
                    encodedField.staticValue = DexValue.DexValueShort.create((short)((ConstNumber)cnst).getIntValue());
                    continue;
                }
                if (field.type == this.dexItemFactory.intType) {
                    encodedField.staticValue = DexValue.DexValueInt.create(((ConstNumber)cnst).getIntValue());
                    continue;
                }
                if (field.type == this.dexItemFactory.longType) {
                    encodedField.staticValue = DexValue.DexValueLong.create(((ConstNumber)cnst).getLongValue());
                    continue;
                }
                if (field.type == this.dexItemFactory.floatType) {
                    encodedField.staticValue = DexValue.DexValueFloat.create(((ConstNumber)cnst).getFloatValue());
                    continue;
                }
                if (field.type == this.dexItemFactory.doubleType) {
                    encodedField.staticValue = DexValue.DexValueDouble.create(((ConstNumber)cnst).getDoubleValue());
                    continue;
                }
                if (field.type == this.dexItemFactory.charType) {
                    encodedField.staticValue = DexValue.DexValueChar.create((char)((ConstNumber)cnst).getIntValue());
                    continue;
                }
                throw new Unreachable("Unexpected field type " + field.type + ".");
            }
            ArrayList<Instruction> toRemove = new ArrayList<Instruction>();
            for (BasicBlock block : dominatorTree.dominatorBlocks(exit)) {
                iterator = block.listIterator();
                while (iterator.hasNext()) {
                    Instruction current = (Instruction)iterator.next();
                    if (!current.isStaticPut() || !puts.values().contains(current.asStaticPut())) continue;
                    iterator.remove();
                    StaticPut put = current.asStaticPut();
                    if (put.inValue().uniqueUsers().size() != 0) continue;
                    if (put.inValue().isConstString()) {
                        toRemove.add(put.inValue().definition);
                        continue;
                    }
                    if (!put.inValue().definition.isInvokeVirtual()) continue;
                    toRemove.add(put.inValue().definition);
                }
            }
            if (toRemove.size() > 0) {
                for (BasicBlock block : dominatorTree.dominatorBlocks(exit)) {
                    iterator = block.listIterator();
                    while (iterator.hasNext()) {
                        if (!toRemove.contains(iterator.next())) continue;
                        iterator.remove();
                    }
                }
            }
        }
    }

    public void removeCastChains(IRCode code) {
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            CheckCast checkCast;
            Instruction current = (Instruction)it.next();
            if (!current.isCheckCast() || current.outValue() == null || !current.outValue().isUsed() || current.outValue().numberOfPhiUsers() != 0 || !(checkCast = current.asCheckCast()).outValue().uniqueUsers().stream().allMatch(user -> user.isCheckCast() && user.asCheckCast().getType().isSubtypeOf(checkCast.getType(), this.appInfo))) continue;
            checkCast.outValue().replaceUsers(checkCast.inValues().get(0));
            it.remove();
        }
    }

    private boolean canBeFolded(Instruction instruction) {
        return instruction.isBinop() && instruction.asBinop().canBeFolded() || instruction.isUnop() && instruction.asUnop().canBeFolded();
    }

    public void foldConstants(IRCode code) {
        LinkedList<BasicBlock> worklist = new LinkedList<BasicBlock>();
        worklist.addAll(code.blocks);
        BasicBlock block = (BasicBlock)worklist.poll();
        while (block != null) {
            InstructionIterator iterator = block.iterator();
            while (iterator.hasNext()) {
                Instruction current = (Instruction)iterator.next();
                if (!this.canBeFolded(current)) continue;
                ConstInstruction folded = current.fold(code);
                iterator.replaceCurrentInstruction(folded);
                folded.outValue().uniqueUsers().forEach(instruction -> worklist.add(instruction.getBlock()));
            }
            block = (BasicBlock)worklist.poll();
        }
        assert (code.isConsistentSSA());
    }

    public void splitRangeInvokeConstants(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction current = (Instruction)it.next();
                if (!current.isInvoke() || current.asInvoke().requiredArgumentRegisters() <= 5) continue;
                Invoke invoke = current.asInvoke();
                it.previous();
                HashMap<ConstNumber, ConstNumber> oldToNew = new HashMap<ConstNumber, ConstNumber>();
                for (int i = 0; i < invoke.inValues().size(); ++i) {
                    Value value = invoke.inValues().get(i);
                    if (!value.isConstNumber() || value.numberOfUsers() <= 1) continue;
                    ConstNumber definition = value.getConstInstruction().asConstNumber();
                    Value originalValue = definition.outValue();
                    ConstNumber newNumber = (ConstNumber)oldToNew.get(definition);
                    if (newNumber == null) {
                        newNumber = ConstNumber.copyOf(code, definition);
                        it.add(newNumber);
                        oldToNew.put(definition, newNumber);
                    }
                    invoke.inValues().set(i, newNumber.outValue());
                    originalValue.removeUser(invoke);
                    newNumber.outValue().addUser(invoke);
                }
                it.next();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void shortenLiveRanges(IRCode code) {
        HashMap addConstantInBlock = new HashMap();
        DominatorTree dominatorTree = new DominatorTree(code);
        BasicBlock block = code.blocks.get(0);
        InstructionListIterator it = block.listIterator();
        ArrayList<Instruction> toInsertInThisBlock = new ArrayList<Instruction>();
        while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            if (!instruction.isConstNumber() || instruction.outValue().numberOfAllUsers() == 0) continue;
            LinkedList<BasicBlock> userBlocks = new LinkedList<BasicBlock>();
            for (Instruction instruction2 : instruction.outValue().uniqueUsers()) {
                userBlocks.add(instruction2.getBlock());
            }
            for (Phi phi : instruction.outValue().uniquePhiUsers()) {
                userBlocks.add(phi.getBlock());
            }
            BasicBlock dominator = dominatorTree.closestDominator(userBlocks);
            for (Phi phi3 : instruction.outValue().uniquePhiUsers()) {
                if (phi3.getBlock() != dominator) continue;
                dominator = dominatorTree.immediateDominator(dominator);
                break;
            }
            it.detach();
            if (dominator != block) {
                void var10_18;
                List list = (List)addConstantInBlock.get(dominator);
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    addConstantInBlock.put(dominator, arrayList);
                }
                var10_18.add(instruction);
                continue;
            }
            toInsertInThisBlock.add(instruction);
        }
        for (Map.Entry entry : addConstantInBlock.entrySet()) {
            if (((List)entry.getValue()).size() > 50) {
                for (Instruction instruction : (List)entry.getValue()) {
                    if (instruction.outValue().numberOfPhiUsers() != 0) {
                        this.insertConstantInBlock(instruction, (BasicBlock)entry.getKey());
                        continue;
                    }
                    assert (instruction.outValue().numberOfUsers() != 0);
                    ConstNumber constNumber = instruction.asConstNumber();
                    Value constantValue = instruction.outValue();
                    for (Instruction user : constantValue.uniqueUsers()) {
                        ConstNumber newCstNum = ConstNumber.copyOf(code, constNumber);
                        InstructionListIterator iterator = user.getBlock().listIterator(user);
                        iterator.previous();
                        iterator.add(newCstNum);
                        user.replaceValue(constantValue, newCstNum.outValue());
                    }
                }
                continue;
            }
            for (Instruction instruction : (List)entry.getValue()) {
                this.insertConstantInBlock(instruction, (BasicBlock)entry.getKey());
            }
        }
        for (Instruction toInsert : toInsertInThisBlock) {
            this.insertConstantInBlock(toInsert, block);
        }
        assert (code.isConsistentSSA());
    }

    private void insertConstantInBlock(Instruction instruction, BasicBlock block) {
        boolean hasCatchHandlers = block.hasCatchHandlers();
        InstructionListIterator insertAt = block.listIterator();
        insertAt.nextUntil(i -> i.inValues().contains(instruction.outValue()) || i.isJumpInstruction() || hasCatchHandlers && i.instructionInstanceCanThrow());
        insertAt.previous();
        insertAt.add(instruction);
    }

    private short[] computeArrayFilledData(ConstInstruction[] values, int size, int elementSize) {
        if (values == null) {
            return null;
        }
        if (elementSize == 1) {
            short[] result = new short[(size + 1) / 2];
            for (int i = 0; i < size; i += 2) {
                short value = (short)(values[i].asConstNumber().getIntValue() & 0xFF);
                if (i + 1 < size) {
                    value = (short)(value | (short)((values[i + 1].asConstNumber().getIntValue() & 0xFF) << 8));
                }
                result[i / 2] = value;
            }
            return result;
        }
        assert (elementSize == 2 || elementSize == 4 || elementSize == 8);
        int shortsPerConstant = elementSize / 2;
        short[] result = new short[size * shortsPerConstant];
        for (int i = 0; i < size; ++i) {
            long value = values[i].asConstNumber().getRawValue();
            for (int part = 0; part < shortsPerConstant; ++part) {
                result[i * shortsPerConstant + part] = (short)(value >> 16 * part & 0xFFFFL);
            }
        }
        return result;
    }

    private ConstInstruction[] computeConstantArrayValues(NewArrayEmpty newArray, BasicBlock block, int size) {
        if (size > 8192) {
            return null;
        }
        ConstInstruction[] values = new ConstInstruction[size];
        int remaining = size;
        Set<Instruction> users = newArray.outValue().uniqueUsers();
        InstructionListIterator it = block.listIterator();
        it.nextUntil(i -> i == newArray);
        while (true) {
            if (it.hasNext()) {
                ConstInstruction value;
                Instruction instruction = (Instruction)it.next();
                if (block.hasCatchHandlers() && instruction.instructionInstanceCanThrow()) {
                    return null;
                }
                if (!users.contains(instruction)) continue;
                if (!instruction.isArrayPut()) {
                    return null;
                }
                ArrayPut arrayPut = instruction.asArrayPut();
                if (!arrayPut.source().isConstant() || !arrayPut.index().isConstNumber()) {
                    return null;
                }
                int index = arrayPut.index().getConstInstruction().asConstNumber().getIntValue();
                assert (index >= 0 && index < values.length);
                if (values[index] != null) {
                    return null;
                }
                values[index] = value = arrayPut.source().getConstInstruction();
                if (--remaining != 0) continue;
                return values;
            }
            it = (block = block.exit().isGoto() ? block.exit().asGoto().getTarget() : null) != null ? block.listIterator() : null;
            if (it == null) break;
        }
        return null;
    }

    private boolean isPrimitiveOrStringNewArrayWithPositiveSize(Instruction instruction) {
        if (!(instruction instanceof NewArrayEmpty)) {
            return false;
        }
        NewArrayEmpty newArray = instruction.asNewArrayEmpty();
        if (!newArray.size().isConstant()) {
            return false;
        }
        assert (newArray.size().isConstNumber());
        int size = newArray.size().getConstInstruction().asConstNumber().getIntValue();
        if (size < 1) {
            return false;
        }
        return newArray.type.isPrimitiveArrayType() || newArray.type == this.dexItemFactory.stringArrayType;
    }

    public void simplifyArrayConstruction(IRCode code) {
        for (BasicBlock block : code.blocks) {
            Instruction instruction;
            HashMap<Value, InvokeNewArray> instructionToInsertForArray = new HashMap<Value, InvokeNewArray>();
            HashMap<Value, Integer> storesToRemoveForArray = new HashMap<Value, Integer>();
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                int size;
                NewArrayEmpty newArray;
                ConstInstruction[] values;
                instruction = (Instruction)it.next();
                if (!this.isPrimitiveOrStringNewArrayWithPositiveSize(instruction) || (values = this.computeConstantArrayValues(newArray = instruction.asNewArrayEmpty(), block, size = newArray.size().getConstInstruction().asConstNumber().getIntValue())) == null) continue;
                if (newArray.type == this.dexItemFactory.stringArrayType) {
                    if (size > 200) continue;
                    ArrayList<Value> stringValues = new ArrayList<Value>(size);
                    for (ConstInstruction value : values) {
                        stringValues.add(value.outValue());
                    }
                    InvokeNewArray invoke = new InvokeNewArray(this.dexItemFactory.stringArrayType, newArray.outValue(), stringValues);
                    it.detach();
                    for (Value value : newArray.inValues()) {
                        value.removeUser(newArray);
                    }
                    instructionToInsertForArray.put(newArray.outValue(), invoke);
                } else {
                    int elementSize;
                    short[] contents;
                    if (size == 1 || (contents = this.computeArrayFilledData(values, size, elementSize = newArray.type.elementSizeForPrimitiveArrayType())) == null) continue;
                    int arraySize = newArray.size().getConstInstruction().asConstNumber().getIntValue();
                    NewArrayFilledData fillArray = new NewArrayFilledData(newArray.outValue(), elementSize, arraySize, contents);
                    it.add(fillArray);
                }
                storesToRemoveForArray.put(newArray.outValue(), size);
            }
            if (storesToRemoveForArray.isEmpty()) continue;
            do {
                it = block.listIterator();
                while (it.hasNext()) {
                    Value array;
                    Integer toRemoveCount;
                    instruction = (Instruction)it.next();
                    if (!instruction.isArrayPut() || (toRemoveCount = (Integer)storesToRemoveForArray.get(array = instruction.asArrayPut().array())) == null) continue;
                    if (toRemoveCount > 0) {
                        toRemoveCount = toRemoveCount - 1;
                        storesToRemoveForArray.put(array, toRemoveCount);
                        it.remove();
                    }
                    if (toRemoveCount != 0) continue;
                    toRemoveCount = toRemoveCount - 1;
                    storesToRemoveForArray.put(array, toRemoveCount);
                    Instruction construction = (Instruction)instructionToInsertForArray.get(array);
                    if (construction == null) continue;
                    it.add(construction);
                }
            } while ((block = block.exit().isGoto() ? block.exit().asGoto().getTarget() : null) != null);
        }
    }

    private boolean shareCatchHandlers(Instruction i0, Instruction i1) {
        if (!i0.instructionTypeCanThrow()) {
            assert (!i1.instructionTypeCanThrow());
            return true;
        }
        assert (i1.instructionTypeCanThrow());
        CatchHandlers<BasicBlock> ch0 = i0.getBlock().getCatchHandlers();
        CatchHandlers<BasicBlock> ch1 = i1.getBlock().getCatchHandlers();
        return ch0.equals(ch1);
    }

    public void commonSubexpressionElimination(IRCode code) {
        ArrayListMultimap instructionToValue = ArrayListMultimap.create();
        DominatorTree dominatorTree = new DominatorTree(code);
        ExpressionEquivalence equivalence = new ExpressionEquivalence();
        for (int i = 0; i < dominatorTree.getSortedBlocks().length; ++i) {
            BasicBlock block = dominatorTree.getSortedBlocks()[i];
            InstructionIterator iterator = block.iterator();
            while (iterator.hasNext()) {
                Instruction instruction = (Instruction)iterator.next();
                if (!instruction.isBinop() && !instruction.isUnop() && !instruction.isInstanceOf() && !instruction.isCheckCast()) continue;
                List candidates = instructionToValue.get((Object)equivalence.wrap(instruction));
                boolean eliminated = false;
                if (candidates.size() > 0) {
                    for (Value candidate : candidates) {
                        if (!dominatorTree.dominatedBy(block, candidate.definition.getBlock()) || !this.shareCatchHandlers(instruction, candidate.definition)) continue;
                        instruction.outValue().replaceUsers(candidate);
                        eliminated = true;
                        iterator.remove();
                        break;
                    }
                }
                if (eliminated) continue;
                instructionToValue.put((Object)equivalence.wrap(instruction), (Object)instruction.outValue());
            }
        }
        assert (code.isConsistentSSA());
    }

    public void simplifyIf(IRCode code) {
        DominatorTree dominator = new DominatorTree(code);
        code.clearMarks();
        for (BasicBlock block : code.blocks) {
            int cond;
            if (block.isMarked() || !block.exit().isIf()) continue;
            this.rewriteIfWithConstZero(block);
            If theIf = block.exit().asIf();
            List<Value> inValues = theIf.inValues();
            if (inValues.get(0).isConstNumber() && (theIf.isZeroTest() || inValues.get(1).isConstNumber())) {
                if (theIf.isZeroTest()) {
                    cond = inValues.get(0).getConstInstruction().asConstNumber().getIntValue();
                } else {
                    int left = inValues.get(0).getConstInstruction().asConstNumber().getIntValue();
                    int right = inValues.get(1).getConstInstruction().asConstNumber().getIntValue();
                    cond = left - right;
                }
            } else {
                if (!inValues.get(0).hasValueRange() || !theIf.isZeroTest() && !inValues.get(1).hasValueRange()) continue;
                if (theIf.isZeroTest()) {
                    if (inValues.get(0).isValueInRange(0)) continue;
                    cond = Long.signum(inValues.get(0).getValueRange().getMin());
                } else {
                    LongInterval rightRange;
                    LongInterval leftRange = inValues.get(0).getValueRange();
                    if (leftRange.overlapsWith(rightRange = inValues.get(1).getValueRange())) continue;
                    cond = Long.signum(leftRange.getMin() - rightRange.getMin());
                }
            }
            BasicBlock target = theIf.targetFromCondition(cond);
            BasicBlock deadTarget = target == theIf.getTrueTarget() ? theIf.fallthroughBlock() : theIf.getTrueTarget();
            List<BasicBlock> removedBlocks = block.unlink(deadTarget, dominator);
            for (BasicBlock removedBlock : removedBlocks) {
                if (removedBlock.isMarked()) continue;
                removedBlock.mark();
            }
            assert (theIf == block.exit());
            block.replaceLastInstruction(new Goto());
            assert (block.exit().isGoto());
            assert (block.exit().asGoto().getTarget() == target);
        }
        code.removeMarkedBlocks();
        assert (code.isConsistentSSA());
    }

    private void rewriteIfWithConstZero(BasicBlock block) {
        If theIf = block.exit().asIf();
        if (theIf.isZeroTest()) {
            return;
        }
        List<Value> inValues = theIf.inValues();
        Value leftValue = inValues.get(0);
        Value rightValue = inValues.get(1);
        if (leftValue.isConstNumber() || rightValue.isConstNumber()) {
            if (leftValue.isConstNumber()) {
                int left = leftValue.getConstInstruction().asConstNumber().getIntValue();
                if (left == 0) {
                    If ifz = new If(theIf.getType().forSwappedOperands(), rightValue);
                    block.replaceLastInstruction(ifz);
                    assert (block.exit() == ifz);
                }
            } else {
                int right = rightValue.getConstInstruction().asConstNumber().getIntValue();
                if (right == 0) {
                    If ifz = new If(theIf.getType(), leftValue);
                    block.replaceLastInstruction(ifz);
                    assert (block.exit() == ifz);
                }
            }
        }
    }

    public void rewriteLongCompareAndRequireNonNull(IRCode code, InternalOptions options) {
        if (options.canUseLongCompareAndObjectsNonNull()) {
            return;
        }
        InstructionIterator iterator = code.instructionIterator();
        while (iterator.hasNext()) {
            Instruction current = (Instruction)iterator.next();
            if (!current.isInvokeMethod()) continue;
            DexMethod invokedMethod = current.asInvokeMethod().getInvokedMethod();
            if (invokedMethod == this.dexItemFactory.longMethods.compare) {
                List<Value> inValues = current.inValues();
                assert (inValues.size() == 2);
                iterator.replaceCurrentInstruction(new Cmp(NumericType.LONG, Cmp.Bias.NONE, current.outValue(), inValues.get(0), inValues.get(1)));
                continue;
            }
            if (invokedMethod != this.dexItemFactory.objectsMethods.requireNonNull) continue;
            InvokeVirtual callToGetClass = new InvokeVirtual(this.dexItemFactory.objectMethods.getClass, null, current.inValues());
            if (current.outValue() != null) {
                current.outValue().replaceUsers(current.inValues().get(0));
                current.setOutValue(null);
            }
            iterator.replaceCurrentInstruction(callToGetClass);
        }
        assert (code.isConsistentSSA());
    }

    public void rewriteThrowableAddAndGetSuppressed(IRCode code) {
        DexItemFactory.ThrowableMethods throwableMethods = this.dexItemFactory.throwableMethods;
        for (BasicBlock block : code.blocks) {
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                Instruction current = (Instruction)iterator.next();
                if (!current.isInvokeMethod()) continue;
                DexMethod invokedMethod = current.asInvokeMethod().getInvokedMethod();
                if (this.matchesMethodOfThrowable(invokedMethod, throwableMethods.addSuppressed)) {
                    iterator.remove();
                    continue;
                }
                if (!this.matchesMethodOfThrowable(invokedMethod, throwableMethods.getSuppressed)) continue;
                Value destValue = current.outValue();
                if (destValue == null) {
                    iterator.remove();
                    continue;
                }
                ConstNumber zero = code.createIntConstant(0);
                assert (iterator.hasPrevious());
                iterator.previous();
                iterator.add(zero);
                Instruction next = (Instruction)iterator.next();
                assert (current == next);
                NewArrayEmpty newArray = new NewArrayEmpty(destValue, zero.outValue(), this.dexItemFactory.createType(this.dexItemFactory.throwableArrayDescriptor));
                iterator.replaceCurrentInstruction(newArray);
            }
        }
        assert (code.isConsistentSSA());
    }

    private boolean matchesMethodOfThrowable(DexMethod invoked, DexMethod expected) {
        return invoked.name == expected.name && invoked.proto == expected.proto && this.isSubtypeOfThrowable(invoked.holder);
    }

    private boolean isSubtypeOfThrowable(DexType type) {
        while (type != null && type != this.dexItemFactory.objectType) {
            if (type == this.dexItemFactory.throwableType) {
                return true;
            }
            DexClass dexClass = this.appInfo.definitionFor(type);
            if (dexClass == null) {
                throw new CompilationError("Class or interface " + type.toSourceString() + " required for desugaring of try-with-resources is not found.");
            }
            type = dexClass.superType;
        }
        return false;
    }

    private Value addConstString(IRCode code, InstructionListIterator iterator, String s) {
        Value value = code.createValue(MoveType.OBJECT);
        iterator.add(new ConstString(value, this.dexItemFactory.createString(s)));
        return value;
    }

    public void logArgumentTypes(DexEncodedMethod method, IRCode code) {
        List<Value> arguments = code.collectArguments();
        BasicBlock block = code.blocks.getFirst();
        InstructionListIterator iterator = block.listIterator();
        iterator.nextUntil(instruction -> !instruction.isArgument());
        iterator.previous();
        iterator.split(code);
        iterator.previous();
        assert (!block.hasCatchHandlers());
        Value out = code.createValue(MoveType.OBJECT);
        DexType javaLangSystemType = this.dexItemFactory.createType("Ljava/lang/System;");
        DexType javaIoPrintStreamType = this.dexItemFactory.createType("Ljava/io/PrintStream;");
        DexProto proto = this.dexItemFactory.createProto(this.dexItemFactory.voidType, this.dexItemFactory.objectType);
        DexMethod print = this.dexItemFactory.createMethod(javaIoPrintStreamType, proto, "print");
        DexMethod printLn = this.dexItemFactory.createMethod(javaIoPrintStreamType, proto, "println");
        iterator.add(new StaticGet(MemberType.OBJECT, out, this.dexItemFactory.createField(javaLangSystemType, javaIoPrintStreamType, "out")));
        Value value = code.createValue(MoveType.OBJECT);
        iterator.add(new ConstString(value, this.dexItemFactory.createString("INVOKE ")));
        iterator.add(new InvokeVirtual(print, null, (List<Value>)ImmutableList.of((Object)out, (Object)value)));
        value = code.createValue(MoveType.OBJECT);
        iterator.add(new ConstString(value, this.dexItemFactory.createString(method.method.qualifiedName())));
        iterator.add(new InvokeVirtual(print, null, (List<Value>)ImmutableList.of((Object)out, (Object)value)));
        Value openParenthesis = this.addConstString(code, iterator, "(");
        Value comma = this.addConstString(code, iterator, ",");
        Value closeParenthesis = this.addConstString(code, iterator, ")");
        Value indent = this.addConstString(code, iterator, "  ");
        Value nul = this.addConstString(code, iterator, "(null)");
        Value primitive = this.addConstString(code, iterator, "(primitive)");
        Value empty = this.addConstString(code, iterator, "");
        iterator.add(new InvokeVirtual(printLn, null, (List<Value>)ImmutableList.of((Object)out, (Object)openParenthesis)));
        for (int i = 0; i < arguments.size(); ++i) {
            iterator.add(new InvokeVirtual(print, null, (List<Value>)ImmutableList.of((Object)out, (Object)indent)));
            BasicBlock eol = BasicBlock.createGotoBlock(code.blocks.size());
            code.blocks.add(eol);
            BasicBlock successor = block.unlinkSingleSuccessor();
            block.link(eol);
            eol.link(successor);
            Value argument = arguments.get(i);
            if (argument.outType() != MoveType.OBJECT) {
                iterator.add(new InvokeVirtual(print, null, (List<Value>)ImmutableList.of((Object)out, (Object)primitive)));
            } else {
                successor = block.unlinkSingleSuccessor();
                If theIf = new If(If.Type.NE, argument);
                BasicBlock ifBlock = BasicBlock.createIfBlock(code.blocks.size(), theIf);
                code.blocks.add(ifBlock);
                BasicBlock isNullBlock = BasicBlock.createGotoBlock(code.blocks.size());
                code.blocks.add(isNullBlock);
                BasicBlock isNotNullBlock = BasicBlock.createGotoBlock(code.blocks.size());
                code.blocks.add(isNotNullBlock);
                block.link(ifBlock);
                ifBlock.link(isNotNullBlock);
                ifBlock.link(isNullBlock);
                isNotNullBlock.link(successor);
                isNullBlock.link(successor);
                iterator = isNullBlock.listIterator();
                iterator.add(new InvokeVirtual(print, null, (List<Value>)ImmutableList.of((Object)out, (Object)nul)));
                iterator = isNotNullBlock.listIterator();
                value = code.createValue(MoveType.OBJECT);
                iterator.add(new InvokeVirtual(this.dexItemFactory.objectMethods.getClass, value, (List<Value>)ImmutableList.of((Object)arguments.get(i))));
                iterator.add(new InvokeVirtual(print, null, (List<Value>)ImmutableList.of((Object)out, (Object)value)));
            }
            iterator = eol.listIterator();
            if (i == arguments.size() - 1) {
                iterator.add(new InvokeVirtual(printLn, null, (List<Value>)ImmutableList.of((Object)out, (Object)closeParenthesis)));
            } else {
                iterator.add(new InvokeVirtual(printLn, null, (List<Value>)ImmutableList.of((Object)out, (Object)comma)));
            }
            block = eol;
        }
        iterator.add(new InvokeVirtual(printLn, null, (List<Value>)ImmutableList.of((Object)out, (Object)empty)));
    }

    private static class ExpressionEquivalence
    extends Equivalence<Instruction> {
        private ExpressionEquivalence() {
        }

        protected boolean doEquivalent(Instruction a, Instruction b) {
            if (a.getClass() != b.getClass() || !a.identicalNonValueParts(b)) {
                return false;
            }
            if (a.isBinop() && a.asBinop().isCommutative()) {
                Value a0 = a.inValues().get(0);
                Value a1 = a.inValues().get(1);
                Value b0 = b.inValues().get(0);
                Value b1 = b.inValues().get(1);
                return a0.equals(b0) && a1.equals(b1) || a0.equals(b1) && a1.equals(b0);
            }
            assert (a.inValues().size() == b.inValues().size());
            for (int i = 0; i < a.inValues().size(); ++i) {
                if (a.inValues().get(i).equals(b.inValues().get(i))) continue;
                return false;
            }
            return true;
        }

        protected int doHash(Instruction instruction) {
            int prime = 29;
            int hash = instruction.getClass().hashCode();
            if (instruction.isBinop()) {
                Binop binop = instruction.asBinop();
                Value in0 = instruction.inValues().get(0);
                Value in1 = instruction.inValues().get(1);
                if (binop.isCommutative()) {
                    hash += hash * 29 + in0.hashCode() * in1.hashCode();
                } else {
                    hash += hash * 29 + in0.hashCode();
                    hash += hash * 29 + in1.hashCode();
                }
                return hash;
            }
            for (Value value : instruction.inValues()) {
                hash += hash * 29 + value.hashCode();
            }
            return hash;
        }
    }
}

