/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadUtils {
    public static <T> List<T> awaitFutures(List<? extends Future<? extends T>> futures) throws ExecutionException {
        ArrayList<T> result = new ArrayList<T>(futures.size());
        for (Future<T> f : futures) {
            try {
                result.add(f.get());
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for future.", e);
            }
        }
        return result;
    }

    public static ExecutorService getExecutorService(int threads) {
        if (threads == 1) {
            return Executors.newSingleThreadExecutor();
        }
        return Executors.newWorkStealingPool(threads);
    }

    public static ExecutorService getExecutorService(InternalOptions options) {
        if (options.numberOfThreads == options.NOT_SPECIFIED) {
            int threads = Integer.min(Runtime.getRuntime().availableProcessors(), 16) / 2;
            return Executors.newWorkStealingPool(threads);
        }
        if (options.numberOfThreads == 1) {
            return Executors.newSingleThreadExecutor();
        }
        return Executors.newWorkStealingPool(options.numberOfThreads);
    }
}

