/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;

abstract class BaseCommand {
    private final boolean printHelp;
    private final boolean printVersion;
    private final AndroidApp app;
    private final Path outputPath;
    private final OutputMode outputMode;
    private final CompilationMode mode;
    private final int minApiLevel;

    BaseCommand(boolean printHelp, boolean printVersion) {
        this.printHelp = printHelp;
        this.printVersion = printVersion;
        this.app = null;
        this.outputPath = null;
        this.outputMode = OutputMode.Indexed;
        this.mode = null;
        this.minApiLevel = 0;
    }

    BaseCommand(AndroidApp app, Path outputPath, OutputMode outputMode, CompilationMode mode, int minApiLevel) {
        assert (app != null);
        assert (mode != null);
        assert (minApiLevel > 0);
        this.app = app;
        this.outputPath = outputPath;
        this.outputMode = outputMode;
        this.mode = mode;
        this.minApiLevel = minApiLevel;
        this.printHelp = false;
        this.printVersion = false;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    AndroidApp getInputApp() {
        return this.app;
    }

    abstract InternalOptions getInternalOptions();

    public Path getOutputPath() {
        return this.outputPath;
    }

    public CompilationMode getMode() {
        return this.mode;
    }

    public int getMinApiLevel() {
        return this.minApiLevel;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    static abstract class Builder<C extends BaseCommand, B extends Builder<C, B>> {
        private boolean printHelp = false;
        private boolean printVersion = false;
        private final AndroidApp.Builder app;
        private Path outputPath = null;
        private OutputMode outputMode = OutputMode.Indexed;
        private CompilationMode mode;
        private int minApiLevel = 1;
        protected boolean ignoreDexInArchive = false;

        protected Builder(CompilationMode mode) {
            this(AndroidApp.builder(), mode);
        }

        Builder(AndroidApp app, CompilationMode mode) {
            this(AndroidApp.builder(app), mode);
        }

        private Builder(AndroidApp.Builder builder, CompilationMode mode) {
            assert (mode != null);
            this.app = builder;
            this.mode = mode;
            this.app.setIgnoreDexInArchive(this.ignoreDexInArchive);
        }

        abstract B self();

        public abstract C build() throws CompilationException, IOException;

        AndroidApp.Builder getAppBuilder() {
            return this.app;
        }

        public B addProgramFiles(Path ... files) throws IOException {
            this.app.addProgramFiles(files);
            return this.self();
        }

        public B addProgramFiles(Collection<Path> files) throws IOException {
            this.app.addProgramFiles(files);
            return this.self();
        }

        public B addLibraryResourceProvider(ClassFileResourceProvider provider) {
            this.getAppBuilder().addLibraryResourceProvider(provider);
            return this.self();
        }

        public B addLibraryFiles(Path ... files) throws IOException {
            this.app.addLibraryFiles(files);
            return this.self();
        }

        public B addLibraryFiles(Collection<Path> files) throws IOException {
            this.app.addLibraryFiles(files);
            return this.self();
        }

        public B addClassProgramData(byte[] ... data) {
            this.app.addClassProgramData(data);
            return this.self();
        }

        public B addClassProgramData(Collection<byte[]> data) {
            this.app.addClassProgramData(data);
            return this.self();
        }

        public B addDexProgramData(byte[] ... data) {
            this.app.addDexProgramData(data);
            return this.self();
        }

        public B addDexProgramData(Collection<byte[]> data) {
            this.app.addDexProgramData(data);
            return this.self();
        }

        public CompilationMode getMode() {
            return this.mode;
        }

        public B setMode(CompilationMode mode) {
            assert (mode != null);
            this.mode = mode;
            return this.self();
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public OutputMode getOutputMode() {
            return this.outputMode;
        }

        public B setOutputPath(Path outputPath) {
            this.outputPath = outputPath;
            return this.self();
        }

        public B setOutputMode(OutputMode outputMode) {
            this.outputMode = outputMode;
            return this.self();
        }

        public int getMinApiLevel() {
            return this.minApiLevel;
        }

        public B setMinApiLevel(int minApiLevel) {
            assert (minApiLevel > 0);
            this.minApiLevel = minApiLevel;
            return this.self();
        }

        public B addMainDexListFiles(Path ... files) throws IOException {
            this.app.addMainDexListFiles(files);
            return this.self();
        }

        public B addMainDexListFiles(Collection<Path> files) throws IOException {
            this.app.addMainDexListFiles(files);
            return this.self();
        }

        public B addMainDexClasses(String ... classes) {
            this.app.addMainDexClasses(classes);
            return this.self();
        }

        public B addMainDexClasses(Collection<String> classes) {
            this.app.addMainDexClasses(classes);
            return this.self();
        }

        public boolean isPrintHelp() {
            return this.printHelp;
        }

        public B setPrintHelp(boolean printHelp) {
            this.printHelp = printHelp;
            return this.self();
        }

        public boolean isPrintVersion() {
            return this.printVersion;
        }

        public B setPrintVersion(boolean printVersion) {
            this.printVersion = printVersion;
            return this.self();
        }

        protected void validate() throws CompilationException {
            if (this.app.hasMainDexList() && this.outputMode == OutputMode.FilePerClass) {
                throw new CompilationException("Option --main-dex-list cannot be used with --file-per-class");
            }
            FileUtils.validateOutputFile(this.outputPath);
        }
    }
}

