/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Set;

public abstract class Resource {
    public final Kind kind;

    protected Resource(Kind kind) {
        this.kind = kind;
    }

    public static Resource fromFile(Kind kind, Path file) {
        return new FileResource(kind, file);
    }

    public static Resource fromBytes(Kind kind, byte[] bytes) {
        return Resource.fromBytes(kind, bytes, null);
    }

    public static Resource fromBytes(Kind kind, byte[] bytes, Set<String> typeDescriptors) {
        return new ByteResource(kind, bytes, typeDescriptors);
    }

    public abstract Set<String> getClassDescriptors();

    public abstract InputStream getStream() throws IOException;

    private static class ByteResource
    extends Resource {
        final Set<String> classDescriptors;
        final byte[] bytes;

        ByteResource(Kind kind, byte[] bytes, Set<String> classDescriptors) {
            super(kind);
            assert (bytes != null);
            this.classDescriptors = classDescriptors;
            this.bytes = bytes;
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.classDescriptors;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    private static class FileResource
    extends Resource {
        final Path file;

        FileResource(Kind kind, Path file) {
            super(kind);
            assert (file != null);
            this.file = file;
        }

        @Override
        public Set<String> getClassDescriptors() {
            return null;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new FileInputStream(this.file.toFile());
        }
    }

    public static enum Kind {
        DEX,
        CLASSFILE;

    }
}

