/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.builder.core.DexProcessBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.internal.compiler.DexWrapper;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.utils.PerformanceUtils;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DexByteCodeConverter {
    public static final long DEFAULT_DEX_HEAP_SIZE = 0x40000000L;
    private static final Object LOCK_FOR_DEX = new Object();
    private static final AtomicInteger DEX_PROCESS_COUNT = new AtomicInteger(4);
    private static ExecutorService sDexExecutorService = null;
    private final boolean mVerboseExec;
    private final JavaProcessExecutor mJavaProcessExecutor;
    private final TargetInfo mTargetInfo;
    private final ILogger mLogger;
    private Boolean mIsDexInProcess = null;
    private ErrorReporter errorReporter;

    public DexByteCodeConverter(ILogger logger, TargetInfo targetInfo, JavaProcessExecutor javaProcessExecutor, boolean verboseExec, ErrorReporter errorReporter) {
        this.mLogger = logger;
        this.mTargetInfo = targetInfo;
        this.mJavaProcessExecutor = javaProcessExecutor;
        this.mVerboseExec = verboseExec;
        this.errorReporter = errorReporter;
    }

    public void convertByteCode(Collection<File> inputs, File outDexFolder, boolean multidex, File mainDexList, DexOptions dexOptions, ProcessOutputHandler processOutputHandler, int minSdkVersion) throws IOException, InterruptedException, ProcessException {
        Preconditions.checkNotNull(inputs, (Object)"inputs cannot be null.");
        Preconditions.checkNotNull((Object)outDexFolder, (Object)"outDexFolder cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        Preconditions.checkArgument((boolean)outDexFolder.isDirectory(), (Object)"outDexFolder must be a folder");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call convertByteCode() before setTargetInfo() is called.");
        ImmutableList.Builder verifiedInputs = ImmutableList.builder();
        for (File input : inputs) {
            if (!DexByteCodeConverter.checkLibraryClassesJar(input)) continue;
            verifiedInputs.add((Object)input);
        }
        DexProcessBuilder builder = new DexProcessBuilder(outDexFolder);
        builder.setVerbose(this.mVerboseExec).setMultiDex(multidex).setMainDexList(mainDexList).addInputs((Collection<File>)verifiedInputs.build()).setMinSdkVersion(minSdkVersion);
        this.runDexer(builder, dexOptions, processOutputHandler);
    }

    public void runDexer(DexProcessBuilder builder, DexOptions dexOptions, ProcessOutputHandler processOutputHandler) throws ProcessException, IOException, InterruptedException {
        this.initDexExecutorService(dexOptions);
        if (dexOptions.getAdditionalParameters().contains("--no-optimize")) {
            this.mLogger.warning("Disabling dex optimization produces wrong local debug info, b.android.com/82031.", new Object[0]);
        }
        if (this.shouldDexInProcess(dexOptions)) {
            this.dexInProcess(builder, dexOptions, processOutputHandler);
        } else {
            this.dexOutOfProcess(builder, dexOptions, processOutputHandler);
        }
    }

    private void dexInProcess(DexProcessBuilder builder, DexOptions dexOptions, ProcessOutputHandler outputHandler) throws IOException, ProcessException {
        String submission = Joiner.on((char)',').join(builder.getInputs());
        this.mLogger.verbose("Dexing in-process : %1$s", new Object[]{submission});
        try {
            sDexExecutorService.submit(() -> {
                Stopwatch stopwatch = Stopwatch.createStarted();
                ProcessResult result = DexWrapper.run(builder, dexOptions, outputHandler);
                result.assertNormalExitValue();
                this.mLogger.verbose("Dexing %1$s took %2$s.", new Object[]{submission, stopwatch.toString()});
                return null;
            }).get();
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    private void dexOutOfProcess(DexProcessBuilder builder, DexOptions dexOptions, ProcessOutputHandler processOutputHandler) throws ProcessException, InterruptedException {
        String submission = Joiner.on((char)',').join(builder.getInputs());
        this.mLogger.verbose("Dexing out-of-process : %1$s", new Object[]{submission});
        try {
            Callable<Void> task = () -> {
                JavaProcessInfo javaProcessInfo = builder.build(this.mTargetInfo.getBuildTools(), dexOptions);
                ProcessResult result = this.mJavaProcessExecutor.execute(javaProcessInfo, processOutputHandler);
                result.rethrowFailure().assertNormalExitValue();
                return null;
            };
            Stopwatch stopwatch = Stopwatch.createStarted();
            if (submission.contains("dependencies.jar")) {
                task.call();
            } else {
                sDexExecutorService.submit(task).get();
            }
            this.mLogger.verbose("Dexing %1$s took %2$s.", new Object[]{submission, stopwatch.toString()});
        }
        catch (Exception e) {
            if (builder.getMinSdkVersion() >= 24 && !DexProcessBuilder.isMinSdkVersionSupported(this.mTargetInfo.getBuildTools())) {
                this.mLogger.warning("If you are unable to fix the underlying cause of error, dx might have failed because default or static interface methods (requiring minimum sdk version 24), or signature-polymorphic methods (requiring minimum sdk version 26) are used.\nPlease switch to dexing in process or update the build tools to %s.", new Object[]{AndroidBuilder.DEFAULT_BUILD_TOOLS_REVISION.toString()});
            }
            throw new ProcessException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDexExecutorService(DexOptions dexOptions) {
        Object object = LOCK_FOR_DEX;
        synchronized (object) {
            if (sDexExecutorService == null) {
                if (dexOptions.getMaxProcessCount() != null) {
                    DEX_PROCESS_COUNT.set(dexOptions.getMaxProcessCount());
                }
                this.mLogger.verbose("Allocated dexExecutorService of size %1$d.", new Object[]{DEX_PROCESS_COUNT.get()});
                sDexExecutorService = Executors.newFixedThreadPool(DEX_PROCESS_COUNT.get());
            } else if (dexOptions.getMaxProcessCount() != null && dexOptions.getMaxProcessCount().intValue() != DEX_PROCESS_COUNT.get()) {
                this.mLogger.warning("dexOptions is specifying a maximum number of %1$d concurrent dx processes, but the Gradle daemon was initialized with %2$d.\nTo initialize with a different maximum value, first stop the Gradle daemon by calling \u2018gradlew \u2014-stop\u2019.", new Object[]{dexOptions.getMaxProcessCount(), DEX_PROCESS_COUNT.get()});
            }
        }
    }

    synchronized boolean shouldDexInProcess(DexOptions dexOptions) {
        long maxMemory;
        long requiredHeapSizeHeuristic;
        Long requestedHeapSize;
        if (this.mIsDexInProcess != null) {
            return this.mIsDexInProcess;
        }
        if (!dexOptions.getDexInProcess()) {
            this.mIsDexInProcess = false;
            return false;
        }
        if (dexOptions.getJavaMaxHeapSize() != null) {
            requestedHeapSize = PerformanceUtils.parseSizeToBytes(dexOptions.getJavaMaxHeapSize());
            if (requestedHeapSize == null) {
                this.mLogger.warning("Unable to parse dex options size parameter '%1$s', assuming %2$s bytes.", new Object[]{dexOptions.getJavaMaxHeapSize(), 0x40000000L});
                requestedHeapSize = 0x40000000L;
            }
        } else {
            requestedHeapSize = 0x40000000L;
        }
        if ((requiredHeapSizeHeuristic = requestedHeapSize + 0x20000000L) > (maxMemory = PerformanceUtils.getUserDefinedHeapSize())) {
            String dexOptionsComment = "";
            if (dexOptions.getJavaMaxHeapSize() != null) {
                dexOptionsComment = String.format(" (based on the dexOptions.javaMaxHeapSize = %s)", dexOptions.getJavaMaxHeapSize());
            }
            this.mLogger.warning("\nRunning dex as a separate process.\n\nTo run dex in process, the Gradle daemon needs a larger heap.\nIt currently has %1$d MB.\nFor faster builds, increase the maximum heap size for the Gradle daemon to at least %2$s MB%3$s.\nTo do this set org.gradle.jvmargs=-Xmx%2$sM in the project gradle.properties.\nFor more information see https://docs.gradle.org/current/userguide/build_environment.html\n", new Object[]{maxMemory / 0x100000L, (requiredHeapSizeHeuristic - 1L) / 0x100000L + 1L, dexOptionsComment});
            this.mIsDexInProcess = false;
            return false;
        }
        this.mIsDexInProcess = true;
        return true;
    }

    private static boolean checkLibraryClassesJar(File input) throws IOException {
        if (!input.exists()) {
            return false;
        }
        if (input.isDirectory()) {
            return DexByteCodeConverter.checkFolder(input);
        }
        try (ZipFile zipFile = new ZipFile(input);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.endsWith(".class") && !name.endsWith(".dex")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static boolean checkFolder(File folder) {
        File[] subFolders = folder.listFiles();
        if (subFolders != null) {
            for (File childFolder : subFolders) {
                String name;
                if (childFolder.isFile() && ((name = childFolder.getName()).endsWith(".class") || name.endsWith(".dex"))) {
                    return true;
                }
                if (!childFolder.isDirectory() || !DexByteCodeConverter.checkFolder(childFolder)) continue;
                return true;
            }
        }
        return false;
    }
}

