/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import java.util.Map;
import java.util.TreeMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Marker {
    private static final String kPrefix = "~~";
    private static final String kD8prefix = "~~" + (Object)((Object)Tool.D8) + "{";
    private static final String kR8prefix = "~~" + (Object)((Object)Tool.R8) + "{";
    private final TreeMap<String, Object> content;
    private final Tool tool;

    public Marker(Tool tool) {
        this.tool = tool;
        this.content = new TreeMap();
    }

    private Marker(Tool tool, JSONObject object) {
        this.tool = tool;
        this.content = new TreeMap();
        for (Object e : object.entrySet()) {
            Map.Entry entry = (Map.Entry)e;
            this.content.put(String.valueOf(entry.getKey()), entry.getValue());
        }
    }

    public Marker put(String key, int value) {
        return this.internalPut(key, new Long(value));
    }

    public Marker put(String key, String value) {
        return this.internalPut(key, value);
    }

    private Marker internalPut(String key, Object value) {
        assert (key != null && value != null);
        assert (!this.content.containsKey(key));
        this.content.put(key, value);
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(kPrefix + (Object)((Object)this.tool));
        boolean first = true;
        sb.append('{');
        for (String key : this.content.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(JSONObject.toString((String)key, (Object)this.content.get(key)));
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Marker) {
            Marker other = (Marker)obj;
            return this.tool == other.tool && this.content.equals(other.content);
        }
        return false;
    }

    public int hashCode() {
        return this.tool.hashCode() + 3 * this.content.hashCode();
    }

    public static Marker parse(String str) {
        if (str.startsWith(kD8prefix)) {
            return Marker.internalParse(Tool.D8, str.substring(kD8prefix.length() - 1));
        }
        if (str.startsWith(kR8prefix)) {
            return Marker.internalParse(Tool.R8, str.substring(kR8prefix.length() - 1));
        }
        return null;
    }

    private static Marker internalParse(Tool tool, String str) {
        try {
            Object result = new JSONParser().parse(str);
            if (result instanceof JSONObject) {
                return new Marker(tool, (JSONObject)result);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public static enum Tool {
        D8,
        R8;

    }
}

