/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.core.DexOptions;
import com.android.builder.core.DexProcessBuilder;
import com.android.dx.command.dexer.DxContext;
import com.android.dx.command.dexer.Main;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;

public class DexWrapper {
    /*
     * Loose catch block
     */
    public static ProcessResult run(DexProcessBuilder processBuilder, DexOptions dexOptions, ProcessOutputHandler outputHandler) throws IOException, ProcessException {
        ProcessOutput output = null;
        try {
            try (ProcessOutput ignored = output = outputHandler.createOutput();){
                DxContext dxContext = new DxContext(output.getStandardOutput(), output.getErrorOutput());
                Main.Arguments args = DexWrapper.buildArguments(processBuilder, dexOptions, dxContext);
                DexProcessResult dexProcessResult = new DexProcessResult(new Main(dxContext).runDx(args));
                return dexProcessResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (output != null) {
                outputHandler.handleOutput(output);
            }
        }
    }

    private static Main.Arguments buildArguments(DexProcessBuilder processBuilder, DexOptions dexOptions, DxContext dxContext) throws ProcessException {
        Main.Arguments args = new Main.Arguments(dxContext);
        args.fileNames = (String[])Iterables.toArray(processBuilder.getFilesToAdd(), String.class);
        if (processBuilder.getOutputFile().isDirectory() && !processBuilder.isMultiDex()) {
            args.outName = new File(processBuilder.getOutputFile(), "classes.dex").getPath();
            args.jarOutput = false;
        } else {
            String outputFileAbsolutePath;
            args.outName = outputFileAbsolutePath = processBuilder.getOutputFile().getAbsolutePath();
            args.jarOutput = outputFileAbsolutePath.endsWith(".jar");
        }
        args.multiDex = processBuilder.isMultiDex();
        if (processBuilder.getMainDexList() != null) {
            args.mainDexListFile = processBuilder.getMainDexList().getPath();
        }
        args.verbose = processBuilder.isVerbose();
        args.optimize = true;
        args.numThreads = (Integer)MoreObjects.firstNonNull((Object)dexOptions.getThreadCount(), (Object)4);
        args.forceJumbo = dexOptions.getJumboMode();
        args.minSdkVersion = processBuilder.getMinSdkVersion();
        args.parseFlags((String[])Iterables.toArray(dexOptions.getAdditionalParameters(), String.class));
        args.makeOptionsObjects();
        return args;
    }

    private static class DexProcessResult
    implements ProcessResult {
        private int mExitValue;

        DexProcessResult(int exitValue) {
            this.mExitValue = exitValue;
        }

        public ProcessResult assertNormalExitValue() throws ProcessException {
            if (this.mExitValue != 0) {
                throw new ProcessException(String.format("Return code %d for dex process", this.mExitValue));
            }
            return this;
        }

        public int getExitValue() {
            return this.mExitValue;
        }

        public ProcessResult rethrowFailure() throws ProcessException {
            return this.assertNormalExitValue();
        }
    }
}

