/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.utils;

import com.android.builder.utils.ExceptionConsumer;
import com.android.builder.utils.ExceptionFunction;
import com.android.ide.common.util.ReadWriteProcessLock;
import com.android.ide.common.util.ReadWriteThreadLock;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutionException;

public final class SynchronizedFile {
    private static final String LOCK_FILE_EXTENSION = ".lock";
    private final File fileToSynchronize;
    private final LockingScope lockingScope;

    private SynchronizedFile(File fileToSynchronize, LockingScope lockingScope) {
        this.fileToSynchronize = fileToSynchronize;
        this.lockingScope = lockingScope;
    }

    public static SynchronizedFile getInstanceWithMultiProcessLocking(File fileToSynchronize) {
        try {
            fileToSynchronize = fileToSynchronize.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Preconditions.checkArgument((boolean)FileUtils.parentDirExists((File)fileToSynchronize), (Object)("Parent directory of " + fileToSynchronize.getAbsolutePath() + " does not exist"));
        File lockFile = new File(fileToSynchronize.getParent(), fileToSynchronize.getName() + LOCK_FILE_EXTENSION);
        Preconditions.checkArgument((!lockFile.exists() || lockFile.isFile() && lockFile.length() == 0L ? 1 : 0) != 0, (Object)("Unexpected lock file found: " + lockFile.getAbsolutePath() + " with length=" + lockFile.length()));
        return new SynchronizedFile(fileToSynchronize, LockingScope.MULTI_PROCESS);
    }

    public static SynchronizedFile getInstanceWithSingleProcessLocking(File fileToSynchronize) {
        try {
            fileToSynchronize = fileToSynchronize.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new SynchronizedFile(fileToSynchronize, LockingScope.SINGLE_PROCESS);
    }

    public <V> V read(ExceptionFunction<File, V> action) throws ExecutionException {
        if (this.lockingScope == LockingScope.MULTI_PROCESS) {
            return this.doActionWithMultiProcessLocking(LockingType.SHARED, action);
        }
        return this.doActionWithSingleProcessLocking(LockingType.SHARED, action);
    }

    public <V> V write(ExceptionFunction<File, V> action) throws ExecutionException {
        if (this.lockingScope == LockingScope.MULTI_PROCESS) {
            return this.doActionWithMultiProcessLocking(LockingType.EXCLUSIVE, action);
        }
        return this.doActionWithSingleProcessLocking(LockingType.EXCLUSIVE, action);
    }

    private <V> V doActionWithMultiProcessLocking(LockingType lockingType, ExceptionFunction<File, V> action) throws ExecutionException {
        File lockFile = new File(this.fileToSynchronize.getParent(), this.fileToSynchronize.getName() + LOCK_FILE_EXTENSION);
        ReadWriteProcessLock readWriteProcessLock = new ReadWriteProcessLock(lockFile);
        ReadWriteProcessLock.Lock lock = lockingType == LockingType.SHARED ? readWriteProcessLock.readLock() : readWriteProcessLock.writeLock();
        try {
            lock.lock();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            V e = action.accept(this.fileToSynchronize);
            return e;
        }
        catch (Exception exception) {
            throw new ExecutionException(exception);
        }
        finally {
            try {
                lock.unlock();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private <V> V doActionWithSingleProcessLocking(LockingType lockingType, ExceptionFunction<File, V> action) throws ExecutionException {
        ReadWriteThreadLock readWriteThreadLock = new ReadWriteThreadLock((Object)this.fileToSynchronize);
        ReadWriteThreadLock.Lock lock = lockingType == LockingType.SHARED ? readWriteThreadLock.readLock() : readWriteThreadLock.writeLock();
        lock.lock();
        try {
            V v = action.accept(this.fileToSynchronize);
            return v;
        }
        catch (Exception exception) {
            throw new ExecutionException(exception);
        }
        finally {
            lock.unlock();
        }
    }

    public void createIfAbsent(ExceptionConsumer<File> action) throws ExecutionException {
        boolean fileExists;
        try {
            fileExists = this.read(File::exists);
        }
        catch (ExecutionException exception) {
            throw new RuntimeException(exception);
        }
        if (!fileExists) {
            try {
                this.write(file -> {
                    if (!file.exists()) {
                        try {
                            action.accept((File)file);
                        }
                        catch (Exception exception) {
                            throw new ActionExecutionException(exception);
                        }
                        Preconditions.checkState((boolean)file.exists(), (Object)("File " + file.getAbsolutePath() + " should have been created but has not"));
                    }
                    return null;
                });
            }
            catch (ExecutionException exception) {
                for (Throwable exceptionInCausalChain : Throwables.getCausalChain((Throwable)exception)) {
                    if (!(exceptionInCausalChain instanceof ActionExecutionException)) continue;
                    throw exception;
                }
                throw new RuntimeException(exception);
            }
        }
    }

    private static final class ActionExecutionException
    extends ExecutionException {
        public ActionExecutionException(Exception exception) {
            super(exception);
        }
    }

    static enum LockingType {
        SHARED,
        EXCLUSIVE;

    }

    static enum LockingScope {
        MULTI_PROCESS,
        SINGLE_PROCESS;

    }
}

