/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OffOrAuto;
import com.android.tools.r8.utils.OutputMode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;

public class D8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: d8 [options] <input-files>", (Object)" where <input-files> are any combination of dex, class, zip, jar, or apk files", (Object)" and options are:", (Object)"  --debug                 # Compile with debugging information (default).", (Object)"  --release               # Compile without debugging information.", (Object)"  --output <file>         # Output result in <outfile>.", (Object)"                          # <file> must be an existing directory or a zip file.", (Object)"  --lib <file>            # Add <file> as a library resource.", (Object)"  --classpath <file>      # Add <file> as a classpath resource.", (Object)"  --min-api               # Minimum Android API level compatibility", (Object)"  --intermediate          # Compile an intermediate result intended for later", (Object)"                          # merging.", (Object[])new String[]{"  --file-per-class        # Produce a separate dex file per class", "  --main-dex-list <file>  # List of classes to place in the primary dex file.", "  --version               # Print the version of d8.", "  --help                  # Print this message."}));
    private boolean intermediate = false;

    public static Builder builder() {
        return new Builder();
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static Builder parse(String[] args) throws CompilationException, IOException {
        CompilationMode modeSet = null;
        Path outputPath = null;
        Builder builder = D8Command.builder();
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.equals("--version")) {
                    builder.setPrintVersion(true);
                    continue;
                }
                if (arg.equals("--debug")) {
                    if (modeSet == CompilationMode.RELEASE) {
                        throw new CompilationException("Cannot compile in both --debug and --release mode.");
                    }
                    builder.setMode(CompilationMode.DEBUG);
                    modeSet = CompilationMode.DEBUG;
                    continue;
                }
                if (arg.equals("--release")) {
                    if (modeSet == CompilationMode.DEBUG) {
                        throw new CompilationException("Cannot compile in both --debug and --release mode.");
                    }
                    builder.setMode(CompilationMode.RELEASE);
                    modeSet = CompilationMode.RELEASE;
                    continue;
                }
                if (arg.equals("--file-per-class")) {
                    builder.setOutputMode(OutputMode.FilePerClass);
                    continue;
                }
                if (arg.equals("--output")) {
                    String output = args[++i];
                    if (outputPath != null) {
                        throw new CompilationException("Cannot output both to '" + outputPath.toString() + "' and '" + output + "'");
                    }
                    outputPath = Paths.get(output, new String[0]);
                    continue;
                }
                if (arg.equals("--lib")) {
                    builder.addLibraryFiles(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--classpath")) {
                    builder.addClasspathFiles(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--main-dex-list")) {
                    builder.addMainDexListFiles(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--min-api")) {
                    builder.setMinApiLevel(Integer.valueOf(args[++i]));
                    continue;
                }
                if (arg.equals("--intermediate")) {
                    builder.setIntermediate(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    throw new CompilationException("Unknown option: " + arg);
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
            return (Builder)builder.setOutputPath(outputPath);
        }
        catch (CompilationError e) {
            throw new CompilationException(e.getMessage(), e);
        }
    }

    private D8Command(AndroidApp inputApp, Path outputPath, OutputMode outputMode, CompilationMode mode, int minApiLevel, boolean intermediate) {
        super(inputApp, outputPath, outputMode, mode, minApiLevel);
        this.intermediate = intermediate;
    }

    private D8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(new DexItemFactory());
        assert (!internal.debug);
        internal.minimalMainDex = internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.minApiLevel = this.getMinApiLevel();
        internal.intermediate = this.intermediate;
        assert (!internal.skipMinification);
        internal.skipMinification = true;
        assert (internal.useTreeShaking);
        internal.useTreeShaking = false;
        assert (internal.interfaceMethodDesugaring == OffOrAuto.Off);
        assert (internal.tryWithResourcesDesugaring == OffOrAuto.Off);
        assert (internal.inlineAccessors);
        internal.inlineAccessors = false;
        assert (internal.removeSwitchMaps);
        internal.removeSwitchMaps = false;
        assert (internal.outline.enabled);
        internal.outline.enabled = false;
        internal.outputMode = this.getOutputMode();
        return internal;
    }

    public static class Builder
    extends BaseCompilerCommand.Builder<D8Command, Builder> {
        private boolean intermediate = false;

        protected Builder(boolean ignoreDexInArchive) {
            super(CompilationMode.DEBUG, ignoreDexInArchive);
        }

        protected Builder() {
            super(CompilationMode.DEBUG);
        }

        private Builder(AndroidApp app) {
            super(app, CompilationMode.DEBUG);
        }

        public Builder addClasspathFiles(Path ... files) throws IOException {
            this.getAppBuilder().addClasspathFiles(files);
            return this.self();
        }

        public Builder addClasspathFiles(Collection<Path> files) throws IOException {
            this.getAppBuilder().addClasspathFiles(files);
            return this.self();
        }

        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider) {
            this.getAppBuilder().addClasspathResourceProvider(provider);
            return this.self();
        }

        public Builder setIntermediate(boolean value) {
            this.intermediate = value;
            return this.self();
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        protected void validate() throws CompilationException {
            super.validate();
            if (this.getAppBuilder().hasMainDexList() && this.intermediate) {
                throw new CompilationException("Option --main-dex-list cannot be used with --intermediate");
            }
        }

        @Override
        public D8Command build() throws CompilationException {
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new D8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            this.validate();
            return new D8Command(this.getAppBuilder().build(), this.getOutputPath(), this.getOutputMode(), this.getMode(), this.getMinApiLevel(), this.intermediate);
        }
    }
}

