/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Paths;

public class ReadKeepFile {
    private static final String DEFAULT_KEEP_FILE_NAME = "build/proguard.cfg";
    final Timing timing = new Timing("ReadKeepFile");

    private void readProguardKeepFile(String fileName) throws ProguardRuleParserException {
        try {
            System.out.println("  - reading " + fileName);
            this.timing.begin("Reading " + fileName);
            new ProguardConfigurationParser(new DexItemFactory()).parse(Paths.get(fileName, new String[0]));
            this.timing.end();
        }
        catch (IOException e) {
            System.err.print("Failed to parse Proguard keep file: " + e.getMessage());
        }
    }

    public static void main(String[] args) throws ProguardRuleParserException {
        new ReadKeepFile().run(args);
    }

    private void run(String[] args) throws ProguardRuleParserException {
        System.out.println("ProguardKeepRuleParser benchmark.");
        if (args.length == 0) {
            this.readProguardKeepFile(DEFAULT_KEEP_FILE_NAME);
        } else {
            for (String name : args) {
                this.readProguardKeepFile(name);
            }
        }
        this.timing.report();
    }
}

