/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.Resource;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAccessFlags;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.function.Consumer;

public abstract class DexClass
extends DexItem {
    private static final DexEncodedMethod[] NO_METHODS = new DexEncodedMethod[0];
    private static final DexEncodedField[] NO_FIELDS = new DexEncodedField[0];
    public final Resource.Kind origin;
    public final DexType type;
    public final DexAccessFlags accessFlags;
    public DexType superType;
    public DexTypeList interfaces;
    public final DexString sourceFile;
    protected DexEncodedField[] staticFields;
    protected DexEncodedField[] instanceFields;
    protected DexEncodedMethod[] directMethods;
    protected DexEncodedMethod[] virtualMethods;
    public DexAnnotationSet annotations;

    public DexClass(DexString sourceFile, DexTypeList interfaces, DexAccessFlags accessFlags, DexType superType, DexType type, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods, DexAnnotationSet annotations, Resource.Kind origin) {
        this.origin = origin;
        this.sourceFile = sourceFile;
        this.interfaces = interfaces;
        this.accessFlags = accessFlags;
        this.superType = superType;
        this.type = type;
        this.setStaticFields(staticFields);
        this.setInstanceFields(instanceFields);
        this.setDirectMethods(directMethods);
        this.setVirtualMethods(virtualMethods);
        this.annotations = annotations;
        if (type == superType) {
            throw new CompilationError("Class " + type.toString() + " cannot extend itself");
        }
        for (DexType interfaceType : interfaces.values) {
            if (type != interfaceType) continue;
            throw new CompilationError("Interface " + type.toString() + " cannot implement itself");
        }
        if (!type.descriptor.isValidClassDescriptor()) {
            throw new CompilationError("Class descriptor '" + type.descriptor.toString() + "' cannot be represented in dex format.");
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        throw new Unreachable();
    }

    public DexEncodedMethod[] directMethods() {
        return this.directMethods;
    }

    public void setDirectMethods(DexEncodedMethod[] values) {
        this.directMethods = (DexEncodedMethod[])MoreObjects.firstNonNull((Object)values, (Object)NO_METHODS);
    }

    public DexEncodedMethod[] virtualMethods() {
        return this.virtualMethods;
    }

    public void setVirtualMethods(DexEncodedMethod[] values) {
        this.virtualMethods = (DexEncodedMethod[])MoreObjects.firstNonNull((Object)values, (Object)NO_METHODS);
    }

    public void forEachMethod(Consumer<DexEncodedMethod> consumer) {
        for (DexEncodedMethod method : this.directMethods()) {
            consumer.accept(method);
        }
        for (DexEncodedMethod method : this.virtualMethods()) {
            consumer.accept(method);
        }
    }

    public DexEncodedMethod[] allMethodsSorted() {
        int vLen = this.virtualMethods().length;
        int dLen = this.directMethods().length;
        DexEncodedMethod[] result = new DexEncodedMethod[vLen + dLen];
        System.arraycopy(this.virtualMethods(), 0, result, 0, vLen);
        System.arraycopy(this.directMethods(), 0, result, vLen, dLen);
        Arrays.sort(result, (a, b) -> a.method.slowCompareTo(b.method));
        return result;
    }

    public void forEachField(Consumer<DexEncodedField> consumer) {
        for (DexEncodedField field : this.staticFields()) {
            consumer.accept(field);
        }
        for (DexEncodedField field : this.instanceFields()) {
            consumer.accept(field);
        }
    }

    public DexEncodedField[] staticFields() {
        return this.staticFields;
    }

    public void setStaticFields(DexEncodedField[] values) {
        this.staticFields = (DexEncodedField[])MoreObjects.firstNonNull((Object)values, (Object)NO_FIELDS);
    }

    public DexEncodedField[] instanceFields() {
        return this.instanceFields;
    }

    public void setInstanceFields(DexEncodedField[] values) {
        this.instanceFields = (DexEncodedField[])MoreObjects.firstNonNull((Object)values, (Object)NO_FIELDS);
    }

    public DexEncodedMethod findDirectTarget(DexMethod method) {
        return (DexEncodedMethod)this.findTarget(this.directMethods(), method);
    }

    public DexEncodedField findStaticTarget(DexField field) {
        return (DexEncodedField)this.findTarget(this.staticFields(), field);
    }

    public DexEncodedMethod findVirtualTarget(DexMethod method) {
        return (DexEncodedMethod)this.findTarget(this.virtualMethods(), method);
    }

    public DexEncodedField findInstanceTarget(DexField field) {
        return (DexEncodedField)this.findTarget(this.instanceFields(), field);
    }

    private <T extends DexItem, S extends Descriptor<T, S>> T findTarget(T[] items, S descriptor) {
        for (T entry : items) {
            if (!descriptor.match(entry)) continue;
            return entry;
        }
        return null;
    }

    public boolean isInterface() {
        return this.accessFlags.isInterface();
    }

    public abstract void addDependencies(MixedSectionCollection var1);

    public boolean isProgramClass() {
        return false;
    }

    public DexProgramClass asProgramClass() {
        return null;
    }

    public boolean isClasspathClass() {
        return false;
    }

    public boolean isLibraryClass() {
        return false;
    }

    public DexLibraryClass asLibraryClass() {
        return null;
    }

    public DexEncodedMethod getClassInitializer() {
        return Arrays.stream(this.directMethods()).filter(DexEncodedMethod::isClassInitializer).findAny().orElse(null);
    }

    public Resource.Kind getOrigin() {
        return this.origin;
    }

    public boolean hasClassInitializer() {
        return this.getClassInitializer() != null;
    }

    public boolean hasTrivialClassInitializer() {
        DexEncodedMethod clinit = this.getClassInitializer();
        return clinit != null && clinit.getCode() != null && clinit.getCode().asDexCode().isEmptyVoidMethod();
    }

    public boolean hasNonTrivialClassInitializer() {
        DexEncodedMethod clinit = this.getClassInitializer();
        if (clinit == null || clinit.getCode() == null) {
            return false;
        }
        if (clinit.getCode().isDexCode()) {
            return !clinit.getCode().asDexCode().isEmptyVoidMethod();
        }
        return true;
    }

    public boolean defaultValuesForStaticFieldsMayTriggerAllocation() {
        return Arrays.stream(this.staticFields()).anyMatch(field -> !field.staticValue.mayTriggerAllocation());
    }
}

