/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEntry;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.MoveType;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DexDebugEntryBuilder {
    private int currentPc = 0;
    private int currentLine;
    private DexString currentFile = null;
    private boolean prologueEnd = false;
    private boolean epilogueBegin = false;
    private final Map<Integer, LocalEntry> locals = new HashMap<Integer, LocalEntry>();
    private final Int2ReferenceMap<DebugLocalInfo> arguments = new Int2ReferenceArrayMap();
    private DexDebugEntry pending = null;
    private final Map<DebugLocalInfo, DebugLocalInfo> canonicalizedLocals = new HashMap<DebugLocalInfo, DebugLocalInfo>();
    private List<DexDebugEntry> entries = new ArrayList<DexDebugEntry>();

    public DexDebugEntryBuilder(int startLine) {
        this.currentLine = startLine;
    }

    public DexDebugEntryBuilder(DexEncodedMethod method, DexItemFactory factory) {
        DexCode code = method.getCode().asDexCode();
        DexDebugInfo info = code.getDebugInfo();
        int argumentRegister = code.registerSize - code.incomingRegisterSize;
        if (!method.accessFlags.isStatic()) {
            DexString name = factory.thisName;
            DexType type = method.method.getHolder();
            this.startArgument(argumentRegister, name, type);
            argumentRegister += MoveType.fromDexType(type).requiredRegisters();
        }
        DexType[] types = method.method.proto.parameters.values;
        DexString[] names = info.parameters;
        for (int i = 0; i < types.length; ++i) {
            if (names[i] != null) {
                this.startArgument(argumentRegister, names[i], types[i]);
            }
            argumentRegister += MoveType.fromDexType(types[i]).requiredRegisters();
        }
        this.currentLine = info.startLine;
        for (DexDebugEvent event : info.events) {
            event.addToBuilder(this);
        }
    }

    public Int2ReferenceMap<DebugLocalInfo> getArguments() {
        return this.arguments;
    }

    public void setFile(DexString file) {
        this.currentFile = file;
    }

    public void advancePC(int pcDelta) {
        assert (pcDelta >= 0);
        this.currentPc += pcDelta;
    }

    public void advanceLine(int line) {
        this.currentLine += line;
    }

    public void endPrologue() {
        this.prologueEnd = true;
    }

    public void beginEpilogue() {
        this.epilogueBegin = true;
    }

    public void startArgument(int register, DexString name, DexType type) {
        DebugLocalInfo argument = this.canonicalize(name, type, null);
        this.arguments.put(register, (Object)argument);
        this.getEntry(register).set(argument);
    }

    public void startLocal(int register, DexString name, DexType type, DexString signature) {
        this.getEntry(register).set(this.canonicalize(name, type, signature));
    }

    public void endLocal(int register) {
        this.getEntry(register).unset();
    }

    public void restartLocal(int register) {
        this.getEntry(register).reset();
    }

    public void setPosition(int pcDelta, int lineDelta) {
        assert (pcDelta >= 0);
        if (this.pending != null) {
            this.entries.add(new DexDebugEntry(this.pending.address, this.pending.line, this.pending.sourceFile, this.pending.prologueEnd, this.pending.epilogueBegin, this.getLocals()));
        }
        this.currentPc += pcDelta;
        this.currentLine += lineDelta;
        this.pending = new DexDebugEntry(this.currentPc, this.currentLine, this.currentFile, this.prologueEnd, this.epilogueBegin, null);
        this.prologueEnd = false;
        this.epilogueBegin = false;
    }

    public List<DexDebugEntry> build() {
        if (this.pending != null) {
            this.setPosition(0, 0);
            this.pending = null;
        }
        List<DexDebugEntry> result = this.entries;
        this.entries = null;
        return result;
    }

    private DebugLocalInfo canonicalize(DexString name, DexType type, DexString signature) {
        DebugLocalInfo local = new DebugLocalInfo(name, type, signature);
        DebugLocalInfo canonical = this.canonicalizedLocals.putIfAbsent(local, local);
        return canonical != null ? canonical : local;
    }

    private LocalEntry getEntry(int register) {
        LocalEntry entry = this.locals.get(register);
        if (entry == null) {
            entry = new LocalEntry();
            this.locals.put(register, entry);
        }
        return entry;
    }

    private ImmutableMap<Integer, DebugLocalInfo> getLocals() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Integer, LocalEntry> mapEntry : this.locals.entrySet()) {
            Integer register = mapEntry.getKey();
            LocalEntry entry = mapEntry.getValue();
            if (entry.current == null) continue;
            builder.put((Object)register, (Object)entry.current);
        }
        return builder.build();
    }

    private static class LocalEntry {
        DebugLocalInfo current;
        DebugLocalInfo last;

        private LocalEntry() {
        }

        void set(DebugLocalInfo value) {
            this.current = value;
            this.last = value;
        }

        void unset() {
            this.current = null;
        }

        void reset() {
            this.current = this.last;
        }
    }
}

